/*
# ############################################
# $Revision: 17 $
# $Date: 2012-06-27 14:59:09 +0200 (sre, 27 jun 2012) $
#
# Author: Robert Meolic, meolic@uni-mb.si
#
# This file (mi.c) has been released into the public domain by
# the author.
#
# The author grants any entity the right to use this work
# for any purpose, without any conditions, unless such
# conditions are required by law.
#
# myinterface is used in EST project
# Homepage: http://lms.uni-mb.si/EST/
#
# Updates of myinterface from Robert Meolic
# are available in SVN repository:
# http://altair.uni-mb.si:8080/
# ############################################
*/

/*
gcc -g -I`ls -d1 /usr/include/tcl* | tail -n 1` -o mi.exe mi.c -L/usr/lib -ltcl8.5 -ltk8.5
*/

#include <stdio.h>
#include <stdlib.h>
#include <tcl.h>
#include <tk.h>

int AppInit(Tcl_Interp *interp) {
  if(Tcl_Init(interp) == TCL_ERROR) return TCL_ERROR;
  if(Tk_Init(interp) == TCL_ERROR) return TCL_ERROR;
  Tcl_Eval(interp,"lappend auto_path [file dirname [info nameofexecutable]]");
  Tcl_PkgRequire(interp,"myinterface","1",0);
  Tcl_EvalFile(interp,"testDialog.tcl");
  return TCL_OK;
}

int main(int argc, char *argv[]) {
  Tk_Main(argc, argv, AppInit);
  return 0;
}
