/*
 * Decompiled with CFR 0.152.
 */
package org.natto;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.PrintWriter;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Properties;
import java.util.Set;
import java.util.UUID;
import org.natto.ExecSecurity;
import org.natto.StaticTools;
import org.natto.Sysinfo;

public class Infofiles {
    static final String internalUnique = UUID.randomUUID().toString();
    private Sysinfo mySysinfo = new Sysinfo();

    public String writeInfoFile(String dirName, int jobsInMe, HashMap prgs) {
        String infoFname = Infofiles.getUniqFileName();
        String os = System.getProperty("os.name");
        String osVer = System.getProperty("os.version");
        int cores = this.mySysinfo.getCores();
        int mhz = this.mySysinfo.getMhz();
        int memMeg = this.mySysinfo.getMemMeg();
        long freeDiskMegs = this.mySysinfo.getFreeDiskMeg();
        String hostName = this.mySysinfo.getHostName();
        String userName = System.getProperty("user.name");
        ExecSecurity mySecurity = ExecSecurity.getInstance();
        String acceptedSigners = "*";
        if (mySecurity.securityOn()) {
            acceptedSigners = mySecurity.getSigners();
            acceptedSigners = acceptedSigners.trim();
            acceptedSigners = acceptedSigners.replace("\n", " -- ");
        }
        try {
            File myFile = new File(dirName + "/" + infoFname);
            if (myFile.exists()) {
                myFile.delete();
            }
        }
        catch (Exception e) {
            System.out.println("Cannot delete old info file");
            e.printStackTrace();
        }
        try {
            PrintWriter writer = new PrintWriter(dirName + "/" + infoFname, "UTF-8");
            long epoch = StaticTools.getEpoch();
            writer.println("timestamp=" + epoch);
            writer.println("tasks=" + jobsInMe);
            writer.println("os=" + os);
            writer.println("os_version=" + osVer);
            writer.println("cores=" + cores);
            writer.println("mhz=" + mhz);
            writer.println("mmem=" + memMeg);
            writer.println("diskfree=" + freeDiskMegs);
            writer.println("name=" + hostName);
            writer.println("user=" + userName);
            writer.println("signers=" + acceptedSigners);
            Set keySet = prgs.keySet();
            for (String key : keySet) {
                String[] prgInfo = (String[])prgs.get(key);
                String prgName = prgInfo[0];
                String prgCmd = prgInfo[1];
                writer.println(key + "=" + prgName + " " + prgCmd);
            }
            writer.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return infoFname;
    }

    private static String getUniqFileName() {
        String line;
        int i;
        String userName = System.getProperty("user.name").trim().replace(" ", "");
        String uniqueID = internalUnique + ".info";
        try {
            File ethAddf = new File("/sys/class/net/eth0/address");
            if (ethAddf.exists()) {
                BufferedReader myReader = new BufferedReader(new FileReader(ethAddf));
                String ethMac = myReader.readLine();
                myReader.close();
                ethMac = ethMac.replace(":", "");
                return ethMac + userName + ".info";
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        String cmd = "reg query HKLM\\SYSTEM\\CurrentControlSet\\Control\\Class\\{4D36E972-E325-11CE-BFC1-08002BE10318} /s";
        String output = StaticTools.execGet(cmd, false);
        String[] lines = output.split("\\n");
        for (i = 0; i < lines.length; ++i) {
            int dashPos;
            line = lines[i];
            if (!line.contains("NetCfgInstanceId") || (dashPos = line.lastIndexOf(45)) <= 0) continue;
            String myUni = line.substring(dashPos + 1);
            myUni = myUni.trim();
            myUni = myUni.substring(0, myUni.length() - 1);
            return myUni + userName + ".info";
        }
        cmd = "ifconfig";
        output = StaticTools.execGet(cmd, false);
        lines = output.split("\\n");
        for (i = 0; i < lines.length; ++i) {
            line = lines[i];
            int etherPos = line.indexOf("ether");
            if (etherPos <= -1 || line.length() <= etherPos + 6) continue;
            String physAdd = line.substring(etherPos + 6);
            physAdd = physAdd.replace(":", "");
            physAdd = physAdd.trim();
            System.out.println(physAdd);
            return physAdd + userName + ".info";
        }
        return uniqueID;
    }

    public static HashMap checkInfoFiles(String dirName, String secIdent, int seconds) {
        HashMap<String, Properties> hm = new HashMap<String, Properties>();
        File folder = new File(dirName);
        File[] listOfFiles = folder.listFiles();
        if (listOfFiles == null) {
            return hm;
        }
        for (int i = 0; i < listOfFiles.length; ++i) {
            String fName;
            if (!listOfFiles[i].isFile() || !(fName = listOfFiles[i].getName()).endsWith(".info")) continue;
            try {
                boolean secOK = true;
                Properties myProp = new Properties();
                myProp.load(new FileInputStream(listOfFiles[i]));
                String acceptedSigners = myProp.getProperty("signers");
                if ("".equals(secIdent) && !"*".equals(acceptedSigners)) {
                    secOK = false;
                }
                if (secIdent.length() > 0) {
                    int myPosInSec;
                    secOK = "*".equals(acceptedSigners) ? true : (myPosInSec = acceptedSigners.indexOf(secIdent)) > -1;
                }
                String tStamp = myProp.getProperty("timestamp");
                long timeFile = Long.parseLong(tStamp);
                long secondsSinceEpoch = StaticTools.getEpoch();
                if (secondsSinceEpoch - timeFile >= (long)seconds) continue;
                if (secOK) {
                    hm.put(fName, myProp);
                    continue;
                }
                System.out.println(fName + " rejected by " + "security policy.");
                continue;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return hm;
    }

    public static String getHostProperty(HashMap hm, String infoFileName, String propName) {
        if (!hm.containsKey(infoFileName)) {
            return null;
        }
        Properties myProp = (Properties)hm.get(infoFileName);
        if (!myProp.containsKey(propName)) {
            return null;
        }
        return myProp.getProperty(propName);
    }

    public long getInfoNumProperty(HashMap myHm, String mySearch) {
        Set keySet = myHm.keySet();
        Iterator keyIt = keySet.iterator();
        long cumSum = 0L;
        while (keyIt.hasNext()) {
            try {
                String fName = (String)keyIt.next();
                Properties myProp = (Properties)myHm.get(fName);
                cumSum += Long.parseLong(myProp.getProperty(mySearch, "0"));
            }
            catch (Exception e) {}
        }
        return cumSum;
    }

    public static String getSupportedExt(HashMap myHm) {
        String ret = "";
        HashMap<String, String> uniQr = new HashMap<String, String>();
        Set keySet = myHm.keySet();
        Iterator keyIt = keySet.iterator();
        while (keyIt.hasNext()) {
            try {
                String fName = (String)keyIt.next();
                Properties myProp = (Properties)myHm.get(fName);
                Enumeration<?> myEnum = myProp.propertyNames();
                while (myEnum.hasMoreElements()) {
                    String pKey = (String)myEnum.nextElement();
                    if (!pKey.startsWith(".")) continue;
                    uniQr.put(pKey, pKey);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        Set ukeySet = uniQr.keySet();
        for (String k : ukeySet) {
            String uKey = (String)uniQr.get(k);
            ret = ret + " " + uKey;
        }
        ret = ret.trim();
        return ret;
    }

    public static String getPrgForExt(String ext, HashMap myHm) {
        String extPrg = "";
        Set keySet = myHm.keySet();
        Iterator keyIt = keySet.iterator();
        while (keyIt.hasNext()) {
            try {
                String fName = (String)keyIt.next();
                Properties myProp = (Properties)myHm.get(fName);
                String val = myProp.getProperty(ext);
                if (val == null) continue;
                String[] valParts = val.split(" ");
                extPrg = valParts[0];
                break;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return extPrg;
    }
}

