
!define PRODUCT_VERSION "1b7-1"

; *** registry settings ***
!define KEY_VERSION "version"
!define SCM_KEY "Software\Voluntocracy\scm"
!define FREESNELL_KEY "Software\Voluntocracy\FreeSnell"

; Script generated by the HM NIS Edit Script Wizard.

; HM NIS Edit Wizard helper defines
!define PRODUCT_NAME "FreeSnell"
;!define PRODUCT_COMPANY "Voluntocracy"
!define PRODUCT_PUBLISHER "Aubrey Jaffer"
!define PRODUCT_WEB_SITE "http://swiss.csail.mit.edu/~jaffer/FreeSnell"
!define PRODUCT_UNINST_KEY "Software\Microsoft\Windows\CurrentVersion\Uninstall\${PRODUCT_NAME}"
!define PRODUCT_UNINST_ROOT_KEY "HKLM"
!define PRODUCT_STARTMENU_REGVAL "NSIS:StartMenuDir"

; MUI 1.67 compatible ------
!include "MUI.nsh"

; MUI Settings
!define MUI_ABORTWARNING
!define MUI_ICON "FS.ico"
!define MUI_UNICON "${NSISDIR}\Contrib\Graphics\Icons\modern-uninstall.ico"

; Welcome page
!insertmacro MUI_PAGE_WELCOME
; License page
!insertmacro MUI_PAGE_LICENSE "COPYING"
; Directory page
!insertmacro MUI_PAGE_DIRECTORY
; Instfiles page
!insertmacro MUI_PAGE_INSTFILES
; Finish page
!insertmacro MUI_PAGE_FINISH

; Uninstaller pages
!insertmacro MUI_UNPAGE_INSTFILES

; Language files
!insertmacro MUI_LANGUAGE "English"

; Start menu page
var ICONS_GROUP
!define MUI_STARTMENUPAGE_NODISABLE
!define MUI_STARTMENUPAGE_DEFAULTFOLDER "FreeSnell"
!define MUI_STARTMENUPAGE_REGISTRY_ROOT "${PRODUCT_UNINST_ROOT_KEY}"
!define MUI_STARTMENUPAGE_REGISTRY_KEY "${PRODUCT_UNINST_KEY}"
!define MUI_STARTMENUPAGE_REGISTRY_VALUENAME "${PRODUCT_STARTMENU_REGVAL}"
!insertmacro MUI_PAGE_STARTMENU Application $ICONS_GROUP

; MUI end ------

Name "${PRODUCT_NAME} ${PRODUCT_VERSION}"
OutFile "FreeSnell-${PRODUCT_VERSION}.exe"
InstallDir "$PROGRAMFILES\FreeSnell"
InstallDirRegKey ${PRODUCT_UNINST_ROOT_KEY} "${PRODUCT_DIR_REGKEY}" ""
ShowInstDetails show
ShowUnInstDetails show

Function .onInit
; Check that scm is installed
  ClearErrors
  ReadRegStr $0 ${PRODUCT_UNINST_ROOT_KEY} "${SCM_KEY}" "${KEY_VERSION}"
  IfErrors 0 +3
  MessageBox MB_OK|MB_ICONSTOP "No SCM found. Please install SCM before installing FreeSnell."
  Abort
FunctionEnd

Section "MainSection" SEC01
  SetOutPath "$INSTDIR"
  SetOverwrite try
  File "ANNOUNCE"
  File "ChangeLog"
  File "coherence.scm"
  File "COPYING"
  File "dielectric.scm"
  File "FreeSnell.html"
  File "FreeSnell.info"
  File "FreeSnell.nsi"
  File "FreeSnell.texi"
  File "fresneleq.scm"
  File "FS.ico"
  File "granular.scm"
  File "ag.nk"
  File "al.nk"
  File "au.nk"
  File "blackbody.nk"
  File "cr.nk"
  File "cu.nk"
  File "fe.nk"
  File "ge.nk"
  File "hdpe.nk"
  File "li.nk"
  File "mgo.nk"
  File "ni.nk"
  File "se-a.nk"
  File "se-b.nk"
  File "si.nk"
  File "ta.nk"
  File "te-a.nk"
  File "te-b.nk"
  File "ti.nk"
  File "v.nk"
  File "w.nk"
  File "zn-a.nk"
  File "zn-b.nk"
  File "zr.nk"
  File "Makefile"
  File "metallic.scm"
  File "nk.bat"
  File "nk.rwb"
  File "nk.scm"
  File "opticolr.scm"
  File "opticompute.scm"
  File "optiplot.scm"
  File "polyethylene.scm"
  File "usercat"
  File "version.txi"
  File "video.scm"

; Shortcuts
  !insertmacro MUI_STARTMENU_WRITE_BEGIN Application
  CreateDirectory "$SMPROGRAMS\$ICONS_GROUP"
  CreateShortCut "$SMPROGRAMS\$ICONS_GROUP\nk.lnk" "scm.exe" '-iql"$INSTDIR\nk.scm" -ie"(nki)"' "$INSTDIR\FS.ico"
  CreateShortCut "$SMPROGRAMS\$ICONS_GROUP\FreeSnell.lnk" "scm.exe" "" "$INSTDIR\FS.ico"
  CreateShortCut "$SMPROGRAMS\$ICONS_GROUP\Manual.lnk" "$INSTDIR\FreeSnell.html"

  CreateShortCut "$DESKTOP\nk.lnk" "scm.exe" '-iql"$INSTDIR\nk.scm" -ie"(nki)"' "$INSTDIR\FS.ico"
  CreateShortCut "$DESKTOP\FreeSnell.lnk" "scm.exe" "" "$INSTDIR\FS.ico"
  !insertmacro MUI_STARTMENU_WRITE_END

; Jaffer FreeSnell registry settings
  WriteRegStr ${PRODUCT_UNINST_ROOT_KEY} "${FREESNELL_KEY}" "${KEY_VERSION}" "${PRODUCT_VERSION}"

SectionEnd

Section -AdditionalIcons
  WriteIniStr "$INSTDIR\${PRODUCT_NAME}.url" "InternetShortcut" "URL" "${PRODUCT_WEB_SITE}"
  CreateDirectory "$SMPROGRAMS\$ICONS_GROUP"
  CreateShortCut "$SMPROGRAMS\$ICONS_GROUP\Website.lnk" "$INSTDIR\${PRODUCT_NAME}.url"
  CreateShortCut "$SMPROGRAMS\$ICONS_GROUP\Uninstall.lnk" "$INSTDIR\uninst.exe"
SectionEnd

Section -Post
  WriteUninstaller "$INSTDIR\uninst.exe"
  WriteRegStr ${PRODUCT_UNINST_ROOT_KEY} "${PRODUCT_UNINST_KEY}" "DisplayName" "$(^Name)"
  WriteRegStr ${PRODUCT_UNINST_ROOT_KEY} "${PRODUCT_UNINST_KEY}" "UninstallString" "$INSTDIR\uninst.exe"
  WriteRegStr ${PRODUCT_UNINST_ROOT_KEY} "${PRODUCT_UNINST_KEY}" "DisplayVersion" "${PRODUCT_VERSION}"
  WriteRegStr ${PRODUCT_UNINST_ROOT_KEY} "${PRODUCT_UNINST_KEY}" "URLInfoAbout" "${PRODUCT_WEB_SITE}"
  WriteRegStr ${PRODUCT_UNINST_ROOT_KEY} "${PRODUCT_UNINST_KEY}" "Publisher" "${PRODUCT_PUBLISHER}"
SectionEnd


Function un.onUninstSuccess
  HideWindow
  MessageBox MB_ICONINFORMATION|MB_OK "$(^Name) was successfully removed from your computer."
FunctionEnd

Function un.onInit
  MessageBox MB_ICONQUESTION|MB_YESNO|MB_DEFBUTTON2 "Are you sure you want to completely remove $(^Name) and all of its components?" IDYES +2
  Abort
FunctionEnd

Section Uninstall
  !insertmacro MUI_STARTMENU_GETFOLDER "Application" $ICONS_GROUP
  Delete "$INSTDIR\${PRODUCT_NAME}.url"
  Delete "$INSTDIR\uninst.exe"
  Delete "$INSTDIR\video.scm"
  Delete "$INSTDIR\version.txi"
  Delete "$INSTDIR\usercat"
  Delete "$INSTDIR\polyethylene.scm"
  Delete "$INSTDIR\optiplot.scm"
  Delete "$INSTDIR\opticompute.scm"
  Delete "$INSTDIR\opticolr.scm"
  Delete "$INSTDIR\nk.scm"
  Delete "$INSTDIR\nk.rwb"
  Delete "$INSTDIR\nk.bat"
  Delete "$INSTDIR\metallic.scm"
  Delete "$INSTDIR\Makefile"
  Delete "$INSTDIR\zr.nk"
  Delete "$INSTDIR\zn-b.nk"
  Delete "$INSTDIR\zn-a.nk"
  Delete "$INSTDIR\w.nk"
  Delete "$INSTDIR\v.nk"
  Delete "$INSTDIR\ti.nk"
  Delete "$INSTDIR\te-b.nk"
  Delete "$INSTDIR\te-a.nk"
  Delete "$INSTDIR\ta.nk"
  Delete "$INSTDIR\si.nk"
  Delete "$INSTDIR\se-b.nk"
  Delete "$INSTDIR\se-a.nk"
  Delete "$INSTDIR\ni.nk"
  Delete "$INSTDIR\mgo.nk"
  Delete "$INSTDIR\li.nk"
  Delete "$INSTDIR\hdpe.nk"
  Delete "$INSTDIR\ge.nk"
  Delete "$INSTDIR\fe.nk"
  Delete "$INSTDIR\cu.nk"
  Delete "$INSTDIR\cr.nk"
  Delete "$INSTDIR\blackbody.nk"
  Delete "$INSTDIR\au.nk"
  Delete "$INSTDIR\al.nk"
  Delete "$INSTDIR\ag.nk"
  Delete "$INSTDIR\granular.scm"
  Delete "$INSTDIR\FS.ico"
  Delete "$INSTDIR\fresneleq.scm"
  Delete "$INSTDIR\FreeSnell.html"
  Delete "$INSTDIR\FreeSnell.texi"
  Delete "$INSTDIR\FreeSnell.nsi"
  Delete "$INSTDIR\FreeSnell.info"
  Delete "$INSTDIR\dielectric.scm"
  Delete "$INSTDIR\COPYING"
  Delete "$INSTDIR\coherence.scm"
  Delete "$INSTDIR\ChangeLog"
  Delete "$INSTDIR\ANNOUNCE"

  Delete "$SMPROGRAMS\$ICONS_GROUP\Uninstall.lnk"
  Delete "$SMPROGRAMS\$ICONS_GROUP\Website.lnk"
  Delete "$SMPROGRAMS\$ICONS_GROUP\nk.lnk"
  Delete "$SMPROGRAMS\$ICONS_GROUP\FreeSnell.lnk"
  Delete "$SMPROGRAMS\$ICONS_GROUP\Manual.lnk"
  Delete "$DESKTOP\FreeSnell.lnk"
  Delete "$DESKTOP\nk.lnk"

  RMDir "$SMPROGRAMS\$ICONS_GROUP"
  RMDir "$INSTDIR"
  RMDir ""

  DeleteRegKey ${PRODUCT_UNINST_ROOT_KEY} "${FREESNELL_KEY}"

  DeleteRegKey ${PRODUCT_UNINST_ROOT_KEY} "${PRODUCT_UNINST_KEY}"
  SetAutoClose true
SectionEnd
