<?PHP
/* vim: set expandtab tabstop=4 shiftwidth=4: */
// +----------------------------------------------------------------------------+
// | <G a n e s h a> - Free Web Based Training System                           |
// +----------------------------------------------------------------------------+
// | <G a n e s h a> - Plate-forme de tlformation gratuite et en open source  |
// +----------------------------------------------------------------------------|
// | Copyright (C) 2001-2003  Anma Formation  <http://www.anema.fr/>           |
// +----------------------------------------------------------------------------+
// |           Developer : Georges CALDEIRA <gcaldeira@anemalab.org>            |
// +----------------------------------------------------------------------------+
// |              Infos on project <http://anemalab.org/>                       |
// +----------------------------------------------------------------------------+
// | This program is free software; you can redistribute it and/or modify       |
// | it under the terms of the GNU General Public License as published by       |
// | the Free Software Foundation; either version 2 of the License, or          |
// | (at your option) any later version.                                        |
// |                                                                            |
// | This program is distributed in the hope that it will be useful,            |
// | but WITHOUT ANY WARRANTY; without even the implied warranty of             |
// | MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the              |
// | GNU General Public License for more details.                               |
// |                                                                            |
// | You should have received a copy of the GNU General Public License          |
// | along with this program; if not, write to the Free Software                |
// | Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA   |
// +----------------------------------------------------------------------------+

/**
* Definition de la class pour la gestion des valuations annexes.
* @author	Eric Villard <evillard@nef.fr>
* @package	GaneshaClass
*/
/**
* Fournit une API pour acceder  la gestion des valuations annexes
* @author	Eric Villard <evillard@nef.fr>
* @access	public
* @package	GaneshaClass
*/
class Evalanx {

	/**
	* Contient la connexion locale de la classe
	* @var	object DB_Ganesha	$_db
	* @access	private
	*/
	var $_db ;

	/**
	* Constructeur. Initialise la connexion locale
	* @access	public
	*/
	function Evalanx() {
		$this->_db = new DB_Ganesha ;
	}

//
// PARTIE DESCRIPTION DES EVALUATIONS ANNEXES

	/**
	* Ajoute une nouvelle valuation dans la bdd
	* @param	string	$nom nom de l'valuation
	* @param	string	$contexte contexte / description / nonc de l'valuation
	* @access	public
	*/
	function add($nom, $contexte) {
	 global $TBL, $db ;
		$sSQL = "insert into ".$TBL['evalanxdesc']." (nom, contexte) "	;
		$sSQL.= "values ('".$nom."','".($contexte)."') ";
		$db->query($sSQL);
	}

	/**
	* Supprime une valuation des tables evalanxdesc et session_evalanx
	* @param	integer	$ideval Id de l'valuation
	* @access	public
	*/
	function delete($ideval) {
	 global $TBL, $db ;
		$sSQL = "DELETE FROM ".$TBL['evalanxdesc']." WHERE id=".$ideval ;
		$db->query($sSQL);
		$sSQL = "DELETE FROM ".$TBL['session_evalanx']." WHERE id_evaluation=".$ideval ;
		$db->query($sSQL);
	}

	/**
	* modifie une valuation de la bdd
	* @param	integer	$ideval Id de l'valuation
	* @param	string	$nom nom de l'valuation
	* @param	string	$contexte contexte / description / nonc de l'valuation
	* @access	public
	*/
	function modify($ideval, $nom, $contexte) {
	 global $TBL, $db ;
		$sSQL = "update ".$TBL['evalanxdesc']." set nom='".$nom."', contexte='".$contexte."' ";
		$sSQL.= "where id=".$ideval;
		$db->query($sSQL);
	}
	
	/**
	* retourne les donnes d'une ou plusieurs valuations
	* @param	array of integer $tabIdeval tableau d'Id d'valuations
	* 			=> permet un nombre variable de paramtres (compatible PHP 3)
	* @return	array	Retourne un tableau avec les informations concernant une ou plusieurs valuations
	* @access	public
	*/
	function getData($tabIdeval) {
	 global $TBL, $db ;
	 	$longTab = count($tabIdeval);
		// la requte se porte sur ou plusieurs lments prcis
	 	if ($longTab > 0) {
			$sSQL = "SELECT DISTINCT * FROM ".$TBL['evalanxdesc']." WHERE ";
			for ($i=0; $i<$longTab; $i++) {
				$sSQL.= "id=".$tabIdeval[$i];
				if (($longTab > 1) && ($i != ($longTab-1))) {
					$sSQL.= " OR ";
				}
			}
			$sSQL.= " ORDER BY nom ASC";
		// la requte se porte l'ensemble des lments de la table
		} else {
			$sSQL = "SELECT DISTINCT * FROM ".$TBL['evalanxdesc']." ORDER BY nom ASC";
		}
		$this->_db->query($sSQL);
		$ind = 0;
		while ($this->_db->next_record()) {
			$ret[$ind]['id'] = $this->_db->f("id");
			$ret[$ind]['nom'] = $this->_db->f("nom");
			$ret[$ind]['contexte'] = $this->_db->f("contexte");
			$ind++;
		}
		$this->_db->free()	;
		return($ret)	;
	}

//	
// PARTIE ELABORATION DE RAPPORTS D'EVALUATION

	/**
	* Ajoute un nouveau rapport d'valuation annexe
	* @param	integer	$ideval Id de l'valuation
	* @param	integer	$ids Id du stagiaire
	* @param	integer	$idtut Id de l'valuateur
	* @param	string	$date date de l'valuation
	* @param	string	$statut statut  l'issue de l'valuation
	* @param	integer	$tps dure de l'valuation
	* @param	integer	$obs observations / commentaires
	* @access	public
	*/
    function addReport($ideval, $ids, $idtut, $date, $statut, $tps, $obs) { 
	global $TBL, $db ;
        $sSQL = "insert into ".$TBL['evalannexes']." (id_stagiaire, id_evaluation, id_evaluateur, date, statut, temps, commentaire) ";
        $sSQL.= "values (".$ids.", ".$ideval.", ".$idtut.", '".$date."', ".$statut.", '".$tps."', '".$obs."')";
		$db->query($sSQL)		;
    }
		
	/**
	* Supprime un rapport de la bdd
	* @param	integer	$idrap Id du rapport
	* @access	public
	*/
	function deleteReport($idrap) {
	 global $TBL, $db ;
		$sSQL = "DELETE FROM ".$TBL['evalannexes']." WHERE id=".$idrap;
		$db->query($sSQL);
	}
	
	/**
	* modifie un rapport de la bdd
	* @param	integer	$idrap Id du rapport
	* @param	integer	$ideval Id de l'valuation
	* @param	integer	$ids Id du stagiaire
	* @param	integer	$idtut Id de l'valuateur
	* @param	string	$date date de l'valuation
	* @param	string	$statut statut  l'issue de l'valuation
	* @param	integer	$tps dure de l'valuation
	* @param	integer	$obs observations / commentaires
	* @access	public
	*/
	function modifyReport($idrap, $ideval, $ids, $idtut, $date, $statut, $tps, $obs) {
	 global $TBL, $db ;
		$sSQL = "update ".$TBL['evalannexes']." set id_stagiaire=".$ids.", id_evaluation=".$ideval.", id_evaluateur=".$idtut.", date='".$date."', statut=".$statut.", temps='".$tps."', commentaire='".$obs."' ";
		$sSQL.= "where id=".$idrap;
		$db->query($sSQL);
	}
	
	/**
	* retourne les donnes d'un ou plusieurs rapports d'valuation
	* @param	array of integer $tabIdstag tableau d'Id des stagiaires
	* 			=> permet un nombre variable de paramtres (compatible PHP 3)
	* @return	array	Retourne un tableau avec les informations concernant un ou plusieurs rapports d'valuation
	* @access	public
	*/
	function getDataReport($tabIdstag) {
	 global $TBL, $db ;
	 	$longTab = count($tabIdstag);
	 	// la requte se porte sur ou plusieurs lments prcis
	 	if ($longTab > 0) {
			$sSQL = "SELECT DISTINCT e.*, d.nom, d.contexte FROM ".$TBL['evalannexes']." e, ".$TBL['evalanxdesc']." d WHERE ";
			for ($i=0; $i<$longTab; $i++) {
				$sSQL.= "id_stagiaire=".$tabIdstag[$i];
				if (($longTab > 1) && ($i != ($longTab-1))) {
					$sSQL.= " OR ";
				}
			}
			$sSQL.= " AND d.id=e.id_evaluation ORDER BY e.date DESC, d.nom ASC";
		// la requte se porte l'ensemble des lments de la table
		} else {
			$sSQL = "SELECT DISTINCT e.*, d.nom, d.contexte FROM ".$TBL['evalannexes']." e, ".$TBL['evalanxdesc']." d ORDER BY e.date DESC, d.nom ASC";
		}
		$this->_db->query($sSQL);
		$ind = 0;
		$ret = array();
		while ($this->_db->next_record() ) {
			$ret[$ind]['id'] = $this->_db->f("id");
			$ret[$ind]['nom'] = $this->_db->f("nom");
			$ret[$ind]['id_stagiaire'] = $this->_db->f("id_stagiaire");
			$ret[$ind]['id_evaluation'] = $this->_db->f("id_evaluation");
			$ret[$ind]['id_evaluateur'] = $this->_db->f("id_evaluateur");
			$ret[$ind]['date'] = $this->_db->f("date");
			$ret[$ind]['contexte'] = $this->_db->f("contexte");
			$ret[$ind]['statut'] = $this->_db->f("statut");
			$ret[$ind]['temps'] = $this->_db->f("temps");
			$ret[$ind]['commentaire'] = $this->_db->f("commentaire");
			$ind++;
		}
		$this->_db->free()	;
		return($ret)	;
	}
	
//
// PARTIE GESTION DE "SESSION"
	
	/**
	* assigne une valuation  un groupe ou   des stagiaires en particulier
	* @param	integer				$idgpe 		Id du groupe
	* @param	array of integer 	$tabStag	taleau des id des stagiaires
	* @param	array of integer 	$tabEval	taleau des id des valuations
	* @access	public
	*/
	function setEval($idgpe, $tabStag, $tabEval) {
	 global $TBL, $db ;
	 	$lgStag = count($tabStag);
		$lgEval = count($tabEval);
		$msg="<b>La ou les lignes suivantes n'ont pas t inscrites :</b><br>";
		$flag = false;
	 	for ($i=0; $i<$lgEval; $i++) {
			for ($j=0; $j<$lgStag; $j++) {
				$sSQL = "SELECT DISTINCT id_groupe FROM ".$TBL['session_evalanx']." WHERE id_groupe=".$idgpe." AND id_stagiaire=".$tabStag[$j]." AND id_evaluation=".$tabEval[$i];
				$db->query($sSQL)	;
				$db->next_record()	;
				if ( $db->num_rows() == 0 ) {
					$db->free()	;
					$sSQL = "insert into ".$TBL['session_evalanx']." (id_groupe, id_stagiaire, id_evaluation) values (".$idgpe.",".$tabStag[$j].",".$tabEval[$i].")";
					$db->query($sSQL);
				} else {
					$flag = true;
					$msg.= "- id_groupe : ".$idgpe."&nbsp;&nbsp; id_stagiaire : ".$tabStag[$j]."&nbsp;&nbsp; id_evaluation : ".$tabEval[$i]."<br>";
				}
			}
		}
		if ($flag) Put($msg);
	}
	
	/**
	* retourne la session d'un stagiaires
	* @param	integer 			$idStag		id du stagiaire
	* @return	array of integer 	$tabEval	taleau des id des valuations
	* @access	public
	*/
	function getEval($idStag) {
	 global $TBL, $db ;
		$sSQL = "SELECT DISTINCT s.id_evaluation, d.nom FROM ".$TBL['session_evalanx']." s,".$TBL['evalanxdesc']." d where s.id_stagiaire=".$idStag." and d.id=s.id_evaluation order by d.nom ASC";
	 	$this->_db->query($sSQL);
		$ind = 0;
		while ($this->_db->next_record() ) {
			$ret[$ind]["id"] = $this->_db->f("id_evaluation");
			$ret[$ind]["nom"] = $this->_db->f("nom");
			$ind++;
		}
		$this->_db->free();
		return $ret;
	}
	
	/**
	* Supprime une ou plusieurs session
	* @param	integer				$idStag		id du stagiaire
	* @param	array of integer 	$tabEval	taleau des id des valuations
	* @access	public
	*/
	function deleteEval($idStag, $tabEval) {
	 global $TBL, $db ;
	 	$lgEval = count($tabEval);
		$sSQL = "DELETE FROM ".$TBL['session_evalanx']." WHERE id_stagiaire=".$idStag." AND ";
		for ($i=0; $i<$lgEval; $i++) {
			$sSQL.= "id_evaluation=".$tabEval[$i];
			if ($i<$lgEval-1) $sSQL.= " or ";
		}
		$db->query($sSQL);
	}

//	
// PARTIE ANNEXE 1

//Mthodes d'accs aux donnes ncessaires au formatage des formulaires HTML

	/**
	* retourne la liste des groupes
	* @return	array	taleau contenant les id et noms des groupes
	* @access	public
	*/
	function getListGroup($idu) {
	 global $TBL, $db ;
		$sSQL = "SELECT DISTINCT id_groupe,name FROM ".$TBL['list_groupe']." ";
		$sSQL.= "WHERE id_tuteur=".$idu." ORDER BY name ASC";
		$this->_db->query($sSQL);
		$ret[0]['id'] = 0;
		$ret[0]['nom'] = '';
		$ind = 1;		
		while ($this->_db->next_record() ) {
			$ret[$ind]['id'] = $this->_db->f("id_groupe");
			$ret[$ind]['nom'] = $this->_db->f("name");
			$ind++;
		}
		$this->_db->free();
		return $ret;
	}
	
	/**
	* retourne la liste des valuations
	* @return	array	taleau contenant les id et noms des valuations
	* @access	public
	*/
	function getListEval() {
	 global $TBL, $db ;
		$sSQL = "SELECT DISTINCT id, nom FROM ".$TBL['evalanxdesc']." order by nom ASC";
		$this->_db->query($sSQL);
		$ind = 0;
		while ($this->_db->next_record() ) {
			$ret[$ind]['id'] = $this->_db->f("id");
			$ret[$ind]['nom'] = $this->_db->f("nom");
			$ind++;
		}
		$this->_db->free();
		return $ret;
	}
	
	/**
	* retourne la liste globale des stagiaires ou celle des stagiaires d'un groupe en particulier
	* @param	integer	$gpe	id d'un groupe
	* @return	array			taleau contenant les id, prnoms et noms des stagiaires
	* @access	public
	*/
	function getListStagiaire($gpe) {
	 global $TBL, $db ;
		if (isset($gpe) && $gpe!=0) {
			$sSQL = "SELECT DISTINCT m.id, m.prenom, m.nom FROM ".$TBL['membres']." m left join ".$TBL['groupe']." g on m.id=g.id_membres where g.id_groupe=".$gpe." and type=0 order by prenom ASC,nom";
		} else {
			//$sSQL = "SELECT DISTINCT id,prenom,nom FROM ".$TBL['membres']." where type=0 order by prenom ASC,nom";
			$ret = array() ;
			return($ret);
		}
		$this->_db->query($sSQL);
		$ind = 0;
		while ($this->_db->next_record() ) {
			$ret[$ind]['id'] = $this->_db->f("id");
			$ret[$ind]['prenom'] = $this->_db->f("prenom");
			$ret[$ind]['nom'] = $this->_db->f("nom");
			$ind++;
		}
		$this->_db->free();
		return $ret;
	}
	
	/**
	* retourne la liste globale des tuteurs
	* @return	array	taleau contenant les id, prnoms et noms des tuteurs
	* @access	public
	*/
	function getListTuteur($grp) {
	 global $TBL, $db ;
		$sSQL = "SELECT DISTINCT m.id,m.prenom,m.nom FROM ".$TBL['membres']." m, ".$TBL['list_groupe']." g ";
		$sSQL.= "WHERE g.id_tuteur=m.id AND g.id_groupe=".$grp." ORDER BY prenom ASC,nom ASC";
		
		$this->_db->query($sSQL);
		$ind = 0;
		while ($this->_db->next_record() ) {
			$ret[$ind]['id'] = $this->_db->f("id");
			$ret[$ind]['prenom'] = $this->_db->f("prenom");
			$ret[$ind]['nom'] = $this->_db->f("nom");
			$ind++;
		}
		$this->_db->free();
		return $ret;
	}
	
//	
// PARTIE ANNEXE 2

// Accs aux diffrents champs des tables evalannexes et evalanxdesc

	/**
	* retourne la valeur d'un champs de la table membre correspoondant a l'id 
	* @param	string	$table 	table cible
	* @param	string	$field 	champ cible
	* @param	integer	$id		id correspondant
	* @return	string			retourne la valeur du champ de la table cible correspondant  l'id 
	* @access	private
	*/
	function Request($table,$field,$id) {
	 global $TBL, $db ;
		$res = '' ;
		$sSQL="SELECT ".$field." FROM ".$TBL[$table]." where id=".$id  ;
		$db->query($sSQL)	;
		$db->next_record()	;
		if ( $db->num_rows() != 0 ) {
			$res = Unreplace($db->f(0))	;
			$db->free()	;
		}
		return($res);
	}
	
	/**
	* retourne le nom d'une valuation
	* @param	integer $id	id de l'valuation
	* @return	string		valeur du champ nom 
	* @access	public
	*/
	function getNomEval($id) {
		return $this->Request("evalanxdesc","nom",$id);
	}
	
	/**
	* retourne le contexte d'une valuation
	* @param	integer $id	id de l'valuation
	* @return	string		valeur du champ contexte 
	* @access	public
	*/
	function getContexteEval($id) {
		return $this->Request("evalanxdesc","contexte",$id);
	}
	
	/**
	* retourne l'id du stagiaire d'un rapport
	* @param	integer $id	id du rapport
	* @return	string		valeur du champ id_stagiaire 
	* @access	public
	*/
	function getIdStagEval($id) {
		return $this->Request("evalannexes","id_stagiaire",$id);
	}
	
	/**
	* retourne l'id de l'valuation d'un rapport
	* @param	integer $id	id du rapport
	* @return	string		valeur du champ id_evaluation
	* @access	public
	*/
	function getIdEval($id) {
		return $this->Request("evalannexes","id_evaluation",$id);
	}

	/**
	* retourne l'id de l'valuateur d'un rapport
	* @param	integer $id	id du rapport
	* @return	string		valeur du champ id_evaluateur
	* @access	public
	*/
	function getIdTuteur($id) {
		return $this->Request("evalannexes","id_evaluateur",$id);
	}
	
	/**
	* retourne la date d'un rapport
	* @param	integer $id	id du rapport
	* @return	string		valeur du champ date
	* @access	public
	*/
	function getDateRap($id) {
		return $this->Request("evalannexes","date",$id);
	}
	
	/**
	* retourne le statut d'un rapport
	* @param	integer $id	id du rapport
	* @return	string		valeur du champ statut
	* @access	public
	*/
	function getStatut($id) {
		return $this->Request("evalannexes","statut",$id);
	}
	
	/**
	* retourne le temps d'un rapport
	* @param	integer $id	id du rapport
	* @return	string		valeur du champ temps
	* @access	public
	*/
	function getTemps($id) {
		return $this->Request("evalannexes","temps",$id);
	}
	
	/**
	* retourne le commentaire d'un rapport
	* @param	integer $id	id du rapport
	* @return	string		valeur du champ commentaire
	* @access	public
	*/
	function getComment($id) {
		return $this->Request("evalannexes","commentaire",$id);
	}

//	
// PARTIE ANNEXE 3

// requtes particulires

	/**
	* retourne les id de plusieurs valuateurs d'un rapport
	* @param	integer $id	id des rapports
	* @return	array		valeur des champ id_evaluateur
	* @access	public
	*/
	function getTabIdTuteur($id) {
	 global $TBL, $db ;
		$sSQL = "SELECT DISTINCT id_evaluateur FROM ".$TBL['evalannexes']." where id_evaluation=".$id." order by id_evaluation";
		$this->_db->query($sSQL);
		$ind = 0;
		while ($this->_db->next_record() ) {
			$ret[$ind] = $this->_db->f("id_evaluateur");
			$ind++;
		}
		$this->_db->free();
		return $ret;
	}
	
	/**
	* retourne les id des rapports d'un stagiaire
	* @param	integer $id	id du stagiaire
	* @return	array		valeurs du champ id_evaluation
	* @access	public
	*/
	function getIdRapStag($id) {
	 global $TBL, $db ;
		$sSQL="SELECT id FROM ".$TBL["evalannexes"]." where id_stagiaire=".$id  ;
		$this->_db->query($sSQL);
		$ind = 0;
		while ($this->_db->next_record() ) {
			$ret[$ind] = $this->_db->f("id");
			$ind++;
		}
		$this->_db->free();
		return $ret;
	}
	
	/**
	* retourne le nombre de rapports
	* @param	integer $id	id de l'valuation
	* @return	integer	le nombre de rapports
	* @access	public
	*/
	function getNbRap($id) {
	 global $TBL, $db ;
		$res = 0;
		$sSQL="SELECT count(id) FROM ".$TBL['evalannexes']." where id_evaluation=".$id;
		$db->query($sSQL)	;
		$db->next_record()	;
		if ( $db->num_rows() != 0 ) {
			$res = Unreplace($db->f(0))	;
			$db->free()	;
		}
		return($res);
	}
	
	/**
	* retourne la moyenne de russite pour une valuation
	* @param	integer $id	id de l'valuation
	* @return	integer		moyenne de russite  l'valuation
	* @access	public
	*/
	function getMoyenne($id) {
	 global $TBL, $db ;
		$res = 0;
		$sSQL="SELECT count(id) FROM ".$TBL['evalannexes']." where statut=1 and id_evaluation=".$id;
		$db->query($sSQL)	;
		$db->next_record()	;
		if ( $db->num_rows() != 0 ) {
			$res = Unreplace($db->f(0))	;
			$db->free()	;
		}
		($res!=0) ? $moy = round($res / $this->getNbRap($id) * 100): $moy=0;;
		return($moy);
	}
	
	/**
	* retourne les id des valuations que le stagiaire doit effectuer
	* @param	integer $id	id du stagiaire
	* @return	array		tableau des id des valuations
	* @access	public
	*/
	function getListEvalStag($id) {
	 global $TBL, $db ;
		$sSQL="SELECT DISTINCT id_evaluation FROM ".$TBL['session_evalanx']." where id_stagiaire=".$id;
		$this->_db->query($sSQL);
		$ind = 0;
		while ($this->_db->next_record() ) {
			$ret[$ind] = $this->_db->f("id_evaluation");
			$ind++;
		}
		$this->_db->free();
		return $ret;
	}
	
	/**
	* retourne l'id, le nom et la date du rapport le plus rcent
	* @param	integer $id	id du stagiaire
	* @return	array		tableau rsultat
	* @access	public
	*/
	function getDernEval($id) {
	 global $TBL, $db ;
	 	$ret = array();
		$sSQL="SELECT max(date) FROM ".$TBL['evalannexes']." where id_stagiaire=".$id  ;
		$db->query($sSQL)	;
		$db->next_record()	;
		if ( $db->num_rows() != 0 ) {
			$date = Unreplace($db->f(0));
			$db->free()	;
			$sSQL="SELECT DISTINCT e.id, d.nom, e.date  FROM ".$TBL['evalannexes']." e, ".$TBL['evalanxdesc']." d where d.id=e.id_evaluation and e.id_stagiaire=".$id." and e.date='".$date."'";
			$this->_db->query($sSQL);
			$ind = 0;
			while ($this->_db->next_record() ) {
				$ret[$ind]["id"] = $this->_db->f("id");
				$ret[$ind]["nom"] = $this->_db->f("nom");
				$ret[$ind]["date"] = $this->_db->f("date");
				$ind++;
			}
			$this->_db->free();
			
		}
		return $ret;
	}
	
	/**
	* retourne les id des rapports d'un stagiaire, dont les valuations sont toujours inscrites
	* dans la table session_evalanx
	* @param	integer $id	id du stagiaire
	* @return	array		valeurs du champ id_evaluation
	* @access	public
	*/
	function getIdRapEvalDone($id) {
	 global $TBL, $db ;
		$sSQL="SELECT DISTINCT e.id FROM ".$TBL["evalannexes"]." e, ".$TBL['session_evalanx']." s where e.id_evaluation=s.id_evaluation and e.id_stagiaire=".$id." and s.id_stagiaire=e.id_stagiaire"  ;
		$this->_db->query($sSQL);
		$ind = 0;
		$ret = array();
		while ($this->_db->next_record() ) {
			$ret[$ind] = $this->_db->f("id");
			$ind++;
		}
		$this->_db->free();
		return $ret;
	}
	
	/**
	* retourne la liste des valuations restant  faire pour un stagiaire
	* @param	integer	$idstag		id stagiaire
	* @param	array	$tabIdEval	tableau contenant les id des valuations dj effectues
	* @return	array				taleau contenant les id et noms des valuations
	* @access	public
	*/
	function getEvalToDo($idstag, $tabIdEval) {
	 global $TBL, $db ;
	 	$lgtab = count($tabIdEval);
		$sSQL = "SELECT DISTINCT d.* FROM ".$TBL['evalanxdesc']." d, ".$TBL['session_evalanx']." s where s.id_stagiaire=".$idstag;
		for ($i=0; $i < $lgtab; $i++) {
			$sSQL.= " and s.id_evaluation<>".$tabIdEval[$i];
		}
		$sSQL.= " and d.id=s.id_evaluation order by d.nom ASC";
		$this->_db->query($sSQL);
		$ind = 0;
		$ret = array();
		while ($this->_db->next_record() ) {
			$ret[$ind]['id'] = $this->_db->f("id");
			$ret[$ind]['nom'] = $this->_db->f("nom");
			$ret[$ind]['contexte'] = $this->_db->f("contexte");
			$ind++;
		}
		$this->_db->free();
		return $ret;
	}
	
}// class Evalanx

/**
* Instance de la classe Evalanx
* @var	object	Evalter	$ClsEvalanx
*/
$ClsEvalanx = new Evalanx ;

?>