<?PHP
/* vim: set expandtab tabstop=4 shiftwidth=4: */
// +----------------------------------------------------------------------------+
// | <G a n e s h a> - Free Web Based Training System                           |
// +----------------------------------------------------------------------------+
// | <G a n e s h a> - Plate-forme de tlformation gratuite et en open source  |
// +----------------------------------------------------------------------------|
// | Copyright (C) 2001-2003  Anma Formation  <http://www.anema.fr/>           |
// +----------------------------------------------------------------------------+
// |           Developer : Georges CALDEIRA <gcaldeira@anemalab.org>            |
// +----------------------------------------------------------------------------+
// |              Infos on project <http://anemalab.org/>                       |
// +----------------------------------------------------------------------------+
// | This program is free software; you can redistribute it and/or modify       |
// | it under the terms of the GNU General Public License as published by       |
// | the Free Software Foundation; either version 2 of the License, or          |
// | (at your option) any later version.                                        |
// |                                                                            |
// | This program is distributed in the hope that it will be useful,            |
// | but WITHOUT ANY WARRANTY; without even the implied warranty of             |
// | MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the              |
// | GNU General Public License for more details.                               |
// |                                                                            |
// | You should have received a copy of the GNU General Public License          |
// | along with this program; if not, write to the Free Software                |
// | Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA   |
// +----------------------------------------------------------------------------+

/**
* Definition de la class pour la gestion des logs
* @author	Georges Caldeira <gcaldeira@anemalab.org>
* @package	GaneshaClass
*/
/**
* Fournit une API pour la gestion des LOGs
* @author	Georges Caldeira <gcaldeira@anemalab.org>
* @access	public
* @package	GaneshaClass
*/

class GaneshaLog {

	/**
	* Met a jour le log pour un membre
	* @param	integer	$cnx Cnx du membre
	* @access	private
	*/
	function refresh($cnx) {
	 global $guser, $TBL, $db, $gusertype ;
		if ( $gusertype != STAGIAIRE ) return;
		$sSQL="SELECT date_cnx FROM ".$TBL['stat_cnx']." WHERE cnx=".$cnx ;
		$db->query($sSQL) ;
		if ( $db->next_record() ) {
			$date = FormatDate() ;
			$oldd = $db->f(0) ;
			$time = $date - $oldd ;
			$sSQL = "UPDATE ".$TBL['stat_cnx']." SET time_cnx='".$time."' WHERE cnx=".$cnx ;
			$db->query($sSQL) ;
		}
	}

	/**
	* Cre un nouveau log pour le membre $idu
	* @param	integer	$idu ID du membre
	* @param	integer	$cnx Cnx du membre
	* @access	public
	*/
	function newLog($idu,$cnx) {
	 global $TBL, $db, $gusertype ;
		if ( $gusertype != STAGIAIRE ) return;
		$date = FormatDate()	;
		$sSQL="INSERT INTO ".$TBL['stat_cnx']." (cnx,id_membres,date_cnx,time_cnx)" ;
		$sSQL .=" VALUES (".$cnx.",".$idu.",'".$date."','0')" ;
		$db->query($sSQL)	;
	}

	/**
	* Retourne les logs d'un membre
	* @param	integer	$idu Id du membre
	* @return	string	Retourne la date de la derniere connexion d'un membre
	* @access	public
	*/
	function read($idu) { 
	 global $guserid,$TBL, $db;
	 global $st_texte ;
		$ret = Array() ;
		$sSQL = "SELECT date_cnx,time_cnx FROM ".$TBL['stat_cnx']." ";
		$sSQL.= "WHERE id_membres=".$idu." ORDER BY date_cnx DESC" ;
		$db->query($sSQL) ;
		$ret['cnt'] = $db->num_rows() ;
		$i=0 ;
		while ( $db->next_record() ) {
			$ret[$i]['date'] = date(FORMATDATE ,$db->f("date_cnx")) ;
			$ret[$i++]['time'] = FormatTime($db->f("time_cnx")) ;
		} 
		return $ret;
	}

	
	/**
	* Supprime les logs d'un membre pour un groupe
	* @param	integer	$idu Id du membre
	* @param	integer	$idu Id du groupe	
	* @access	public
	*/
	function del($idu,$idg) { 
	 global $TBL, $db ;
		$sSQL = "DELETE FROM ".$TBL['stat_cnx']." ";
		$sSQL.= "WHERE id_membres=".$idu." AND id_groupe=".$idg ;
		$db->query($sSQL) ;
	}
	
} // class GaneshaLog

/**
* Instance de la classe Connexion
* @var	object	Connexion
*/
$ClsLog = new GaneshaLog ;

?>