<?PHP
/**
* Affichage d'un calendrier
*
* @version		1.0
* @author		Patrice FROMHOLTZ, <webmaster@lafoireinformatique.com>
* @package		GaneshaInc
* @access		public
*/

	/**
	* Calcul si les parametres correspondent a une date ferie
	* @param	integer	$month Valeur du mois
	* @param	integer	$day Valeur du jour
	* @param	integer	$year Valeur de l'annee
	* @return	boolean	True si c'est un jour ferie
	* @access	private
	*/
	function CalculJoursFeries($month,$day,$year){
		$resultat=false;

		$jf1 = $year-1900;
		$jf2 = $jf1%19;
		$jf3 = intval((7*$jf2+1)/19);
		$jf4 = (11*$jf2+4-$jf3)%29;
		$jf5 = intval($jf1/4);
		$jf6 = ($jf1+$jf5+31-$jf4)%7;
		$jfj = 25-$jf4-$jf6;
		$jfm = 4;
		if ($jfj<=0){
			$jfm=3;
			$jfj=$jfj+31;
		}

		$paques		= (($jfm < 10) ? "0".$jfm : $jfm)."/".(($jfj < 10) ? "0".$jfj : $jfj);
		$lunpaq		= date("m/d",mktime(12,0,0,$jfm,$jfj+1,$year))	;
		$ascension	= date("m/d",mktime(12,0,0,$jfm,$jfj+39,$year))	;
		$lunpent	= date("m/d",mktime(12,0,0,$jfm,$jfj+50,$year))	;

		$JourFerie	= Array("01/01","05/01","05/08","07/14","08/15","11/01","11/11","12/25",
			                "$paques","$lunpaq","$ascension","$lunpent");

		$nbj = 0 ;
		$val=	$lien=date("m/d", mktime(0,0,0,$month,$day,$year));
		  while ($nbj<count($JourFerie)) {
			if ($JourFerie[$nbj]==$val) {
				$resultat=true;
				$nbj=15;
			}
			$nbj++;
		  }
		return( $resultat );
	}


	/**
	* Affiche un calendrier
	* @access	public
	*/
	function Calendrier() { 
	 global $color1, $color2, $tMois, $tCal ;
		// selectionne la date d aujourd hui si aucune saisie
		if ( !OPT_CALENDAR_ACTIVE) {
			put('&nbsp;');
			return(true);
		}
		$year = date("Y");
		$now   = date("Y/m/d");
		$month  = date("n");
		$day = date("d");

		$moyear=$tMois[$month-1]."&nbsp;&nbsp;".$year;
		$moyear = '<img src="'.HTTP_IMAGES.'calendrier.gif" border="0" alt="'.$moyear.'" />&nbsp;'.$moyear;

		put('		<table width="90%" border="0" cellspacing="0" cellpadding="1" bgcolor="'.$color1.'">')	;
		put('		<tr><td>')																				;
		put('		<table width="100%" border="0" cellspacing="0" cellpadding="1" bgcolor="#FFFFFF">')		;
		put('		  <tr bgcolor="'.$color2.'"> ')															;
		put('			<td colspan="8" align="center" class="title2">')									;

		put('&nbsp;'.$moyear.'&nbsp;')				;
		put('			</td>')						;
		put('		  </tr>')						;
		put('		  <tr bgcolor="'.$color1.'"> ')	;

		put('<td width="20" class="small" align="center">Sem</td>');
		for ( $i=0; $i<7; $i++ ) {
			put('			<td width="10%" class="small" align="center">'.$tCal[$i].'</td>');
		}
		put('		  </tr>');

		$num_day = date("w", mktime(0,0,0,$month,01,$year));
		if ( $num_day==0 ) { 
			$num_day = 7;
		}
		$max_day = date("t", mktime(0,0,0,$month,01,$year));
		$cpt_day = 2 ;
		while ( $cpt_day <= $max_day+$num_day ) {
			put("		  <tr>");

			// calcul le numero de semaine
			$nb_day = date("z", mktime(0,0,0,$month,$cpt_day-$num_day+3,$year));
			$val	= intval($nb_day/7)+1;
			$val	= (($val < 10) ? "0".$val : $val) ;
			put('		  <td width="10%" class="small" align="center" bgcolor="'.$color1.'">'.$val.'</td>');

			// affiche les jours du mois
			for ( $i=0; $i<7; $i++) {
				$theday = date("D", mktime(0,0,0,$month,$cpt_day-$num_day,$year));
				$val	= date("d", mktime(0,0,0,$month,$cpt_day-$num_day,$year));
				$jourferie	= CalculJoursFeries($month,$cpt_day-$num_day,$year);
				$class		='bgcolor="#FFFFFF" class="small"';
				if (($theday=="Sun") or ($theday=="Sat")or ($jourferie)){ 
					$class='bgcolor="'.$color1.'" class="small"';
				}
				if ($now==date("Y/m/d",mktime(0,0,0,$month,$cpt_day-$num_day,$year))){ 
					$class='bgcolor="#FFFFFF" class="error"';
				}
				if ( (($cpt_day-$num_day)<1) or (($cpt_day-$num_day)>$max_day) ) {
					$class='bgcolor="#FFFFFF" class="small"';  
					if (($theday=="Sun") or ($theday=="Sat")or ($jourferie)){ 
						$class='bgcolor="'.$color1.'" class="small"';
					}
				}
				$cpt_day++;
				put('		  <td width="10%" '.$class.' align="center">'.$val.'</td>');
			}
			put("		  </tr>");
		}

		put('		</table>')	;
		put('		</td></tr>');
		put('		</table>')	;
	}

?>