<?PHP
/* vim: set expandtab tabstop=4 shiftwidth=4: */
// +----------------------------------------------------------------------------+
// | <G a n e s h a> - Free Web Based Training System                           |
// +----------------------------------------------------------------------------+
// | <G a n e s h a> - Plate-forme de tlformation gratuite et en open source  |
// +----------------------------------------------------------------------------|
// | Copyright (C) 2001-2003  Anma Formation  <http://www.anema.fr/>           |
// +----------------------------------------------------------------------------+
// |           Developer : Georges CALDEIRA <gcaldeira@anemalab.org>            |
// +----------------------------------------------------------------------------+
// |              Infos on project <http://anemalab.org/>                       |
// +----------------------------------------------------------------------------+
// | This program is free software; you can redistribute it and/or modify       |
// | it under the terms of the GNU General Public License as published by       |
// | the Free Software Foundation; either version 2 of the License, or          |
// | (at your option) any later version.                                        |
// |                                                                            |
// | This program is distributed in the hope that it will be useful,            |
// | but WITHOUT ANY WARRANTY; without even the implied warranty of             |
// | MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the              |
// | GNU General Public License for more details.                               |
// |                                                                            |
// | You should have received a copy of the GNU General Public License          |
// | along with this program; if not, write to the Free Software                |
// | Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA   |
// +----------------------------------------------------------------------------+

/**
* Gestion des couleurs, ce module vous permet de gerer les skins de Ganesha
*
* @author		Georges Caldeira <gcaldeira@anemalab.org>
* @package		GaneshaInc
*/

	//$SKIN = array("caramel","anema","php","black","purple","verdure","citrouille","webciti","sapin","install","beige","menthe");

	$SKIN = array();
	
	/**
	* Lecture des skins.
	* @access	public
	*/	
	function ReadSkinDirectory() {
		global $SKIN ;
		array_splice($SKIN,0);
    	$d = dir(RP_SKIN);
    	while($entry=$d->read()) {
    		if ($entry != '.' && $entry != '..' && @is_dir(RP_SKIN.$entry)) {
    			$SKIN[] = $entry;
    		}
   		}
		$d->close();
	}
	

	/**
	* Affiche la ComboBox avec tous les skins 
	* @access	public
	*/
	function ViewSkin() {
		global $gconnexionid, $ext, $menu, $gskin, $SKIN ;
		if ( OPT_SKIN_ACTIVE )  {
			//ReadSkinDirectory();
			$val = HTTP_GANESHA.'index'.$ext.'?connexion='.$gconnexionid.'&menu='.$menu.'&newskin=';
			put('<form method="post" action="">')	;
			put('<img src="'.HTTP_IMAGES.'palette.gif" border="0" alt="" />');
			BeginSelect("SkinTutor") ;
			for ($i=0;$i<count($SKIN);$i++) {
				AddSelectValue($SKIN[$i],$val.$SKIN[$i],($gskin==$SKIN[$i]?"SELECTED":""))	;
			}
			EndSelect()		;
			put('</form>')	;
		} 
	}

	/**
	* Retourne $color2a si $indice est pair, sinon $color4 
	* @param	integer	$indice valeur pair ou impair
	* @return	integer Retourne une couleur en fonction de la parite de $indice
	* @access	public
	*/
	function GetColor($indice) {
		global $color2a, $color4 ;
		$i = $indice % 2 ;
		return(($i==0 ? $color2a : $color4)) ;
	}


	/**
	* Retourne $color2a si $indice est pair, sinon $color4 
	* @param	integer	$skin valeur du skin a charger
	* @access	public
	*/
	function LoadSkin($skin) { 
		global $color1,$color2,$color3,$color2a,$color1a,$color4,$color5,$BodyColor,$error,$headercolor;
		global $SKIN, $gfilecss ;
		ReadSkinDirectory();
		if ( ! OPT_SKIN_ACTIVE) {
			include_once(RP_SKIN."default/color.inc.php");
			$gfilecss = 'default' ;
			return(true);
		} 

		include_once(RP_SKIN.$skin."/color.inc.php");
		$gfilecss = $skin ;
		
		return(true);
	}

	
?>