DROP TABLE IF EXISTS bno;
CREATE TABLE bno (
  type_outil tinyint(3) unsigned NOT NULL default '0',
  id_membre tinyint(11) unsigned NOT NULL default '0',
  id_groupe tinyint(3) unsigned NOT NULL default '0',
  date_maj timestamp(14) NOT NULL,
  contenu longtext,
  PRIMARY KEY  (type_outil,id_membre,id_groupe)
) TYPE=MyISAM;

DROP TABLE IF EXISTS evalannexes;
CREATE TABLE evalannexes (
  id int(11) NOT NULL auto_increment,
  id_stagiaire int(11) NOT NULL default '0',
  id_evaluation int(11) NOT NULL default '0',
  id_evaluateur int(11) NOT NULL default '0',
  date varchar(15) NOT NULL default '',
  statut int(11) NOT NULL default '0',
  temps int(11) NOT NULL default '0',
  commentaire text NOT NULL,
  PRIMARY KEY  (id)
) TYPE=MyISAM;

DROP TABLE IF EXISTS evalanxdesc;
CREATE TABLE evalanxdesc (
  id int(11) NOT NULL auto_increment,
  nom varchar(100) NOT NULL default '',
  contexte text NOT NULL,
  PRIMARY KEY  (id)
) TYPE=MyISAM;

DROP TABLE IF EXISTS gtracking;
CREATE TABLE gtracking (
  cnx int(11) NOT NULL default '0',
  user_id int(11) NOT NULL default '0',
  groupe_id int(11) NOT NULL default '0',
  module_id int(11) NOT NULL default '0',
  chapitre_id int(11) NOT NULL default '0',
  date varchar(10) NOT NULL default '',
  score int(11) NOT NULL default '0',
  max_score int(11) NOT NULL default '0',
  time varchar(8) NOT NULL default '0',
  status int(11) NOT NULL default '0',
  KEY cnx (cnx)
) TYPE=MyISAM;

DROP TABLE IF EXISTS inscription;
CREATE TABLE inscription (
  code varchar(20) NOT NULL default '',
  id_groupe int(11) NOT NULL default '0',
  etat char(1) NOT NULL default '',
  nb int(11) NOT NULL default '0',
  date varchar(15) NOT NULL default '',
  KEY code (code)
) TYPE=MyISAM;

DROP TABLE IF EXISTS module;
CREATE TABLE module (
  id_module int(11) NOT NULL default '0',
  titre varchar(80) NOT NULL default '',
  numero int(11) NOT NULL default '0',
  link varchar(80) NOT NULL default '',
  norme int(11) NOT NULL default '0',
  type int(11) NOT NULL default '0'
) TYPE=MyISAM;

DROP TABLE IF EXISTS options;
CREATE TABLE options (
  name varchar(30) NOT NULL default '',
  value char(1) NOT NULL default ''
) TYPE=MyISAM;
INSERT INTO options VALUES ('OPT_MENU_GRAPH_ACTIVE', '0');
INSERT INTO options VALUES ('OPT_BNO_ACTIVE', '1');
INSERT INTO options VALUES ('OPT_EVALANX_ACTIVE', '1');
INSERT INTO options VALUES ('OPT_MAIL_ACTIVE', '1');
INSERT INTO options VALUES ('OPT_UPLOAD_ACTIVE', '1');
INSERT INTO options VALUES ('OPT_STUDENT_UPLOAD_DOC_ACTIVE', '1');
INSERT INTO options VALUES ('OPT_FICHE_ACTIVE', '1');
INSERT INTO options VALUES ('OPT_SKIN_ACTIVE', '1');
INSERT INTO options VALUES ('OPT_CALENDAR_ACTIVE', '1');
INSERT INTO options VALUES ('OPT_NEWS_ACTIVE', '1');
INSERT INTO options VALUES ('OPT_STUDENT_SHOW_GROUPE_ACTIVE', '1');
INSERT INTO options VALUES ('OPT_STUDENT_SHOW_RESULT_ACTIVE', '1');
INSERT INTO options VALUES ('OPT_STUDENT_SHOW_DETAIL_ACTIVE', '1');
INSERT INTO options VALUES ('OPT_AUTORIZ_TUTOR_ADMIN', '1');
INSERT INTO options VALUES ('OPT_MENU_ADMIN_LEFT_ACTIVE', '0');
INSERT INTO options VALUES ('OPT_ONLY_OBJECT_WM_ACTIVE', '1');
INSERT INTO options VALUES ('OPT_WINDOW_CHAT', '1');
INSERT INTO options VALUES ('CREATE_DIR_GRP', '1');

DROP TABLE IF EXISTS options2;
CREATE TABLE options2 (
  name varchar(30) NOT NULL default '',
  value varchar(10) NOT NULL default ''
) TYPE=MyISAM;
INSERT INTO options2 VALUES ('DIR_GRP', 'GRP');
INSERT INTO options2 VALUES ('GRP_CODE', 'G');
INSERT INTO options2 VALUES ('MOD_CODE', 'M');
INSERT INTO options2 VALUES ('TRACE', '0');
INSERT INTO options2 VALUES ('DEBUG', '0');
INSERT INTO options2 VALUES ('DEBUG_AICC', '0');
INSERT INTO options2 VALUES ('MAX_FILE_SIZE', '400000');
INSERT INTO options2 VALUES ('MAX_CAR_MSG_WM', '0');
INSERT INTO options2 VALUES ('TIME_OUT_CNX', '1800');

DROP TABLE IF EXISTS session_evalanx;
CREATE TABLE session_evalanx (
  id_groupe int(11) NOT NULL default '0',
  id_stagiaire int(11) NOT NULL default '0',
  id_evaluation int(11) NOT NULL default '0'
) TYPE=MyISAM;

DROP TABLE IF EXISTS session_groupe;
CREATE TABLE session_groupe (
  id_groupe int(11) NOT NULL default '0',
  id_module int(11) NOT NULL default '0'
) TYPE=MyISAM;





# ALTER TABLE connexion
ALTER TABLE connexion MODIFY id_connexion varchar(10) NOT NULL default '';
ALTER TABLE connexion MODIFY date_connexion varchar(15) NOT NULL default '';

# ALTER TABLE document
ALTER TABLE document MODIFY titre varchar(100) NOT NULL default '';
ALTER TABLE document MODIFY fichier varchar(100) NOT NULL default '';
ALTER TABLE document MODIFY date varchar(20) NOT NULL default '';
ALTER TABLE document MODIFY taille varchar(20) NOT NULL default '';
ALTER TABLE document CHANGE text `comment` text NOT NULL default '';

# ALTER TABLE formation
ALTER TABLE formation ADD groupe_id tinyint(4) NOT NULL default '0';

# ALTER TABLE list_groupe
ALTER TABLE list_groupe MODIFY name varchar(50) NOT NULL default '';
ALTER TABLE list_groupe MODIFY date_debut varchar(20) NOT NULL default '';
ALTER TABLE list_groupe MODIFY date_fin varchar(20) NOT NULL default '';
ALTER TABLE list_groupe MODIFY date_presentiel varchar(20) NOT NULL default '';
ALTER TABLE list_groupe MODIFY repertoire varchar(100) NOT NULL default '';
ALTER TABLE list_groupe MODIFY planning varchar(100) NOT NULL default '';
ALTER TABLE list_groupe ADD code varchar(20) NOT NULL default '';

# ALTER TABLE list_module
ALTER TABLE list_module ADD code varchar(20) NOT NULL default '';

# ALTER TABLE membres
ALTER TABLE membres MODIFY prenom varchar(100) NOT NULL default '';
ALTER TABLE membres MODIFY nom varchar(100) NOT NULL default '';
ALTER TABLE membres MODIFY login varchar(50) NOT NULL default '';
ALTER TABLE membres MODIFY password varchar(50) NOT NULL default '';
ALTER TABLE membres MODIFY cv varchar(100) NOT NULL default '';
ALTER TABLE membres MODIFY date_creation varchar(20) NOT NULL default '';
ALTER TABLE membres MODIFY date_connexion varchar(20) NOT NULL default '';
ALTER TABLE membres MODIFY email varchar(100) NOT NULL default '';
ALTER TABLE membres MODIFY adresse varchar(250) NOT NULL default '';
ALTER TABLE membres MODIFY cp varchar(15) NOT NULL default '';
ALTER TABLE membres MODIFY ville varchar(100) NOT NULL default '';
ALTER TABLE membres CHANGE skin skin VARCHAR(20) DEFAULT 'anema' NOT NULL;
UPDATE membres SET skin='anema';

# ALTER TABLE mes_doc
ALTER TABLE mes_doc MODIFY fichier varchar(100) NOT NULL default '';

# ALTER TABLE mes_rec
ALTER TABLE mes_rec MODIFY fichier varchar(100) NOT NULL default '';
ALTER TABLE mes_rec MODIFY date varchar(20) NOT NULL default '';
ALTER TABLE mes_rec ADD objet varchar(100) NOT NULL default '';

# ALTER TABLE mes_send
ALTER TABLE mes_send MODIFY fichier varchar(100) NOT NULL default '';
ALTER TABLE mes_send MODIFY date varchar(20) NOT NULL default '';
ALTER TABLE mes_send ADD objet varchar(100) NOT NULL default '';

# ALTER TABLE mode_auth
ALTER TABLE mode_auth MODIFY type varchar(20) NOT NULL default '';

# ALTER TABLE tracking
ALTER TABLE tracking ADD groupe_id int(11) NOT NULL default '0' ;
ALTER TABLE tracking MODIFY date varchar(20) NOT NULL default '' ;
ALTER TABLE tracking CHANGE note score int(11) NOT NULL default '0' ;
ALTER TABLE tracking CHANGE temps time int(11) NOT NULL default '0' ;
ALTER TABLE tracking ADD max_score int(11) NOT NULL default '0' ;
ALTER TABLE tracking ADD status int(11) NOT NULL default '0' ;

# ALTER TABLE type_membres
ALTER TABLE type_membres MODIFY description varchar(50) NOT NULL default '' ;

# UPDATE TABLE module
UPDATE module SET type=2 WHERE numero=0;

# UPDATE TABLE session_groupe
ALTER TABLE session_groupe ADD ordre tinyint(4) NOT NULL default '0' ;