% gf_integ(stringing method) Return a FEM Integration Method from a string
% description.
% 
%   Possible descriptions are (non exhaustive list):
%  * IM_EXACT_SIMPLEX(n)
%    Exact integration on simplices (works only with linear geometric
% transformations and PK FEMs). Note that 'exact integration'   should be
% avoided in general, since they only apply to linear   geometric
% transformations, are quite slow, and subject to   numerical stability problems
% for high degree FEMs.
%  * IM_PRODUCT(a, b)   Product of two integration methods.
% 
%   * IM_EXACT_PARALLELEPIPED(n)
%    Exact integration on parallelepipeds.
% 
%   * IM_EXACT_PRISM(n)
%    Exact integration on prisms.
% 
%   * IM_GAUSS1D(K)
%    Gauss method on the segment, order K (K=1,3,...99).
% 
%   * IM_NC(N,K)
%    Newton-Cotes approximative integration on simplexes, order K.
% 
%   * IM_NC_PARALLELEPIPED(N,K)
%    Product of Newton-Cotes integration on parallelepipeds.
% 
%   * IM_NC_PRISM(N,K)
%    Product of Newton-Cotes integration on prisms.
% 
%   * IM_GAUSS_PARALLELEPIPED(N,K)
%    Product of Gauss1D integration on parallelepipeds.
% 
%   * IM_TRIANGLE(K)
%    Gauss methods on triangles (K=1,3,5,6,7,8,9,10,13,17,19).
% 
%   * IM_QUAD(K)
%    Gauss methods on quadrilaterons (K=2, 3, 5, .. 17). Note that
% IM_GAUSS_PARALLELEPIPED should be prefered for QK FEMs.
% 
%   * IM_TETRAHEDRON(K)
%    Gauss methods on tetrahedrons (K=1, 2, 3, 5, 6 or 8).
% 
%   * IM_SIMPLEX4D(3)
%    Gauss method on a 4-dimensional simplex.
% 
%   * IM_STRUCTURED_COMPOSITE(IM1, K)
%     Composite method on a grid with K divisions.
% 
%   * IM_HCT_COMPOSITE(IM1)
%    Composite integration suited to the HCT composite finite element.
% 
%   example:
%    gf_integ('IM_PRODUCT(IM_GAUSS1D(5),IM_GAUSS1D(5))')
%    is the same as:
%    gf_integ('IM_GAUSS_PARALLELEPIPED(2,5)')
function [varargout]=gf_integ(varargin)
  if (nargout),
    [varargout{1:nargout}]=gf_matlab('integ',varargin{:});
  else
    gf_matlab('integ',varargin{:});
    if (exist('ans','var') == 1), varargout{1}=ans; end;
  end;
