% FUNCTION [...] = gf_levelset_set(levelset LS, [operation [, args]])
%
%   General function for modification of LEVELSET objects.
%   
%
%   * gf_levelset_set(levelset LS, 'values', {mat v1|string func_1}[, mat v2|string func_2])
%   Set values of the vector of dof for the level-set functions.
%   
%   Set the primary function with the vector of dof `v1` (or the expression
%   `func_1`) and the secondary function (if any) with  the vector of dof
%   `v2` (or the expression `func_2`)
%
%   * gf_levelset_set(levelset LS, 'simplify'[, scalar eps=0.01])
%   Simplify dof of level-set optionally with the parameter `eps`.
%
%
function [varargout]=gf_levelset_set(varargin)
  if (nargout),
    [varargout{1:nargout}]=gf_matlab('levelset_set', varargin{:});
  else
    gf_matlab('levelset_set', varargin{:});
    if (exist('ans', 'var') == 1), varargout{1}=ans; end;
  end;
% autogenerated mfile;
