% FUNCTION [...] = gf_slice_set(slice S, [operation [, args]])
%
%   Edition of mesh slices.
%   
%
%   * gf_slice_set(slice S, 'pts', mat P)
%   Replace the points of the slice.
%   
%   The new points `P` are stored in the columns the matrix. Note that
%   you can use the function to apply a deformation to a slice, or to
%   change the dimension of the slice (the number of rows of `P` is not
%   required to be equal to gf_slice_get(slice S, 'dim')).
%
%
function [varargout]=gf_slice_set(varargin)
  if (nargout),
    [varargout{1:nargout}]=gf_matlab('slice_set', varargin{:});
  else
    gf_matlab('slice_set', varargin{:});
    if (exist('ans', 'var') == 1), varargout{1}=ans; end;
  end;
% autogenerated mfile;
