<?php

// -----------------------------------------------------------------------
// This file is part of Igloo
// 
// Copyright (C) 2003, 2005 Barnraiser
// http://www.barnraiser.org/
// info@barnraiser.org
// 
// This program is free software; you can redistribute it and/or modify it
// under the terms of the GNU General Public License as published by the
// Free Software Foundation; either version 2, or (at your option) any
// later version.
// 
// This program is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
// General Public License for more details.
// 
// You should have received a copy of the GNU General Public License
// along with program; see the file COPYING. If not, write to the Free
// Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
// 02110-1301, USA.
// -----------------------------------------------------------------------
$menu_section = "my";
include "inc/header.inc.php";

if (!isset($me['user_id']) || $me['user_id'] < 1) {
	header("Location: index.php?" . strip_tags(SID));
	exit;
}

//append language setup
require_once($languageArrayPath . 'arr_user.lang.php');
require_once($languageArrayPath . 'arr_rsp.lang.php');


//setup file
$file->noimage = $c_node['file']['image']['thumb'][3]['noimage'];
$file->thumb = $c_node['file']['image']['thumb'][3]['name'];


//setup forum
require_once($c_node['dir']['class_path'] . 'Forum.class.php');
$forum = new Forum($db, null, $file);


//setup blog
require_once($c_node['dir']['class_path'] . 'Blog.class.php');
$blog = new Blog($db, null, $file);
$blog->user_id = $me['user_id'];


//setup shout
require_once($c_node['dir']['class_path'] . 'Shout.class.php');
$shout = new Shout($db);
$shout->user_id = $me['user_id'];


//library setup
require_once($c_node['dir']['class_path'] . 'Library.class.php');
$library = new Library($db, null, $file);
$library->user_id = $me['user_id'];


//poll setup
require_once($c_node['dir']['class_path'] . 'Poll.class.php');
$poll = new Poll($db, null);
$poll->user_id = $me['user_id'];


//schedule setup
require_once($c_node['dir']['class_path'] . 'Schedule.class.php');
$schedule = new Schedule($db, null, $date, $file);
$schedule->user_id = $me['user_id'];


//get published items
$output_publish_library = $library->selLibraryItems();
$output_publish_forum = $forum->selSubjects();
$output_blogs = $blog->selBlogs();
$output_shouts = $shout->getShouts();

//get total replies for subjects
if (!empty($output_publish_forum)) {
    foreach($output_publish_forum as $key => $i):
		$forum->subject_id = $i['subject_id'];
		//$output_publish_forum[$key]['total_replies'] = $forum->getReplyCount();
		$output_publish_forum[$key]['total_replies'] = 0;
	endforeach;
}

	
	
//setup comment
require_once($c_node['dir']['class_path'] . 'Comment.class.php');
$comment = new Comment($db, null, $date);
$comment->user_id = $me['user_id'];
$comment->limit = 10;
$output_comments = $comment->selComments();
	
	

//get poll participation
$output_poll_participation = $poll->getUserPollParticipation();

//move to template
if (!empty($output_publish_library)) {
    $body->set('publish_library', $output_publish_library);
}

if (!empty($output_comments)) {
	$body->set('comments', $output_comments);
}

if (!empty($output_blogs)) {
    $body->set('blogs', $output_blogs);
}

if (!empty($output_publish_forum)) {
    $body->set('publish_forum', $output_publish_forum);
}

if (!empty($output_shouts)) {
    $body->set('publish_shouts', $output_shouts);
}

if (!empty($output_user)) {
    $body->set('user', $output_user);
}

if (!empty($output_relationship)) {
    $body->set('relationship', $output_relationship);
}

if (!empty($output_poll_participation)) {
    $body->set('poll_participation', $output_poll_participation);
}

$body->set('rsp_item_type_ids', $c_node['rsp']['item_type']);

$template_pageLink = $lang['txt_publishing'];
include "inc/footer.inc.php";

?>
