<?php

// -----------------------------------------------------------------------
// This file is part of Igloo
//
// Copyright (C) 2003, 2005 Barnraiser
// http://www.barnraiser.org/
// info@barnraiser.org
//
// This program is free software; you can redistribute it and/or modify it
// under the terms of the GNU General Public License as published by the
// Free Software Foundation; either version 2, or (at your option) any
// later version.
//
// This program is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
// General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with program; see the file COPYING. If not, write to the Free
// Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
// 02110-1301, USA.
// -----------------------------------------------------------------------
?>

<div class="col_main">
	<?php
	if (isset($poll)) {
	?>
	<div class="box">
		<div class="box_top">
			<?php echo $lang['hdr_poll'];?><br />
		</div>

		<div class="box_mid">
			<div class="content">
				<table border="0" cellspacing="2" cellpadding="0" width="100%">
					<tr>
						<td valign="top">
							<?php
							include $templatePath . "poll_detail.inc.tpl.php";
							?>
						</td>
					</tr>
					<?php
					if (isset($poll_history)) {
					?>
					<tr>
						<td class="vote_results_box" valign="top">
							<b><?php echo $lang['hdr_my_vote_history'];?></b><br />
							<?php
							$separator = ", ";
							foreach($poll_history as $key => $r):
								if ($key == (count($poll_history)-1)) {
									$separator=".";
								}
								
								echo $r['option_body'] . " (" . $this->date->formatDate($r['answer_create_datetime'], 1) . ")" . $separator;
							endforeach;
							?>
						</td>
					</tr>
					<?php }?>
				</table>
				
				<div class="metadata">
					<?php
					if (isset($author)) {
					?>
						<p>
							<b><?php echo $lang['txt_author'];?></b> -&#62; 
							<?php echo $lang['txt_profile_nic'];?>: 
							<a href="sn_profile.php?user_id=<?php echo $author['user_id'];?>"><?php echo $author['profile_nic'];?></a>, 
							<?php echo $lang['txt_profile_session_status'];?>: 
							<?php
							if ($author['online_status'] == 1) {
								echo "<b>" . $lang['arr_user_online_status'][1] . "</b>";
							}
							else {
									echo $lang['arr_user_online_status'][$author['online_status']];
							}
							?>, 
							<?php echo $lang['txt_hometown'];?>: 
							<?php echo $author['profile_hometown'];?>, 
							<?php echo $lang['txt_joined'];?>: 
							<?php echo $this->date->formatDate($author['profile_create_datetime']);?>
							<br />
						</p>
						
						<p>
							<b><?php echo $lang['hdr_poll'];?></b> -&#62; 
							<?php
							if (!empty($poll['bookmark'])) {
								echo $lang['txt_bookmarks'] . ": ";
								
								if (!empty($poll['bookmark']['watch'])) {
									echo $lang['txt_marked'];
								}
				
								if (!empty($poll['bookmark']['recommend'])) {
									echo $lang['txt_tipped'];
								}
								echo ", ";
							}
							?>
							<?php
							if ($poll['poll_create_datetime'] != $poll['poll_edit_datetime'] && !empty($poll['poll_edit_datetime'])) {
								echo $lang['txt_last_edited'] . ": ";
								echo $this->date->formatDate($poll['poll_edit_datetime'], 1) . ", ";
							}
							?>
							<?php echo $lang['txt_published_to'];?>: 
							<?php
							if (isset($poll['rsp'])) {
								foreach($poll['rsp'] as $key => $i):
									
									echo trim($lang['rsp']['rsp_level'][$i['level_id']] . " " . $i['degree_id']);
									echo " (" .$lang['rsp']['status'][$i['status_id']] . ")";
									if ($key+1 < count($poll['rsp'])) {
										echo ", ";
									}
									
								endforeach;
							}
							?>
							<br />
						</p>
					<?php }?>
				</div>
			</div>
		</div>
	</div>
		
	<div class="box_bottom">
		<span class="box_bottom_right"></span>
		<span class="box_bottom_left"></span>
	</div>
	
	<div class="box">
		<div class="box_top">
			<?php echo $lang['hdr_comments'];?><br />
		</div>
		
		<div class="box_mid">
			<div class="content">
				<?php
				//comments
				if (isset($me['user_id']) && $poll['user_id'] == $me['user_id']) {
					$unlocked = 1;
				}
				
				if (!empty($poll['poll_allow_comments'])) {
					$unlocked = 1;
				}
				
				$hidden_form = array(
					"poll_id" => $poll['poll_id']
				);
				
				if (isset($_REQUEST['user_id'])) {
					$hidden_form['user_id'] = $_REQUEST['user_id'];
				}
				include $templatePath . "comment.inc.tpl.php";
				?>
			</div>
		</div>
	</div>
		
	<div class="box_bottom">
		<span class="box_bottom_right"></span>
		<span class="box_bottom_left"></span>
	</div>
	
	<?php
	}
	else { //LIST
	?>
	<div class="box">
		<div class="box_top">
			<?php echo $lang['hdr_polls'];?><br />
		</div>
			
		<div class="box_mid">
			<div class="content">
				<table border="0" cellspacing="0" cellpadding="4" width="100%">
					<?php			
					if (isset($polls)) {
					foreach($polls as $key => $i):
					
						$poll_url = "pol_view.php?poll_id=" . $i['poll_id'];
					
					?>
					<tr>
						<td>
							<b><?php echo $i['poll_question'];?></b><br />
						</td>
					</tr>
					<tr>
						<td valign="top" colspan="2">
							<table width="360" cellpadding="0" cellspacing="20" border="0">
								<tr>
									<td class="picture">
									<?php
									$poll = $i;
									
									include $templatePath . "poll.inc.tpl.php";
									?>
									</td>
								</tr>
							</table>
						</td>
				    </tr>
					<?php
					endforeach;
					}
					else {
					?>
					<tr>
						<td>
							<?php echo $lang['err_no_polls'];?><br />
						</td>
					</tr>
					<?php
					}
					?>
				</table>
			</div>
		</div>
	</div>
		
	<div class="box_bottom">
		<span class="box_bottom_right"></span>
		<span class="box_bottom_left"></span>
	</div>
	<?php }?>
</div>

<div class="col_side">
	<form action="pol_view.php" method="post" name="frm_view" id="id_frm_view">
	<input type="hidden" name="poll_id" value="<?php if(isset($poll['poll_id'])) { echo $poll['poll_id'];}?>" />
	
	<div class="box">
		<div class="box_top">
				<?php echo $lang['hdr_options'];?><br />
			</div>
			
			<div class="box_mid">
				<div class="content">
					<p>
						<select name="options" class="options_select">
							<option value="list_node" selected="selected"><?php echo $lang['txt_option_group'];?></option>
							
							<?php
							if (isset($me['user_id'])) {
							?>
								<?php
								$selected = "";
								if (isset($frmdata) && $frmdata['options'] == "list_relation") {
								$selected = "selected=\"selected\"";
								}
								?>
								<option value="list_relation" <?php echo $selected;?>><?php echo $lang['txt_option_network'];?></option>
								
								<?php
								$selected = "";
								if (isset($frmdata) && $frmdata['options'] == "list_my") {
								$selected = "selected=\"selected\"";
								}
								?>
								<option value="list_my" <?php echo $selected;?>><?php echo $lang['txt_option_items'];?></option>
								
								<?php
								$selected = "";
								if (isset($frmdata) && $frmdata['options'] == "list_vote") {
								$selected = "selected=\"selected\"";
								}
								?>
								<option value="list_vote" <?php echo $selected;?>><?php echo $lang['txt_option_vote'];?></option>
								
								<?php
								$selected = "";
								if (isset($frmdata) && $frmdata['options'] == "list_marked") {
								$selected = "selected=\"selected\"";
								}
								?>
								<option value="list_marked" <?php echo $selected;?>><?php echo $lang['txt_option_marked'];?></option>
								
								<?php
								$selected = "";
								if (isset($frmdata) && $frmdata['options'] == "list_relation_tips") {
								$selected = "selected=\"selected\"";
								}
								?>
								<option value="list_relation_tips" <?php echo $selected;?>><?php echo $lang['txt_option_tipped'];?></option>
								
								<?php
								if (isset($poll)) {
								?>
								<option value="list_user"><?php echo $lang['txt_option_list'];?></option>
								<?php }?>
								<option> </option>
								<?php
								if (isset($poll)) {
								?>
								
								<?php
								if (empty($poll['bookmark']['watch'])) {
								?>
								<option value="item_mark"><?php echo $lang['txt_option_mark'];?></option>
								<?php }?>
								
								<?php
								if (empty($poll['bookmark']['recommend'])) {
								?>
								<option value="item_tip"><?php echo $lang['txt_option_tip'];?></option>
								<?php
								}
								if ($this->user_acs->checkPermission($resource_ids['poll'], $privilege_ids['add_item'])) { //resourece_id, Priv_id
								?>
								<option value="item_edit"><?php echo $lang['txt_option_edit'];?></option>
								<?php
								}
								}
								
								if ($this->user_acs->checkPermission($resource_ids['poll'], $privilege_ids['add_item'])) { //resourece_id, Priv_id
								?>
								<option value="item_add"><?php echo $lang['txt_option_add'];?></option>
								<?php }?>
							<?php }?>
						</select>
						<input type="image" src="<?php echo $templatePath;?>img/go.png" name="option_action" value="1" class="go" /><br />
					</p>
					
					<?php
					if (isset($poll)) {
					?>
						<p>
							<b><?php echo $lang['hdr_tag'];?></b><br />
						</p>
						
						<p>
							<?php
							$tags = "";
							if (isset($item_tags)) {
								foreach ($item_tags as $key => $i):
									$tags .= "<a href='search.php?tag=" . $i['tag_body']. "'>" . $i['tag_body'] . "</a>";
									
									if ($i['user_id'] == $me['user_id']) {
										$tags .= "*";
									}
									
									if (count($item_tags) > $key+1) {
										$tags .= ", ";
									}
								endforeach;
								echo $tags;
							}
							?>
						</p>
					
					<?php
					if ($this->user_acs->checkPermission($resource_ids['poll'], $privilege_ids['allow_tagging'])) { //resourece_id, Priv_id
					$tags = "";
					if (isset($my_tags)) {
						foreach ($my_tags as $key => $i):
							$tags .= $i['tag_body'];
							if (count($my_tags) > $key+1) {
								$tags .= ", ";
							}
						endforeach;
					}
					?>
					<p>
						<input width="30" name="tags" value="<?php echo $tags;?>" />
						<input type="image" src="<?php echo $templatePath;?>img/go.png" name="update_tag" value="1" class="go" /><br />
					</p>
					<?php }?>
				<?php }?>
				
				<p>
					<b><?php echo $lang['hdr_search'];?></b><br />
				</p>
				
				<p>
					<input type="text" name="search_text" size="20" value="<?php if (isset($search_text)) { echo $search_text;};?>" />
					<input type="image" src="<?php echo $templatePath;?>img/go.png" value="search" class="go" /><br />
				</p>
			</div>
		</div>
	</div>
	
	<div class="box_bottom">
		<span class="box_bottom_right"></span>
		<span class="box_bottom_left"></span>
	</div>
</div>
