<?php

// -----------------------------------------------------------------------
// This file is part of Igloo
// 
// Copyright (C) 2003, 2005 Barnraiser
// http://www.barnraiser.org/
// info@barnraiser.org
// 
// This program is free software; you can redistribute it and/or modify it
// under the terms of the GNU General Public License as published by the
// Free Software Foundation; either version 2, or (at your option) any
// later version.
// 
// This program is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
// General Public License for more details.
// 
// You should have received a copy of the GNU General Public License
// along with program; see the file COPYING. If not, write to the Free
// Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
// 02110-1301, USA.
// -----------------------------------------------------------------------

include "inc/header.inc.php";
include "config/config_acs.inc.php";

require_once($languageArrayPath . 'arr_language_name.lang.php');


if ($c_node['node']['allow_registration'] != 1) {
    header("Location: index.php?" . strip_tags(SID));
	exit;
}



//setup useradmin (extends user)
require_once($c_node['dir']['class_path'] . 'User.class.php');
require_once($c_node['dir']['class_path'] . 'UserAdmin.class.php');
$user = new UserAdmin($db, $date);
$user->language_dir = $c_node['node']['template_default_name'];



//form actions
if (isset($_POST['preview'])) {
	$display = "preview";
}
elseif (isset($_POST['edit_again'])) {
	
}
elseif (isset($_POST['register'])) {
	// Checks the email and the password
	$catpcha = strtoupper($_POST['captchastring']);
	if (empty($catpcha) || $_SESSION['CAPTCHAString'] != $catpcha) {
		$GLOBALS['igloo_error_log'][] = array(36, null, null);
	}

	if (isset($_POST['language_ids'])) {
	    $frmdata['language_ids'] = $_POST['language_ids'];
	}
	
	$frmdata['user_dob'] = $_REQUEST['year']."-".$_REQUEST['month']."-".$_REQUEST['day'];
	
	$user->checkRegister($frmdata);

	if (empty($GLOBALS['igloo_error_log'])) {
		//setup email
		require_once($c_node['dir']['class_path'] . '/Mail/class.phpmailer.php');
		$mail = new PHPMailer();
		$mail->Host = 		$c_node['mail']['host'];
		$mail->Mailer = 	$c_node['mail']['mailer'];
		
		if (isset($c_node['mail']['smtp']['username'])) {
			$mail->SMTPAuth = true;
			$mail->Username = $c_node['mail']['smtp']['username'];
			$mail->Password = $c_node['mail']['smtp']['password'];
		}
				
		$mail->From = 		$c_node['mail']['no_reply_address'];
		$mail->AddReplyTo	($c_node['mail']['no_reply_address'], $lang['subject_noreply']);
		$mail->FromName = 	$c_node['mail']['from_name'];
		$mail->WordWrap = 	$c_node['mail']['wordwrap'];
		$mail->Subject = 	$lang['subject_welcome_br'];
		$mail->language = 	$c_node['mail']['language'];

		$user->mail = $mail;


		if (isset($frmdata['invitee_id'])) {
			$user->invitee_id = $frmdata['invitee_id'];
		}

		$user->user_image_allocation = $c_node['file']['default_max_user_space'];
		$user->template_id = $c_node['node']['template_default_id'];
		$user->txt_default_profile_name = $lang['txt_default_profile_name'];
		$user->txt_default_profile_hometown = $lang['txt_default_profile_hometown'];
		$user->status_id = $c_node['user']['status']['pending'];
		$user->template_id = $c_node['node']['template_default_id'];
		$user->page_default = $c_node['node']['page_default'];
		$user->role_default = $c_acs['arr_acs']['user_join_role_default'];
		$user->registerUser($frmdata);

		//check if we need to add invitee into social network and add 1st
		
		if (isset($frmdata) && !empty($frmdata['invitee_id'])) {
			require_once($c_node['dir']['class_path'] . 'SocialNetwork.class.php');
			$sn = new SocialNetwork($user->user_id, $db, null);
			$relation = $sn->insertRelation($frmdata['invitee_id'], $c_node['user']['relation_type']['approved']);
		}
		
		$display = "registration_complete";
	}

}


//if someone has invited someone here
if ((isset($_REQUEST['invitee']) && $_REQUEST['invitee'] > 0) || isset($frmdata['invitee_id'])) {
	if (isset($_REQUEST['invitee'])) {
	    $invitee = $_REQUEST['invitee'];
	}
	else {
	    $invitee = $frmdata['invitee_id'];
	}
	
	

	if ($invitee > 0) {
		$output_invite = $user->selProfile(null, $invitee);
		
		if (!empty($output_invite)) {
			require_once($c_node['dir']['class_path'] . 'File.class.php');
			$file = new File($db, null, $c_node['file'], $c_node['dir']);
			$file->config_ids = $c_node['file'];
			$file->noimage = $c_node['file']['image']['thumb'][1]['noimage'];
			$file->thumb = $c_node['file']['image']['thumb'][1]['name'];
			
			if (isset($output_invite['file_id'])) {
				$file->file_id = $output_invite['file_id'];
				$output_invite['image'] = $file->getFileRecord();
			}
			else {
				$output_invite['image']['file_title'] = "";
				$output_invite['image']['file'] = $file->noimage;
			}
		}
	}
	
}
	
	
//TEMPLATE
if (isset($c_node['node']['language']['pack'])) {
    $body->set('language_available', $c_node['node']['language']['pack']);
}

if (isset($c_node['node']['language']['default'])) {
    $body->set('language_default', $c_node['node']['language']['default']);
}

if (isset($output_invite)) {
    $body->set('invite', $output_invite);
}

if (isset($display)) {
    $body->set('display', $display);
}

if (isset($_REQUEST['year'])) {
	$user_dob = $_REQUEST['year']."-".$_REQUEST['month']."-".$_REQUEST['day'];
	$body->set('year', $_REQUEST['year']);
	$body->set('month', $_REQUEST['month']);
	$body->set('day', $_REQUEST['day']);
}
else {
	$user_dob = null;
}

$body->set('datedropdown', $date->dateDropdown($user_dob));
$body->set('display_dob', $user_dob);

if (!empty($frmdata)) {
    $body->set('data', $frmdata);
}
else {
$frmdata = array("language_id" => $me['language_id']);

	if (isset($_REQUEST['email'])) {
	    $frmdata['user_email'] = $_REQUEST['email'];
	}

	$body->set('data', $frmdata);
}

include "inc/footer.inc.php";
?>
