<?php

// -----------------------------------------------------------------------
// This file is part of Igloo
// 
// Copyright (C) 2003, 2005 Barnraiser
// http://www.barnraiser.org/
// info@barnraiser.org
// 
// This program is free software; you can redistribute it and/or modify it
// under the terms of the GNU General Public License as published by the
// Free Software Foundation; either version 2, or (at your option) any
// later version.
// 
// This program is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
// General Public License for more details.
// 
// You should have received a copy of the GNU General Public License
// along with program; see the file COPYING. If not, write to the Free
// Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
// 02110-1301, USA.
// -----------------------------------------------------------------------

?>


<form action="msg_edit.php" method="post" name="frm" id="id_frm">

<div class="col_main">
	<div class="box">
		<div class="box_top">
			<?php echo $lang['hdr_message'];?><br />
		</div>
	
		<div class="box_mid">
			<div class="content">
				<?php
				if (isset($display) && $display == "size_allocation_exceeded") {
				?>
				<table cellpadding="4" cellspacing="0" border="0" width="100%">
					<tr>
						<td>
							<b><?php echo $lang['hdr_size_allocation_exceeded'];?></b><br />
							<?php echo $lang['txt_size_allocation_exceeded'];?></b><br />
						</td>
					</tr>
				</table>
				<?php
				}
				elseif (isset($display) && $display == "preview_msg") {
				?>
				<input type="hidden" name="to_user_ids" value="<?php echo $frmdata['to_user_ids']?>" />
				<input type="hidden" name="message_body" value="<?php echo $frmdata['message_body'];?>" />
				<input type="hidden" name="message_subject" value="<?php echo $frmdata['message_subject'];?>" />
				<input type="hidden" name="to_user_id" value="<?php echo $frmdata['to_user_id']?>" />
	
				<table cellpadding="4" cellspacing="0" border="0" width="100%">
					<tr>
						<td>
							<table>
								<tr>
									<td>
										<b><?php echo $lang['txt_to'];?></b>
									</td>
								</tr>
								<tr>
									<td id="id_usernames">
										<br />
									</td>
								</tr>
								<tr>
									<td>
										<b><?php echo $lang['txt_subject'];?></b><br />
									</td>
								</tr>
								<tr>
									<td>
										<?php echo $message['message_subject'];?><br />
									</td>
								</tr>
								<tr>
									<td>
										<b><?php echo $lang['txt_body'];?></b><br />
									</td>
								</tr>
								<tr>
									<td>
										<?php echo $message['message_body_display'];?>
									</td>
								</tr>
								<tr>
									<td align="right">
										<input name="edit_message_again" type="submit" value="<?php echo $lang['sub_edit'];?>" class="button_urgent" />&nbsp;&nbsp;
										<input name="send_message" type="submit" value="<?php echo $lang['sub_send'];?>" class="button_urgent" /><br />
									</td>
								</tr>
							</table>
	
						</td>
					</tr>
				</table>
				<?php
				}
				elseif (empty($users) && empty($to_user))  {
				?>
				<table cellpadding="4" cellspacing="0" border="0" width="100%">
					<tr>
						<td valign="top">
							<?php echo $lang['err_no_friends'];?><br />
						</td>
					</tr>
				</table>
				<?php
				}
				elseif (isset($display) && $display == "compose_allowed") {
				?>
	
				<table cellpadding="4" cellspacing="0" border="0" width="100%">
					<tr>
						<td>
							<table>
								<tr>
									<td>
										<b><?php echo $lang['txt_to'];?></b>
									</td>
								</tr>
								<tr>
									<td id="id_usernames">
										<br />
									</td>
								</tr>
								<tr>
									<td>
										<b><?php echo $lang['txt_subject'];?></b><br />
									</td>
								</tr>
								<tr>
									<td>
										<input name="message_subject" type="text" size="50" value="<?php echo $message['message_subject'];?>" /><br />
									</td>
								</tr>
								<tr>
									<td>
										<b><?php echo $lang['txt_body'];?></b><br />
									</td>
								</tr>
								<tr>
									<td>
										<textarea name="message_body" cols="70" rows="10" /><?php echo $message['message_body'];?></textarea><br />
									</td>
								</tr>
								<tr>
									<td align="right">
										<input name="preview_message" type="submit" value="<?php echo $lang['sub_preview'];?>" class="button_urgent" />&nbsp;&nbsp;
									<input name="send_message" type="submit" value="<?php echo $lang['sub_send'];?>" class="button_urgent" /><br />
									</td>
								</tr>
							</table>
	
						</td>
					</tr>
				</table>
				<?php
				}
				else { //we are not allowed to send to this person
				?>
				<table cellpadding="4" cellspacing="0" border="0" width="100%">
					<tr>
						<td class="txt_title" align="right">
							<?php echo $lang['hdr_im_deny_send'];?><br />
							<hr />
						</td>
					</tr>
					<tr>
						<td>
							<?php echo $lang['txt_im_deny_send'];?><br />
						</td>
					</tr>
				</table>
				
				
				<?php }?>
			</div>
		</div>
	</div>
		
	<div class="box_bottom">
		<span class="box_bottom_right"></span>
		<span class="box_bottom_left"></span>
	</div>
</div>

<div class="col_side">
	<?php
	if (isset($users)) {
	?>
	<div class="box">
		<div class="box_top">
			<?php echo $lang['hdr_friends'];?><br />
		</div>
						
		<div class="box_mid">
			<div class="content">
				<table border="0" width="100%" cellspacing="0" cellpadding="4">
					<tr>
						<td colspan="2">
							<b><?php echo $lang['hdr_tag'];?></b><br />
							<?php
							$tags = "";
							if (isset($my_tags)) {
								foreach ($my_tags as $key => $i):
									$tags .= "<a href='msg_edit.php?tag=" . $i['tag_body']. "'>" . $i['tag_body'] . "</a>, ";
								endforeach;
							}
							$tags = substr($tags, 0, -2);
							echo $tags;
							?>
							<br /><br />
						</td>
					</tr>
					<tr>
						<td>
							<b><?php echo $lang['hdr_friends'];?></b><br />
						</td>
					</tr>
					<?php
					
					foreach ($users as $key => $i):
					$nm = "";
					if (!empty($i['am_relation_to_them']['relation_show_true_self'])) {
						$nm = $i['user_firstname'] . " " . $i['user_surname'];
					}
					else {
						$nm = $i['profile_nic'];
					}
							
					?>
					<tr>
						<td valign="top" width="1">
							<?php
							if (!empty($i['profile_allow_msg'])) {
								
								$checked = "";
								
								if (isset($tag) && !empty($i['tags'])) {
									foreach ($i['tags'] as $keytg => $t):
									if ($t['tag_body'] == $tag) {
											$checked = "checked=\"checked\"";
										}
									endforeach;
								}
							?>
							<input type="checkbox" name="to_user_ids[]" value="<?php echo $i['user_id'];?>" onClick="javascript:setToNames();" class="checkbox" <?php echo $checked;?> />
							<input type="hidden" name="to_user_names[]" value="<?php echo $nm;?>" />
							<?php }?>
							<br />
						</td>
						<td valign="top">
							<?php echo $nm;?><br />
						</td>
					</tr>
					<?php
					endforeach;
					?>
					<tr>
						<td colspan="2" align="right">
							<input type="button" onClick="checkFormBoxes();" value="<?php echo $lang['sub_select_all'];?>" class="button_light" /><br />
						</td>
					</tr>
				</table>
				
				<script type="text/javascript">
				function setToNames() {
					var usernames = '';
					for (i=0;i<document.frm.length;i++) {
						if (document.frm.elements[i].checked) {
							usernames += document.frm.elements[i+1].value+', ';
						}
					}
					usernames = usernames.substr(0,usernames.length-2);
					document.getElementById('id_usernames').innerHTML = usernames+'<br />';
				}
				</script>
			</div>
		</div>
	</div>
	
	<div class="box_bottom">
		<span class="box_bottom_right"></span>
		<span class="box_bottom_left"></span>
	</div>
	
	<?php
	}
	elseif (isset($to_user)) {
	?>
	<input type="hidden" name="to_user_id" value="<?php echo $to_user['user_id']?>" />
				
	<div class="box">
		<div class="box_top">
			<?php echo $lang['txt_to'] . "  " . $to_user['profile_nic'];?><br />
		</div>
						
		<div class="box_mid">
			<div class="content">
				<img src="get_file.php?file=<?php echo $to_user['image']['file'];?>" border="0" alt="<?php echo $to_user['image']['file_title'];?>" /><br />
				
				<table border="0" cellspacing="0" cellpadding="2" width="100%">
					<tr>
						<td>
							<?php echo $lang['txt_profile_session_status'];?><br />
						</td>
						<td>
							<?php
							if ($to_user['online_status'] == 1) {
								echo "<b>" . $lang['arr_user_online_status'][1] . "</b><br />";
							}
							else {
									echo $lang['arr_user_online_status'][$to_user['online_status']] . "<br />";
							}
							?>
						</td>
					</tr>
					<tr>
						<td>
							<?php echo $lang['txt_hometown'];?><br />
						</td>
						<td>
							<?php echo $to_user['profile_hometown'];?><br />
						</td>
					</tr>
					<tr>
						<td valign="top">
							<?php echo $lang['txt_joined'];?><br />
						</td>
						<td>
							<?php echo $this->date->formatDate($to_user['profile_create_datetime']);?><br />
						</td>
					</tr>
				</table>
			</div>
		</div>
	</div>
	
	<div class="box_bottom">
		<span class="box_bottom_right"></span>
		<span class="box_bottom_left"></span>
	</div>
	<?php }?>
	
	
	

</div>
</form>

<script language="javascript">
<!--

function checkFormBoxes() { //task is check or uncheck

	var form = document.frm.elements['to_user_ids[]']
	
	var state = true;
	
	if (id.checked == false) {
		state = false;
		
	}
	

	if (form.length) {
		for (var i=0; i < form.length; i++) {
			form[i].checked = state;
	
		}
	}
	else {
		form.checked = state;
	}
}

//-->
</script>
