<?php

// -----------------------------------------------------------------------
// This file is part of Igloo
// 
// Copyright (C) 2003, 2005 Barnraiser
// http://www.barnraiser.org/
// info@barnraiser.org
// 
// This program is free software; you can redistribute it and/or modify it
// under the terms of the GNU General Public License as published by the
// Free Software Foundation; either version 2, or (at your option) any
// later version.
// 
// This program is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
// General Public License for more details.
// 
// You should have received a copy of the GNU General Public License
// along with program; see the file COPYING. If not, write to the Free
// Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
// 02110-1301, USA.
// -----------------------------------------------------------------------

include "config/config_igloo.inc.php";

// START SESSION ----------------------------------------------------------
session_start();


// SETUP TEMPLATE ----------------------------------------------------------
$template_path = $c_node['dir']['template_path'];

if (isset($_SESSION['template_id'])) {
    $template_name = $_SESSION['template_id'];
}
else {
	$template_name = $c_node['node']['template_default_name'];
}

$template_path = $template_path . $template_name . "/";

require_once($c_node['dir']['class_path'] . 'Template.class.php');
$tpl = & new Template($template_path); // This is the outter template


// SETUP LANGUAGE -----------------------------------------------------------
if (!isset($_REQUEST['language_id'])) {
	$_SESSION['language_id'] = $c_node['node']['language']['default'];
}

$languagePath = "language/" . $_SESSION['language_id'] . "/" . $template_name . "/";
$languageArrayPath = $languagePath . "arrays/";
$languageTextPath = $languagePath . "texts/";
//require_once($languagePath . 'common.lang.php');
require_once($languageArrayPath . 'arr_links.lang.php');
require_once($languageArrayPath . 'arr_error.lang.php');
require_once($languagePath . 'error.lang.php');

require_once($languageArrayPath . 'arr_language_name.lang.php');


// TEMPLATE OUTPUT -----------------------------------------------------------------------
// error reporting
if (!empty($GLOBALS['igloo_error_log'])) {
	if (isset($c_node['node']['debug_mode'])) {
	    $tpl->set('error_handling', $c_node['node']['debug_mode']);
	}
    $tpl->set('log', $GLOBALS['igloo_error_log']);
}



// language
$tpl->set('lang', $lang);


// general interface, url and template
$tpl->set('templatePath', $template_path);
$tpl->set('page_url', $_SERVER['REQUEST_URI']);
$tpl->set('page_name', basename($_SERVER['REQUEST_URI']));

if (isset($_REQUEST['error'])) {
	$tpl->set('error_id', $_REQUEST['error']);
}

echo $tpl->fetch('error.tpl.php');
	
?>
