<?php

// -----------------------------------------------------------------------
// This file is part of Igloo
// 
// Copyright (C) 2003, 2005 Barnraiser
// http://www.barnraiser.org/
// info@barnraiser.org
// 
// This program is free software; you can redistribute it and/or modify it
// under the terms of the GNU General Public License as published by the
// Free Software Foundation; either version 2, or (at your option) any
// later version.
// 
// This program is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
// General Public License for more details.
// 
// You should have received a copy of the GNU General Public License
// along with program; see the file COPYING. If not, write to the Free
// Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
// 02110-1301, USA.
// -----------------------------------------------------------------------



class Tag {
	// CLASS FUNCTIONS
	// Tag
	// selTags
	// insertTags
	// deleteTags
	
	
	
	// Tag --------------------------------------------------------------------
	// the constuctor
	// tom calthrop - 23rd July 2005
	//
	function Tag($db, $rsp_item_type_id) {
		$this->db = $db;
		$this->rsp_item_type_id = $rsp_item_type_id;
	}//EO Tag

	
	
	// selTags --------------------------------------------------------------------
	// returns tag array
	// tom calthrop - 23rd July 2005
	//
	function selTags() {
		
		$query = "
			SELECT DISTINCT t.tag_body, t.user_id 
			FROM " . $this->db->prefix . "_tag t "
		;
		
		$query .= "WHERE ";
		
		if (isset($this->user_id)) {
		    $query .= "t.user_id=" . $this->user_id . " AND ";
		}
		
		if (isset($this->rsp_item_type_id)) {
			$query .= "t.rsp_item_type_id=" . $this->rsp_item_type_id . " AND ";
		}
		
		if (isset($this->item_id)) {
			$query .= "t.item_id=" . $this->item_id . " and ";
		}
		
		if (isset($this->item_name)) {
			$query .= "t.item_name like " . $this->db->qstr("%" . $this->item_name . "%", get_magic_quotes_gpc()) . " and ";
		}
		
		$query .= "1=1 ";
		// echo $query . "<br /><br />";
		$query .= "order by t.tag_body";
		
		$result = $this->db->Execute($query);

		if (isset($result->fields)) {
			$temp = array();

			while (!$result->EOF) {
				$temp1 = $result->fields;
				array_push($temp, $temp1);
				$result->MoveNext();
			}
			
			return $temp;
			
		}
		else {
			$error_info = "function=selTags class=Tag.class.php -- " . $query . " -- " . $this->db->ErrorMsg();
			$GLOBALS['igloo_error_log'][] = array(1, 1, $error_info);
		}
	}//EO selTags
	
	
	
	// insertTags --------------------------------------------------------------------
	// inserts tags
	// tom calthrop - 23rd July 2005
	//
	function insertTags($data) {
		
		$ins_arr = explode(',', $data['tags']);
		
		$ins_arr = array_unique($ins_arr); //remove duplicates
		
		$rownums = count($ins_arr);

		for ($i=0; $i < $rownums; $i++) {
			
			$tag = trim($ins_arr[$i]);
			
			if (!empty($tag)) {
				
				$rec = array();
				$rec['tag_body'] = $tag;
				$rec['user_id'] = $this->user_id;
				$rec['rsp_item_type_id'] = $this->rsp_item_type_id;
				$rec['item_id'] = $data['item_id'];
				
				if (isset($data['item_name'])) {
					$rec['item_name'] = $data['item_name'];
				}
				$table = $this->db->prefix . "_tag";
				
				$query = $this->db->GetInsertSQL($table, $rec, get_magic_quotes_gpc());
				$result = $this->db->Execute($query);
			
				if (empty($result)) {
					$error_info = "function=insertTags class=Tag.class.php -- " . $query . " -- " . $this->db->ErrorMsg();
					$GLOBALS['igloo_error_log'][] = array(1, 1, $error_info);
				}
			}
		}
	}//EO insertTags
	
	
	// deleteTags --------------------------------------------------------------------
	// deletes tags
	// tom calthrop - 23rd July 2005
	//
	function deleteTags($data) {
		
		if (isset($data['item_id']) || isset($data['item_name'])) {
			$query = "
				DELETE FROM " . $this->db->prefix . "_tag 
				WHERE
				rsp_item_type_id=" . $this->rsp_item_type_id . " AND "
			;
			
			if (isset($data['item_id'])) {
				$query .= "item_id=" . $data['item_id'] . " AND ";
			}
			
			if (isset($data['item_name'])) {
				$query .= "item_name=" . $this->db->qstr("%" . $data['item_name'] . "%", get_magic_quotes_gpc()) . " AND ";
			}
			
			$query .= "user_id=" . $this->user_id;
			$result = $this->db->Execute($query);
			
			if (empty($result)) {
				$error_info = "function=deleteTags class=Tag.class.php -- " . $query . " -- " . $this->db->ErrorMsg();
				$GLOBALS['igloo_error_log'][] = array(1, 1, $error_info);
			}
		}
	} //EO deleteTags
}
?>
