<?php

// -----------------------------------------------------------------------
// This file is part of Igloo
//
// Copyright (C) 2003 - 2006 Barnraiser
// http://www.barnraiser.org/
// info@barnraiser.org
//
// This program is free software; you can redistribute it and/or modify it
// under the terms of the GNU General Public License as published by the
// Free Software Foundation; either version 2, or (at your option) any
// later version.
//
// This program is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
// General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with program; see the file COPYING. If not, write to the Free
// Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
// 02110-1301, USA.
// -----------------------------------------------------------------------

include "inc/header_sn.inc.php";

$menu_section = "network";

//ACS check
if (!$user_acs->checkPermission($c_acs['arr_acs']['resource']['node']['skills'], $c_acs['arr_acs']['privilege']['allow_access'])) { //resource_id, Priv_id
	header("Location: " . $_SESSION['user_homepage'] . "?" . strip_tags(SID));
	exit;
}

// SETUP LANGUAGE --------------------------------------------------------
require_once($languagePath . 'common.lang.php');
require_once($languageArrayPath . 'arr_skill.lang.php');


//setup file
$file->noimage = $c_node['file']['image']['thumb'][3]['noimage'];
$file->thumb = $c_node['file']['image']['thumb'][3]['name'];
$user->file = $file;


// SETUP SKILLS ---------------------------------------------------------
require_once('class/Skill.class.php');
$skill = new Skill($db);

if (isset($_REQUEST['search_text'])) {
	trim($_REQUEST['search_text']);
}

if (!empty($_REQUEST['search_text'])) {
	// GET USERS ------------------------------------------------------
	if (!isset($frmdata['degree']) || $frmdata['degree'] != "1") { // directory view
		$output_users = $user->selUsers(null, $c_node['user']['preference']['show_in_directory']);
		
		if (!empty($output_users)) {
			foreach($output_users as $key => $i):
				$skill->user_ids[] = $i['user_id'];
			endforeach;
		}
		else {
			$skill->user_ids[] = 0;
		}
		
		$frmdata['degree'] = "all";
	}
	else { // network only
		if (!empty($me['relations'])) {
			foreach($me['relations'] as $key => $i):
				$user->user_ids[] = $i['user_id_relation'];
				$skill->user_ids[] = $i['user_id_relation'];
			endforeach;
		}
		else {
			$user->user_ids[] = 0;
			$skill->user_ids[] = 0;
		}
		
		$skill->degree_id = 1;
		$output_users = $user->selUsers();
	}
	
	// GET SKILLS -----------------------------------------------------
	$output_skills = $skill->selSkills($_REQUEST['search_text']);
	
	// PLACE SKILLS AGAINST USERS ------------------------------------
	$output_skilled_users = array();
	
	if (!empty($output_users) && !empty($output_skills)) {
		foreach ($output_users as $userkey => $u):
			foreach ($output_skills as $skillkey => $s):
				if ($u['user_id'] == $s['user_id']) {
					$output_users[$userkey]['skills'][] = $s;
				}
			endforeach;
		endforeach;
		
		foreach ($output_users as $userkey => $u):
			if (!empty($u['skills'])) {
				$output_skilled_users[] = $u;
			}
		endforeach;
	}
	
	unset($output_skills);
}
elseif (isset($_REQUEST['view']) && $_REQUEST['view'] == "directory") {
	$output_users = $user->selUsers(null, $c_node['user']['preference']['show_in_directory']);
	
	if (!empty($output_users)) {
		foreach($output_users as $key => $i):
			$skill->user_ids[] = $i['user_id'];
		endforeach;
	}
	else {
		$skill->user_ids[] = 0;
	}
	
	$skill->order_by = "s.skill_name";
	$output_skills = $skill->selSkills();
}
else { // display network cloud
	if (!empty($me['relations'])) {
		foreach($me['relations'] as $key => $i):
			$skill->user_ids[] = $i['user_id_relation'];
		endforeach;
	}
	else {
		$skill->user_ids[] = 0;
	}
	
	$skill->degree_id = 1;
	$skill->order_by = "s.skill_name";
	$output_skills = $skill->selSkills();
	
	$_REQUEST['view'] = "network";
}



//MOVE TO TEMPLATE
if (!empty($output_skilled_users)) {
	$body->set('users', $output_skilled_users);
}

if (!empty($output_skills)) {
	$body->set('skills', $output_skills);
}

if (!empty($frmdata)) {
    $body->set('frmdata', $frmdata);
}

if (!empty($_REQUEST['view'])) {
    $body->set('view', $_REQUEST['view']);
}
include "inc/footer.inc.php";

?>
