<?xml version="1.0" encoding="ISO-8859-15"?>
<!-- 
 *   Copyright (C) 2002, 2003, 2004 Jatec AG, Switzerland
 *
 * This file is part of IronMailer.
 *
 * IronMailer is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.

 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
-->

<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0">

<xsl:template match="page">
   <xsl:variable name="projecthome_link"
	  select="'http://ironmailer.org'"/>
   <xsl:variable name="companyhome_link"
	  select="'http://www.jatec.net'"/>

<html>
   <head>
	<title><xsl:value-of select="normalize-space(titletext)"/></title>
	<meta content="AUTHOR" value="wk"/>
	<link type="text/css" href="ironmailercss" rel="stylesheet" />
   </head>
   <body class="login_bg" onload="document.loginform.username.focus();">

     <form name="loginform" method="post" action="welcome">
      <input value="login" name="act" type="hidden"/>

      <!-- outer formatting table -->
      <table align="center" width="430">
         <tr>
            <td>
	        <!-- inner table, containing main stuff (login data) -->
		<table align="center" cellpadding="5" cellspacing="0" border="0">
		   <tr class="field_light_bg">
		      <!-- logo -->
		      <td align="center" rowspan="4">
		         <img alt="logo" hspace="5" src="images/application_logo_small.png"/>
		      </td>
		      <td align="center" colspan="3">
		         <img src="images/ironmailer_simplelogo.png" alt="simplelogo"/>
		      </td>
		   </tr>
	           <!-- username entry field -->
		   <tr class="field_light_bg">
		      <td class="smalltext" align="right">
		         <xsl:value-of select="username"/>&#160;&#160;
		      </td>
		      <td class="smalltext" colspan="2">
			 <input class="smalltext" size="15" name="username" type="text"/>
		      </td>
		   </tr>
		   <!-- password entry field -->   
		   <tr class="field_light_bg">
		      <td class="smalltext" align="right">
			 <xsl:value-of select="password"/>&#160;&#160;
		      </td>
		      <td class="smalltext" colspan="2">
			 <input class="smalltext" size="15" name="password" type="password"/>
		      </td>
		   </tr>
		   <!-- row with action buttons -->
		   <tr class="field_light_bg">
  		      <td class="smalltext"></td>
		      <td class="smalltext">
			 <input class="smalltext" name="Login" type="submit">
			    <xsl:attribute name="value"><xsl:value-of select="normalize-space(actiontext1)"/></xsl:attribute>
			 </input>
		      </td>
		      <td>
			 <input class="smalltext" name="Reset" type="reset">
			    <xsl:attribute name="value"><xsl:value-of select="normalize-space(actiontext2)"/></xsl:attribute>
			 </input>
		      </td>
		   </tr>
		   <!-- row with information -->
		   <tr class="field_middle_bg">
		      <td class="smalltext" align="right" valign="middle" colspan="2">
                         <a class="bold">
                            <xsl:attribute name="href">
                               <xsl:value-of select="$projecthome_link"/>
                            </xsl:attribute>
			    <xsl:value-of select="normalize-space(footertext1)"/>
                         </a>
			 &#160;<xsl:value-of select="normalize-space(footertext2)"/>
                      </td>
		      <td class="smalltext" align="left" valign="middle" colspan="2">
			 <a>
			    <xsl:attribute name="href">
				<xsl:value-of select="$companyhome_link"/>
			    </xsl:attribute>
			    <img alt="logo" src="images/company_logo.png" border="0" />
			 </a>
		      </td>
		    </tr>

		</table>
	      </td>
	   </tr>		
	   <xsl:if test="error">
	      <tr>
	         <td>
		        <p class="smalltext" align="center">
			    <img align="middle" border="0" hspace="5" src="images/gnome/dialog-warning.png" />

		            <span class="bold">
		            	<xsl:value-of select="error/header"/>
			   </span>.
			</p>
 			<xsl:comment>Error content: <xsl:value-of select="error/content"/></xsl:comment>
 			<xsl:comment>Error stack: <xsl:value-of select="error/stack"/></xsl:comment>
		 </td>
	      </tr>
	   </xsl:if>
	        
	</table>		
	</form>
      </body>
    </html>
  </xsl:template>

</xsl:stylesheet>
