/*
 * Decompiled with CFR 0.152.
 */
package net.jatec.ironmailer.controller;

import java.security.Security;
import java.util.Properties;
import javax.mail.AuthenticationFailedException;
import javax.mail.MessagingException;
import javax.mail.Session;
import javax.mail.Store;
import javax.security.auth.login.FailedLoginException;
import javax.security.auth.login.LoginException;
import net.jatec.ironmailer.controller.ServerConnection;
import org.apache.log4j.Logger;

public class MailServerConnection
implements ServerConnection {
    private final Logger log = Logger.getLogger((Class)(class$net$jatec$ironmailer$controller$MailServerConnection == null ? (class$net$jatec$ironmailer$controller$MailServerConnection = MailServerConnection.class$((String)"net.jatec.ironmailer.controller.MailServerConnection")) : class$net$jatec$ironmailer$controller$MailServerConnection));
    private final String SSL_FACTORY = "javax.net.ssl.SSLSocketFactory";
    private final String DUMMY_SSL_FACTORY = "net.jatec.ironmailer.framework.security.endorsed.DummySSLSocketFactory";
    private Session session;
    private Store store;
    private String user;
    private String host;
    static /* synthetic */ Class class$net$jatec$ironmailer$controller$MailServerConnection;

    public void connect(String string, String string2, boolean bl, boolean bl2, String string3, char[] cArray) throws IllegalArgumentException, FailedLoginException, LoginException {
        this.log.info((Object)("connect() called for host " + string + " and user " + string3));
        if (string == null || string.equals("")) {
            throw new IllegalArgumentException("parameter host must contain a value");
        }
        if (string2 == null || string2.equals("")) {
            throw new IllegalArgumentException("parameter host must contain a value");
        }
        if (string3 == null || string3.equals("")) {
            throw new IllegalArgumentException("parameter user must contain a value");
        }
        if (cArray == null || cArray.length == 0) {
            throw new IllegalArgumentException("parameter password must contain a value");
        }
        try {
            Properties properties = new Properties();
            properties.put("mail.imap.host", string);
            this.session = Session.getInstance((Properties)properties);
            this.store = this.session.getStore(string2);
            if (bl) {
                if (this.log.isDebugEnabled()) {
                    this.log.debug((Object)"setting SSL properties");
                }
                if (bl2) {
                    Security.setProperty("ssl.SocketFactory.provider", "net.jatec.ironmailer.framework.security.endorsed.DummySSLSocketFactory");
                    properties.setProperty("mail.imap.socketFactory.class", "net.jatec.ironmailer.framework.security.endorsed.DummySSLSocketFactory");
                    properties.setProperty("mail.imap.socketFactory.fallback", "false");
                }
                properties.setProperty("mail.imap.port", "993");
                properties.setProperty("mail.imap.socketFactory.port", "993");
            }
            this.store.connect(string, string3, String.valueOf(cArray));
        }
        catch (AuthenticationFailedException authenticationFailedException) {
            this.log.info((Object)("connect() failed: " + authenticationFailedException.toString()));
            throw new FailedLoginException(authenticationFailedException.toString());
        }
        catch (Throwable throwable) {
            this.log.error((Object)("connect() failed with unexpected error " + throwable.toString()), throwable);
            throw new LoginException("unexpected connection exception " + throwable.toString());
        }
        this.user = string3;
        this.host = string;
    }

    public void disconnect() {
        this.log.info((Object)"disconnect() called");
        try {
            this.store.close();
        }
        catch (MessagingException messagingException) {
            this.log.info((Object)("disconnect() ignoring exception: " + messagingException.toString()));
        }
        this.store = null;
        this.session = null;
    }

    public Session getSession() {
        return this.session;
    }

    public Store getStore() {
        return this.store;
    }

    public String getUser() {
        return this.user;
    }

    public String getHost() {
        return this.host;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

