/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.dbcp.datasources;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import javax.naming.Context;
import javax.naming.Name;
import javax.naming.RefAddr;
import javax.naming.Reference;
import javax.naming.spi.ObjectFactory;
import org.apache.commons.dbcp.datasources.InstanceKeyDataSource;

abstract class InstanceKeyObjectFactory
implements ObjectFactory {
    private static Map instanceMap = new HashMap();

    InstanceKeyObjectFactory() {
    }

    static synchronized String registerNewInstance(InstanceKeyDataSource ds) {
        int max = 0;
        Iterator i = instanceMap.keySet().iterator();
        while (i.hasNext()) {
            Object obj = i.next();
            if (!(obj instanceof String)) continue;
            max = Math.max(max, Integer.parseInt((String)obj));
        }
        String instanceKey = String.valueOf(max + 1);
        instanceMap.put(instanceKey, ds);
        return instanceKey;
    }

    static void removeInstance(String key) {
        instanceMap.remove(key);
    }

    public static void closeAll() throws Exception {
        Iterator instanceIterator = instanceMap.entrySet().iterator();
        while (instanceIterator.hasNext()) {
            ((InstanceKeyDataSource)instanceIterator.next().getValue()).close();
        }
        instanceMap.clear();
    }

    public Object getObjectInstance(Object refObj, Name name, Context context, Hashtable env) throws IOException, ClassNotFoundException {
        Reference ref;
        InstanceKeyDataSource obj = null;
        if (refObj instanceof Reference && this.isCorrectClass((ref = (Reference)refObj).getClassName())) {
            RefAddr ra = ref.get("instanceKey");
            if (ra != null && ra.getContent() != null) {
                obj = (InstanceKeyDataSource)instanceMap.get(ra.getContent());
            } else {
                String key = null;
                if (name != null) {
                    key = name.toString();
                    obj = (InstanceKeyDataSource)instanceMap.get(key);
                }
                if (obj == null) {
                    InstanceKeyDataSource ds = this.getNewInstance(ref);
                    this.setCommonProperties(ref, ds);
                    obj = ds;
                    if (key != null) {
                        instanceMap.put(key, ds);
                    }
                }
            }
        }
        return obj;
    }

    private void setCommonProperties(Reference ref, InstanceKeyDataSource ikds) throws IOException, ClassNotFoundException {
        RefAddr ra = ref.get("dataSourceName");
        if (ra != null && ra.getContent() != null) {
            ikds.setDataSourceName(ra.getContent().toString());
        }
        if ((ra = ref.get("defaultAutoCommit")) != null && ra.getContent() != null) {
            ikds.setDefaultAutoCommit(Boolean.valueOf(ra.getContent().toString()));
        }
        if ((ra = ref.get("defaultReadOnly")) != null && ra.getContent() != null) {
            ikds.setDefaultReadOnly(Boolean.valueOf(ra.getContent().toString()));
        }
        if ((ra = ref.get("description")) != null && ra.getContent() != null) {
            ikds.setDescription(ra.getContent().toString());
        }
        if ((ra = ref.get("jndiEnvironment")) != null && ra.getContent() != null) {
            byte[] serialized = (byte[])ra.getContent();
            ikds.jndiEnvironment = (Properties)InstanceKeyObjectFactory.deserialize(serialized);
        }
        if ((ra = ref.get("loginTimeout")) != null && ra.getContent() != null) {
            ikds.setLoginTimeout(Integer.parseInt(ra.getContent().toString()));
        }
        if ((ra = ref.get("testOnBorrow")) != null && ra.getContent() != null) {
            ikds.setTestOnBorrow(Boolean.getBoolean(ra.getContent().toString()));
        }
        if ((ra = ref.get("testOnReturn")) != null && ra.getContent() != null) {
            ikds.setTestOnReturn(Boolean.valueOf(ra.getContent().toString()));
        }
        if ((ra = ref.get("timeBetweenEvictionRunsMillis")) != null && ra.getContent() != null) {
            ikds.setTimeBetweenEvictionRunsMillis(Integer.parseInt(ra.getContent().toString()));
        }
        if ((ra = ref.get("numTestsPerEvictionRun")) != null && ra.getContent() != null) {
            ikds.setNumTestsPerEvictionRun(Integer.parseInt(ra.getContent().toString()));
        }
        if ((ra = ref.get("minEvictableIdleTimeMillis")) != null && ra.getContent() != null) {
            ikds.setMinEvictableIdleTimeMillis(Integer.parseInt(ra.getContent().toString()));
        }
        if ((ra = ref.get("testWhileIdle")) != null && ra.getContent() != null) {
            ikds.setTestWhileIdle(Boolean.valueOf(ra.getContent().toString()));
        }
        if ((ra = ref.get("validationQuery")) != null && ra.getContent() != null) {
            ikds.setValidationQuery(ra.getContent().toString());
        }
    }

    protected abstract boolean isCorrectClass(String var1);

    protected abstract InstanceKeyDataSource getNewInstance(Reference var1) throws IOException, ClassNotFoundException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static final Object deserialize(byte[] data) throws IOException, ClassNotFoundException {
        Object object;
        ObjectInputStream in = null;
        try {
            in = new ObjectInputStream(new ByteArrayInputStream(data));
            object = in.readObject();
            Object var4_3 = null;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            try {
                in.close();
            }
            catch (IOException ex) {}
            throw throwable;
        }
        try {
            in.close();
        }
        catch (IOException ex) {
            // empty catch block
        }
        return object;
    }
}

