/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.bridge;

import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import org.apache.batik.bridge.AbstractSVGBridge;
import org.apache.batik.bridge.BridgeContext;
import org.apache.batik.bridge.BridgeException;
import org.apache.batik.bridge.CSSUtilities;
import org.apache.batik.bridge.ErrorConstants;
import org.apache.batik.bridge.GVTBuilder;
import org.apache.batik.bridge.MarkerBridge;
import org.apache.batik.bridge.SVGUtilities;
import org.apache.batik.bridge.UnitProcessor;
import org.apache.batik.bridge.ViewBox;
import org.apache.batik.css.engine.value.Value;
import org.apache.batik.ext.awt.image.renderable.ClipRable8Bit;
import org.apache.batik.ext.awt.image.renderable.Filter;
import org.apache.batik.gvt.AbstractGraphicsNode;
import org.apache.batik.gvt.CompositeGraphicsNode;
import org.apache.batik.gvt.GraphicsNode;
import org.apache.batik.gvt.Marker;
import org.apache.batik.parser.UnitProcessor;
import org.w3c.dom.Element;

public class SVGMarkerElementBridge
extends AbstractSVGBridge
implements MarkerBridge,
ErrorConstants {
    protected SVGMarkerElementBridge() {
    }

    public String getLocalName() {
        return "marker";
    }

    public Marker createMarker(BridgeContext bridgeContext, Element element, Element element2) {
        Object object;
        Object object2;
        AffineTransform affineTransform;
        double d;
        Object object3;
        Object object4;
        GVTBuilder gVTBuilder = bridgeContext.getGVTBuilder();
        Object object5 = new CompositeGraphicsNode();
        boolean bl = false;
        for (object4 = element.getFirstChild(); object4 != null; object4 = object4.getNextSibling()) {
            GraphicsNode graphicsNode;
            if (object4.getNodeType() != 1 || (graphicsNode = gVTBuilder.build(bridgeContext, (Element)(object3 = (Element)object4))) == null) continue;
            bl = true;
            ((CompositeGraphicsNode)object5).getChildren().add(graphicsNode);
        }
        if (!bl) {
            return null;
        }
        object3 = UnitProcessor.createContext(bridgeContext, element2);
        float f = 3.0f;
        object4 = element.getAttributeNS(null, "markerWidth");
        if (((String)object4).length() != 0) {
            f = UnitProcessor.svgHorizontalLengthToUserSpace((String)object4, "markerWidth", (UnitProcessor.Context)object3);
        }
        if (f == 0.0f) {
            return null;
        }
        float f2 = 3.0f;
        object4 = element.getAttributeNS(null, "markerHeight");
        if (((String)object4).length() != 0) {
            f2 = UnitProcessor.svgVerticalLengthToUserSpace((String)object4, "markerHeight", (UnitProcessor.Context)object3);
        }
        if (f2 == 0.0f) {
            return null;
        }
        object4 = element.getAttributeNS(null, "orient");
        if (((String)object4).length() == 0) {
            d = 0.0;
        } else if ("auto".equals(object4)) {
            d = Double.NaN;
        } else {
            try {
                d = SVGUtilities.convertSVGNumber((String)object4);
            }
            catch (NumberFormatException numberFormatException) {
                throw new BridgeException(element, "attribute.malformed", new Object[]{"orient", object4});
            }
        }
        Value value = CSSUtilities.getComputedStyle(element2, 51);
        float f3 = value.getFloatValue();
        object4 = element.getAttributeNS(null, "markerUnits");
        int n = ((String)object4).length() == 0 ? 3 : (int)SVGUtilities.parseMarkerCoordinateSystem(element, "markerUnits", (String)object4);
        if (n == 3) {
            affineTransform = new AffineTransform();
            affineTransform.scale(f3, f3);
        } else {
            affineTransform = new AffineTransform();
        }
        AffineTransform affineTransform2 = ViewBox.getPreserveAspectRatioTransform(element, f, f2);
        if (affineTransform2 == null) {
            return null;
        }
        affineTransform.concatenate(affineTransform2);
        ((AbstractGraphicsNode)object5).setTransform(affineTransform);
        if (CSSUtilities.convertOverflow(element)) {
            float[] fArray = CSSUtilities.convertClip(element);
            Rectangle2D.Float float_ = fArray == null ? new Rectangle2D.Float(0.0f, 0.0f, f3 * f, f3 * f2) : new Rectangle2D.Float(fArray[3], fArray[0], f3 * f - fArray[1] - fArray[3], f3 * f2 - fArray[2] - fArray[0]);
            object2 = new CompositeGraphicsNode();
            ((CompositeGraphicsNode)object2).getChildren().add(object5);
            object = ((AbstractGraphicsNode)object2).getGraphicsNodeRable(true);
            ((AbstractGraphicsNode)object2).setClip(new ClipRable8Bit((Filter)object, float_));
            object5 = object2;
        }
        float f4 = 0.0f;
        object4 = element.getAttributeNS(null, "refX");
        if (((String)object4).length() != 0) {
            f4 = UnitProcessor.svgHorizontalCoordinateToUserSpace((String)object4, "refX", (UnitProcessor.Context)object3);
        }
        float f5 = 0.0f;
        object4 = element.getAttributeNS(null, "refY");
        if (((String)object4).length() != 0) {
            f5 = UnitProcessor.svgVerticalCoordinateToUserSpace((String)object4, "refY", (UnitProcessor.Context)object3);
        }
        object2 = new float[]{f4, f5};
        affineTransform.transform((float[])object2, 0, (float[])object2, 0, 1);
        object = new Marker((GraphicsNode)object5, new Point2D.Float((float)object2[0], (float)object2[1]), d);
        return object;
    }
}

