/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.components.language.programming.java;

import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.StringTokenizer;
import org.apache.avalon.excalibur.pool.Recyclable;
import org.apache.cocoon.components.language.programming.CompilerError;
import org.apache.cocoon.components.language.programming.LanguageCompiler;
import org.apache.cocoon.util.ClassUtils;
import org.eclipse.jdt.core.compiler.IProblem;
import org.eclipse.jdt.internal.compiler.ClassFile;
import org.eclipse.jdt.internal.compiler.CompilationResult;
import org.eclipse.jdt.internal.compiler.Compiler;
import org.eclipse.jdt.internal.compiler.DefaultErrorHandlingPolicies;
import org.eclipse.jdt.internal.compiler.ICompilerRequestor;
import org.eclipse.jdt.internal.compiler.IErrorHandlingPolicy;
import org.eclipse.jdt.internal.compiler.IProblemFactory;
import org.eclipse.jdt.internal.compiler.classfmt.ClassFileReader;
import org.eclipse.jdt.internal.compiler.classfmt.ClassFormatException;
import org.eclipse.jdt.internal.compiler.env.IBinaryType;
import org.eclipse.jdt.internal.compiler.env.ICompilationUnit;
import org.eclipse.jdt.internal.compiler.env.INameEnvironment;
import org.eclipse.jdt.internal.compiler.env.NameEnvironmentAnswer;
import org.eclipse.jdt.internal.compiler.problem.DefaultProblemFactory;

public class EclipseJavaCompiler
implements LanguageCompiler,
Recyclable {
    static boolean target14;
    static boolean source14;
    boolean debug = true;
    String sourceDir;
    String sourceFile;
    String destDir;
    String sourceEncoding;
    List errors = new LinkedList();

    public EclipseJavaCompiler() {
        source14 = true;
    }

    public void recycle() {
        this.sourceFile = null;
        this.sourceDir = null;
        this.destDir = null;
        this.sourceEncoding = null;
        this.errors.clear();
    }

    public void setFile(String file) {
        this.sourceFile = file;
    }

    public void setSource(String srcDir) {
        this.sourceDir = srcDir;
    }

    public void setDestination(String destDir) {
        this.destDir = destDir;
    }

    public void setEncoding(String encoding) {
        this.sourceEncoding = encoding;
    }

    public void setClasspath(String cp) {
    }

    private String makeClassName(String fileName) throws IOException {
        File origFile = new File(fileName);
        String canonical = null;
        if (origFile.exists()) {
            canonical = origFile.getCanonicalPath().replace('\\', '/');
        }
        String str = fileName;
        str = str.replace('\\', '/');
        if (this.sourceDir != null) {
            String prefix = new File(this.sourceDir).getCanonicalPath().replace('\\', '/');
            if (canonical != null) {
                if (canonical.startsWith(prefix)) {
                    String result = canonical.substring(prefix.length() + 1, canonical.length() - 5);
                    result = result.replace('/', '.');
                    return result;
                }
            } else {
                File t = new File(this.sourceDir, fileName);
                if (t.exists()) {
                    str = t.getCanonicalPath().replace('\\', '/');
                    String result = str.substring(prefix.length() + 1, str.length() - 5).replace('/', '.');
                    return result;
                }
            }
        }
        if (fileName.endsWith(".java")) {
            fileName = fileName.substring(0, fileName.length() - 5);
        }
        fileName = fileName.replace('\\', '.');
        return fileName.replace('/', '.');
    }

    public boolean compile() throws IOException {
        final String targetClassName = this.makeClassName(this.sourceFile);
        final ClassLoader classLoader = ClassUtils.getClassLoader();
        String[] fileNames = new String[]{this.sourceFile};
        String[] classNames = new String[]{targetClassName};
        INameEnvironment env = new INameEnvironment(){

            public NameEnvironmentAnswer findType(char[][] compoundTypeName) {
                String result = "";
                String sep = "";
                for (int i = 0; i < compoundTypeName.length; ++i) {
                    result = result + sep;
                    result = result + new String(compoundTypeName[i]);
                    sep = ".";
                }
                return this.findType(result);
            }

            public NameEnvironmentAnswer findType(char[] typeName, char[][] packageName) {
                String result = "";
                String sep = "";
                for (int i = 0; i < packageName.length; ++i) {
                    result = result + sep;
                    result = result + new String(packageName[i]);
                    sep = ".";
                }
                result = result + sep;
                result = result + new String(typeName);
                return this.findType(result);
            }

            private NameEnvironmentAnswer findType(String className) {
                try {
                    if (className.equals(targetClassName)) {
                        class CompilationUnit
                        implements ICompilationUnit {
                            String className;
                            String sourceFile;

                            CompilationUnit(String sourceFile, String className) {
                                this.className = className;
                                this.sourceFile = sourceFile;
                            }

                            public char[] getFileName() {
                                return this.className.toCharArray();
                            }

                            public char[] getContents() {
                                char[] result = null;
                                try {
                                    BufferedReader reader = new BufferedReader(new FileReader(this.sourceFile));
                                    if (reader != null) {
                                        int count;
                                        char[] chars = new char[8192];
                                        StringBuffer buf = new StringBuffer();
                                        while ((count = ((Reader)reader).read(chars, 0, chars.length)) > 0) {
                                            buf.append(chars, 0, count);
                                        }
                                        result = new char[buf.length()];
                                        buf.getChars(0, result.length, result, 0);
                                    }
                                }
                                catch (IOException e) {
                                    EclipseJavaCompiler.this.handleError(this.className, -1, -1, e.getMessage());
                                }
                                return result;
                            }

                            public char[] getMainTypeName() {
                                int dot = this.className.lastIndexOf(46);
                                if (dot > 0) {
                                    return this.className.substring(dot + 1).toCharArray();
                                }
                                return this.className.toCharArray();
                            }

                            public char[][] getPackageName() {
                                StringTokenizer izer = new StringTokenizer(this.className, ".");
                                char[][] result = new char[izer.countTokens() - 1][];
                                for (int i = 0; i < result.length; ++i) {
                                    String tok = izer.nextToken();
                                    result[i] = tok.toCharArray();
                                }
                                return result;
                            }
                        }
                        CompilationUnit compilationUnit = new CompilationUnit(EclipseJavaCompiler.this.sourceFile, className);
                        return new NameEnvironmentAnswer((ICompilationUnit)compilationUnit);
                    }
                    String resourceName = className.replace('.', '/') + ".class";
                    InputStream is = classLoader.getResourceAsStream(resourceName);
                    if (is != null) {
                        int count;
                        byte[] buf = new byte[8192];
                        ByteArrayOutputStream baos = new ByteArrayOutputStream(buf.length);
                        while ((count = is.read(buf, 0, buf.length)) > 0) {
                            baos.write(buf, 0, count);
                        }
                        baos.flush();
                        byte[] classBytes = baos.toByteArray();
                        char[] fileName = className.toCharArray();
                        ClassFileReader classFileReader = new ClassFileReader(classBytes, fileName, true);
                        return new NameEnvironmentAnswer((IBinaryType)classFileReader);
                    }
                }
                catch (IOException exc) {
                    EclipseJavaCompiler.this.handleError(className, -1, -1, exc.getMessage());
                }
                catch (ClassFormatException exc) {
                    EclipseJavaCompiler.this.handleError(className, -1, -1, exc.getMessage());
                }
                return null;
            }

            private boolean isPackage(String result) {
                if (result.equals(targetClassName)) {
                    return false;
                }
                String resourceName = result.replace('.', '/') + ".class";
                InputStream is = classLoader.getResourceAsStream(resourceName);
                return is == null;
            }

            public boolean isPackage(char[][] parentPackageName, char[] packageName) {
                String str;
                String result = "";
                String sep = "";
                if (parentPackageName != null) {
                    for (int i = 0; i < parentPackageName.length; ++i) {
                        result = result + sep;
                        String str2 = new String(parentPackageName[i]);
                        result = result + str2;
                        sep = ".";
                    }
                }
                if (Character.isUpperCase((str = new String(packageName)).charAt(0)) && !this.isPackage(result)) {
                    return false;
                }
                result = result + sep;
                result = result + str;
                return this.isPackage(result);
            }

            public void cleanup() {
            }
        };
        IErrorHandlingPolicy policy = DefaultErrorHandlingPolicies.proceedWithAllProblems();
        HashMap<String, String> settings = new HashMap<String, String>();
        settings.put("org.eclipse.jdt.core.compiler.debug.lineNumber", "generate");
        settings.put("org.eclipse.jdt.core.compiler.debug.sourceFile", "generate");
        settings.put("org.eclipse.jdt.core.compiler.problem.deprecation", "ignore");
        if (this.sourceEncoding != null) {
            settings.put("org.eclipse.jdt.core.encoding", this.sourceEncoding);
        }
        if (this.debug) {
            settings.put("org.eclipse.jdt.core.compiler.debug.localVariable", "generate");
        }
        if (source14) {
            settings.put("org.eclipse.jdt.core.compiler.source", "1.4");
        }
        if (target14) {
            settings.put("org.eclipse.jdt.core.compiler.codegen.targetPlatform", "1.4");
        }
        DefaultProblemFactory problemFactory = new DefaultProblemFactory(Locale.getDefault());
        ICompilerRequestor requestor = new ICompilerRequestor(){

            public void acceptResult(CompilationResult result) {
                try {
                    if (result.hasProblems()) {
                        IProblem[] problems = result.getProblems();
                        for (int i = 0; i < problems.length; ++i) {
                            IProblem problem = problems[i];
                            String name = new String(problems[i].getOriginatingFileName());
                            EclipseJavaCompiler.this.handleError(name, problem.getSourceLineNumber(), -1, problem.getMessage());
                        }
                    } else {
                        ClassFile[] classFiles = result.getClassFiles();
                        for (int i = 0; i < classFiles.length; ++i) {
                            ClassFile classFile = classFiles[i];
                            char[][] compoundName = classFile.getCompoundName();
                            String className = "";
                            String sep = "";
                            for (int j = 0; j < compoundName.length; ++j) {
                                className = className + sep;
                                className = className + new String(compoundName[j]);
                                sep = ".";
                            }
                            byte[] bytes = classFile.getBytes();
                            String outFile = EclipseJavaCompiler.this.destDir + "/" + className.replace('.', '/') + ".class";
                            FileOutputStream fout = new FileOutputStream(outFile);
                            BufferedOutputStream bos = new BufferedOutputStream(fout);
                            bos.write(bytes);
                            bos.close();
                        }
                    }
                }
                catch (IOException exc) {
                    exc.printStackTrace();
                }
            }
        };
        ICompilationUnit[] compilationUnits = new ICompilationUnit[classNames.length];
        for (int i = 0; i < compilationUnits.length; ++i) {
            String className = classNames[i];
            compilationUnits[i] = new CompilationUnit(fileNames[i], className);
        }
        Compiler compiler = new Compiler(env, policy, settings, requestor, (IProblemFactory)problemFactory);
        compiler.compile(compilationUnits);
        return this.errors.size() == 0;
    }

    void handleError(String className, int line, int column, Object errorMessage) {
        String fileName = className.replace('.', File.separatorChar) + ".java";
        if (column < 0) {
            column = 0;
        }
        this.errors.add(new CompilerError(fileName, true, line, column, line, column, errorMessage.toString()));
    }

    public List getErrors() throws IOException {
        return this.errors;
    }

    static {
        String version = System.getProperty("java.specification.version");
        try {
            target14 = (double)Float.parseFloat(version) >= 1.4;
            source14 = target14;
        }
        catch (NumberFormatException e) {
            target14 = false;
            source14 = false;
        }
    }
}

