/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.components.treeprocessor.sitemap;

import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.apache.avalon.framework.thread.ThreadSafe;
import org.apache.cocoon.components.treeprocessor.AbstractParentProcessingNodeBuilder;
import org.apache.cocoon.components.treeprocessor.ProcessingNode;
import org.apache.cocoon.components.treeprocessor.sitemap.ActionSetNode;

public class ActionSetNodeBuilder
extends AbstractParentProcessingNodeBuilder
implements ThreadSafe {
    public static final String IN_ACTION_SET = ActionSetNodeBuilder.class.getName() + "/inActionSet";

    public ProcessingNode buildNode(Configuration config) throws Exception {
        String actionSetName = config.getAttribute("name");
        Configuration[] childrenConfig = config.getChildren();
        this.treeBuilder.setAttribute(IN_ACTION_SET, Boolean.TRUE);
        ProcessingNode[] nodes = this.buildChildNodes(config);
        String[] actions = new String[nodes.length];
        for (int i = 0; i < childrenConfig.length; ++i) {
            Configuration childConfig = childrenConfig[i];
            String name = childConfig.getName();
            if (!"act".equals(name)) {
                String msg = "Unknown element " + name + " in action-set at " + childConfig.getLocation();
                throw new ConfigurationException(msg);
            }
            actions[i] = childConfig.getAttribute("action", null);
        }
        ActionSetNode node = new ActionSetNode(actionSetName, nodes, actions);
        this.treeBuilder.setupNode(node, config);
        this.treeBuilder.setAttribute(IN_ACTION_SET, null);
        return node;
    }
}

