/*
 * Decompiled with CFR 0.152.
 */
package javax.management.relation;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.management.Notification;
import javax.management.ObjectName;

public class RelationNotification
extends Notification {
    private static final long serialVersionUID = -6871117877523310399L;
    public static final String RELATION_BASIC_CREATION = "jmx.relation.creation.basic";
    public static final String RELATION_MBEAN_CREATION = "jmx.relation.creation.mbean";
    public static final String RELATION_BASIC_REMOVAL = "jmx.relation.removal.basic";
    public static final String RELATION_MBEAN_REMOVAL = "jmx.relation.removal.mbean";
    public static final String RELATION_BASIC_UPDATE = "jmx.relation.update.basic";
    public static final String RELATION_MBEAN_UPDATE = "jmx.relation.update.mbean";
    private String relationId;
    private String relationTypeName;
    private String roleName;
    private ObjectName relationObjName;
    private List unregisterMBeanList;
    private List oldRoleValue;
    private List newRoleValue;

    public RelationNotification(String createRemoveType, Object source, long sequenceNumber, long timestamp, String message, String relationId, String relationTypeName, ObjectName relationObjectName, List unregisteredMBeanList) {
        super(createRemoveType, source, sequenceNumber, timestamp, message);
        this.checkCreateRemoveType(createRemoveType);
        this.relationId = relationId;
        this.relationTypeName = relationTypeName;
        this.relationObjName = relationObjectName;
        this.setUnregisterMBeanList(unregisteredMBeanList);
    }

    public RelationNotification(String updateType, Object source, long sequenceNumber, long timestamp, String message, String relationId, String relationTypeName, ObjectName relationObjectName, String roleName, List newRoleValues, List oldRoleValues) {
        super(updateType, source, sequenceNumber, timestamp, message);
        this.checkUpdateType(updateType);
        this.relationId = relationId;
        this.relationTypeName = relationTypeName;
        this.relationObjName = relationObjectName;
        this.roleName = roleName;
        this.setOldRoleValues(oldRoleValues);
        this.setNewRoleValues(newRoleValues);
    }

    private void setOldRoleValues(List list) {
        if (list != null) {
            if (this.oldRoleValue == null) {
                this.oldRoleValue = new ArrayList();
            }
            this.oldRoleValue.clear();
            this.oldRoleValue.addAll(list);
        }
    }

    private void setNewRoleValues(List list) {
        if (list != null) {
            if (this.newRoleValue == null) {
                this.newRoleValue = new ArrayList();
            }
            this.newRoleValue.clear();
            this.newRoleValue.addAll(list);
        }
    }

    private void setUnregisterMBeanList(List list) {
        if (list != null) {
            if (this.unregisterMBeanList == null) {
                this.unregisterMBeanList = new ArrayList();
            }
            this.unregisterMBeanList.clear();
            this.unregisterMBeanList.addAll(list);
        }
    }

    public String getRelationId() {
        return this.relationId;
    }

    public String getRelationTypeName() {
        return this.relationTypeName;
    }

    public ObjectName getObjectName() {
        return this.relationObjName;
    }

    public List getMBeansToUnregister() {
        if (this.unregisterMBeanList != null) {
            return new ArrayList(this.unregisterMBeanList);
        }
        return Collections.EMPTY_LIST;
    }

    public List getNewRoleValue() {
        if (this.newRoleValue != null) {
            return new ArrayList(this.newRoleValue);
        }
        return Collections.EMPTY_LIST;
    }

    public List getOldRoleValue() {
        if (this.oldRoleValue != null) {
            return new ArrayList(this.oldRoleValue);
        }
        return Collections.EMPTY_LIST;
    }

    public String getRoleName() {
        return this.roleName;
    }

    private void checkCreateRemoveType(String type) throws IllegalArgumentException {
        if (!(type.equals(RELATION_BASIC_CREATION) || type.equals(RELATION_MBEAN_CREATION) || type.equals(RELATION_BASIC_REMOVAL) || type.equals(RELATION_MBEAN_REMOVAL))) {
            throw new IllegalArgumentException("Notification type is not recognized must be one of create or remove");
        }
    }

    private void checkUpdateType(String type) throws IllegalArgumentException {
        if (!type.equals(RELATION_BASIC_UPDATE) && !type.equals(RELATION_MBEAN_UPDATE)) {
            throw new IllegalArgumentException("Notification type is not recognized must be one of update");
        }
    }
}

