/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.core.dom;

import org.eclipse.jdt.core.dom.AST;
import org.eclipse.jdt.core.dom.ASTMatcher;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.ASTVisitor;
import org.eclipse.jdt.core.dom.EmptyStatement;
import org.eclipse.jdt.core.dom.SimpleName;
import org.eclipse.jdt.core.dom.Statement;

public class LabeledStatement
extends Statement {
    private SimpleName labelName = null;
    private Statement body = null;

    LabeledStatement(AST ast) {
        super(ast);
    }

    public int getNodeType() {
        return 30;
    }

    ASTNode clone(AST target) {
        LabeledStatement result = new LabeledStatement(target);
        result.setSourceRange(this.getStartPosition(), this.getLength());
        result.setLabel((SimpleName)ASTNode.copySubtree(target, this.getLabel()));
        result.setBody((Statement)ASTNode.copySubtree(target, this.getBody()));
        return result;
    }

    public boolean subtreeMatch(ASTMatcher matcher, Object other) {
        return matcher.match(this, other);
    }

    void accept0(ASTVisitor visitor) {
        boolean visitChildren = visitor.visit(this);
        if (visitChildren) {
            this.acceptChild(visitor, this.getLabel());
            this.acceptChild(visitor, this.getBody());
        }
        visitor.endVisit(this);
    }

    public SimpleName getLabel() {
        if (this.labelName == null) {
            long count = this.getAST().modificationCount();
            this.setLabel(new SimpleName(this.getAST()));
            this.getAST().setModificationCount(count);
        }
        return this.labelName;
    }

    public void setLabel(SimpleName label) {
        if (label == null) {
            throw new IllegalArgumentException();
        }
        this.replaceChild(this.labelName, label, false);
        this.labelName = label;
    }

    public Statement getBody() {
        if (this.body == null) {
            long count = this.getAST().modificationCount();
            this.setBody(new EmptyStatement(this.getAST()));
            this.getAST().setModificationCount(count);
        }
        return this.body;
    }

    public void setBody(Statement statement) {
        if (statement == null) {
            throw new IllegalArgumentException();
        }
        this.replaceChild(this.body, statement, true);
        this.body = statement;
    }

    int memSize() {
        return super.memSize() + 8;
    }

    int treeSize() {
        return this.memSize() + (this.labelName == null ? 0 : this.getLabel().treeSize()) + (this.body == null ? 0 : this.getBody().treeSize());
    }
}

