/*
 * Decompiled with CFR 0.152.
 */
package org.apache.excalibur.event.impl;

import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import org.apache.excalibur.event.PreparedEnqueue;
import org.apache.excalibur.event.Sink;
import org.apache.excalibur.event.SinkException;
import org.apache.excalibur.event.SinkFullException;

public class LossyMultiCastSink
implements Sink {
    private final Collection m_sinks;
    private final int m_size;
    private final boolean m_oneSuccess;

    public LossyMultiCastSink(Collection sinks) {
        this(sinks, false);
    }

    public LossyMultiCastSink(Collection sinks, boolean oneSuccess) {
        this.m_sinks = sinks;
        this.m_size = -1;
        this.m_oneSuccess = oneSuccess;
    }

    public int canAccept() {
        return 0;
    }

    public boolean isFull() {
        return false;
    }

    public int maxSize() {
        return 0;
    }

    public void enqueue(Object element) throws SinkException {
        Iterator sinks = this.m_sinks.iterator();
        int successful = 0;
        while (sinks.hasNext()) {
            Sink sink = (Sink)sinks.next();
            boolean enqueued = sink.tryEnqueue(element);
            if (!enqueued) continue;
            ++successful;
            break;
        }
        if (successful == 0 && this.m_oneSuccess) {
            throw new SinkFullException("Could not deliver one single element.");
        }
    }

    public void enqueue(Object[] elements) throws SinkException {
        Iterator sinks = this.m_sinks.iterator();
        int successful = 0;
        while (sinks.hasNext()) {
            Sink sink = (Sink)sinks.next();
            try {
                sink.enqueue(elements);
            }
            catch (SinkFullException e) {
                continue;
            }
            ++successful;
            break;
        }
        if (successful == 0 && this.m_oneSuccess) {
            throw new SinkFullException("Could not deliver one single elements.");
        }
    }

    public boolean tryEnqueue(Object element) {
        try {
            this.enqueue(element);
            return true;
        }
        catch (SinkException e) {
            return !this.m_oneSuccess;
        }
    }

    public PreparedEnqueue prepareEnqueue(Object[] elements) throws SinkException {
        Iterator sinks = this.m_sinks.iterator();
        DefaultPreparedEnqueue prepares = new DefaultPreparedEnqueue();
        int successful = 0;
        while (sinks.hasNext()) {
            Sink sink = (Sink)sinks.next();
            try {
                prepares.addPreparedEnqueue(sink.prepareEnqueue(elements));
            }
            catch (SinkFullException e) {
                continue;
            }
            ++successful;
            break;
        }
        if (successful == 0 && this.m_oneSuccess) {
            throw new SinkFullException("Could not deliver elements at all.");
        }
        return prepares;
    }

    public int size() {
        return this.m_size;
    }

    private static final class DefaultPreparedEnqueue
    implements PreparedEnqueue {
        private final Collection m_preparedEnqueues = new LinkedList();

        private DefaultPreparedEnqueue() {
        }

        public void abort() {
            Iterator iter = this.m_preparedEnqueues.iterator();
            while (iter.hasNext()) {
                ((PreparedEnqueue)iter.next()).abort();
            }
        }

        public void commit() {
            Iterator iter = this.m_preparedEnqueues.iterator();
            while (iter.hasNext()) {
                ((PreparedEnqueue)iter.next()).commit();
            }
        }

        public void addPreparedEnqueue(PreparedEnqueue preparedEnqueue) {
            this.m_preparedEnqueues.add(preparedEnqueue);
        }
    }
}

