/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.core;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.jdt.internal.core.JavaElementInfo;
import org.eclipse.jdt.internal.core.JavaProject;
import org.eclipse.jdt.internal.core.OpenableElementInfo;

public class JavaModelInfo
extends OpenableElementInfo {
    Object[] nonJavaResources;

    protected JavaModelInfo() {
    }

    private Object[] computeNonJavaResources() {
        IProject[] projects = ResourcesPlugin.getWorkspace().getRoot().getProjects();
        int length = projects.length;
        Object[] nonJavaResources = null;
        int index = 0;
        int i = 0;
        while (i < length) {
            IProject project = projects[i];
            if (!JavaProject.hasJavaNature(project)) {
                if (nonJavaResources == null) {
                    nonJavaResources = new Object[length];
                }
                nonJavaResources[index++] = project;
            }
            ++i;
        }
        if (index == 0) {
            return JavaElementInfo.NO_NON_JAVA_RESOURCES;
        }
        if (index < length) {
            Object[] objectArray = nonJavaResources;
            nonJavaResources = new Object[index];
            System.arraycopy(objectArray, 0, nonJavaResources, 0, index);
        }
        return nonJavaResources;
    }

    Object[] getNonJavaResources() {
        Object[] nonJavaResources = this.nonJavaResources;
        if (nonJavaResources == null) {
            nonJavaResources = this.computeNonJavaResources();
            this.nonJavaResources = nonJavaResources;
        }
        return nonJavaResources;
    }
}

