/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.core.util;

import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import org.eclipse.jdt.core.compiler.CharOperation;

public class Util {
    private static final char[] DOUBLE_QUOTES = "''".toCharArray();
    private static final char[] SINGLE_QUOTE = "'".toCharArray();
    protected static ResourceBundle bundle;
    private static final String bundleName = "org.eclipse.jdt.internal.core.util.messages";

    static {
        try {
            bundle = ResourceBundle.getBundle(bundleName, Locale.getDefault());
        }
        catch (MissingResourceException e) {
            System.out.println("Missing resource : " + bundleName.replace('.', '/') + ".properties for locale " + Locale.getDefault());
            throw e;
        }
    }

    public static String bind(String id) {
        if (id == null) {
            return "No message available";
        }
        String message = null;
        try {
            message = bundle.getString(id);
        }
        catch (MissingResourceException missingResourceException) {
            return "Missing message: " + id + " in: " + bundleName;
        }
        char[] messageWithNoDoubleQuotes = CharOperation.replace(message.toCharArray(), DOUBLE_QUOTES, SINGLE_QUOTE);
        return new String(messageWithNoDoubleQuotes);
    }

    public static String bind(String id, String binding) {
        return Util.bind(id, new String[]{binding});
    }

    public static String bind(String id, String[] bindings) {
        StringBuffer output;
        block9: {
            if (id == null) {
                return "No message available";
            }
            String message = null;
            try {
                message = bundle.getString(id);
            }
            catch (MissingResourceException missingResourceException) {
                return "Missing message: " + id + " in: " + bundleName;
            }
            char[] messageWithNoDoubleQuotes = CharOperation.replace(message.toCharArray(), DOUBLE_QUOTES, SINGLE_QUOTE);
            message = new String(messageWithNoDoubleQuotes);
            if (bindings == null) {
                return message;
            }
            int length = message.length();
            int start = -1;
            int end = length;
            output = new StringBuffer(80);
            while ((end = message.indexOf(123, start)) > -1) {
                output.append(message.substring(start + 1, end));
                start = message.indexOf(125, end);
                if (start > -1) {
                    int index = -1;
                    try {
                        index = Integer.parseInt(message.substring(end + 1, start));
                        output.append(bindings[index]);
                    }
                    catch (NumberFormatException numberFormatException) {
                        output.append(message.substring(end + 1, start + 1));
                    }
                    catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                        output.append("{missing " + Integer.toString(index) + "}");
                    }
                    continue;
                }
                output.append(message.substring(end, length));
                break block9;
            }
            output.append(message.substring(start + 1, length));
        }
        return output.toString();
    }
}

