/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.components.modules.input;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.avalon.framework.component.ComponentException;
import org.apache.avalon.framework.component.ComponentManager;
import org.apache.avalon.framework.component.Composable;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.apache.avalon.framework.logger.Logger;
import org.apache.avalon.framework.thread.ThreadSafe;
import org.apache.cocoon.components.modules.input.AbstractJXPathModule;
import org.apache.cocoon.components.source.SourceUtil;
import org.apache.excalibur.source.Source;
import org.apache.excalibur.source.SourceResolver;
import org.apache.excalibur.source.SourceValidity;
import org.w3c.dom.Document;

public class XMLFileModule
extends AbstractJXPathModule
implements Composable,
ThreadSafe {
    String staticConfLocation;
    Map documents = null;
    boolean reloadAll = false;
    boolean cacheAll = true;
    String src = null;
    SourceResolver resolver = null;
    ComponentManager manager = null;

    public void compose(ComponentManager manager) throws ComponentException {
        this.manager = manager;
        this.resolver = (SourceResolver)manager.lookup(SourceResolver.ROLE);
    }

    public void configure(Configuration config) throws ConfigurationException {
        this.staticConfLocation = config.getLocation();
        super.configure(config);
        this.reloadAll = config.getChild("reloadable").getValueAsBoolean(this.reloadAll);
        if (config.getChild("cachable", false) != null) {
            throw new ConfigurationException("Bzzt! Wrong spelling at " + config.getChild("cachable").getLocation() + ": please use 'cacheable', not 'cachable'");
        }
        this.cacheAll = config.getChild("cacheable").getValueAsBoolean(this.cacheAll);
        Configuration[] files = config.getChildren("file");
        if (this.documents == null) {
            this.documents = Collections.synchronizedMap(new HashMap());
        }
        for (int i = 0; i < files.length; ++i) {
            boolean reload = files[i].getAttributeAsBoolean("reloadable", this.reloadAll);
            boolean cache = files[i].getAttributeAsBoolean("cacheable", this.cacheAll);
            this.src = files[i].getAttribute("src");
            this.documents.put(files[i], new DocumentHelper(reload, cache, this.src));
        }
    }

    protected Object getContextObject(Configuration modeConf, Map objectModel) throws ConfigurationException {
        String src = this.src;
        boolean reload = this.reloadAll;
        boolean cache = this.cacheAll;
        boolean hasDynamicConf = false;
        Configuration fileConf = null;
        if (modeConf != null) {
            fileConf = modeConf.getChild("file", false);
            if (fileConf == null) {
                this.getLogger().warn("Error: missing 'file' child element at " + modeConf.getLocation());
            } else {
                hasDynamicConf = true;
            }
        }
        if (hasDynamicConf) {
            src = fileConf.getAttribute("src");
        }
        if (this.documents == null) {
            this.documents = Collections.synchronizedMap(new HashMap());
        }
        if (src == null) {
            throw new ConfigurationException("No source specified" + (modeConf != null ? ", either dynamically in " + modeConf.getLocation() + ", or " : "") + " statically in " + this.staticConfLocation);
        }
        if (!this.documents.containsKey(src)) {
            if (hasDynamicConf) {
                reload = fileConf.getAttributeAsBoolean("reloadable", reload);
                cache = fileConf.getAttributeAsBoolean("cacheable", cache);
                if (fileConf.getAttribute("cachable", null) != null) {
                    throw new ConfigurationException("Bzzt! Wrong spelling at " + fileConf.getLocation() + ": please use 'cacheable', not 'cachable'");
                }
            }
            this.documents.put(src, new DocumentHelper(reload, cache, src));
        }
        Document dom = null;
        try {
            dom = ((DocumentHelper)this.documents.get(src)).getDocument(this.manager, this.resolver, this.getLogger());
        }
        catch (Exception e) {
            if (this.getLogger().isDebugEnabled()) {
                this.getLogger().debug("Error using source " + src + "\n" + e.getMessage(), (Throwable)e);
            }
            throw new ConfigurationException("Error using source " + src, (Throwable)e);
        }
        return dom;
    }

    protected class DocumentHelper {
        private boolean reloadable = true;
        private boolean cacheable = true;
        private String uri = null;
        private Document document = null;
        private SourceValidity srcVal = null;

        public DocumentHelper(boolean reload, boolean cache, String src) {
            this.reloadable = reload;
            this.cacheable = cache;
            this.uri = src;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public synchronized Document getDocument(ComponentManager manager, SourceResolver resolver, Logger logger) throws Exception {
            Document dom;
            Source src;
            block11: {
                src = null;
                dom = null;
                try {
                    if (this.document == null) {
                        if (logger.isDebugEnabled()) {
                            logger.debug("Document not cached... reloading uri " + this.uri);
                        }
                        src = resolver.resolveURI(this.uri);
                        this.srcVal = src.getValidity();
                        dom = this.document = SourceUtil.toDOM(src);
                        break block11;
                    }
                    if (this.reloadable) {
                        if (logger.isDebugEnabled()) {
                            logger.debug("Document cached... checking validity of uri " + this.uri);
                        }
                        src = resolver.resolveURI(this.uri);
                        SourceValidity valid = src.getValidity();
                        if (this.srcVal != null && this.srcVal.isValid(valid) != 1) {
                            if (logger.isDebugEnabled()) {
                                logger.debug("reloading document... uri " + this.uri);
                            }
                            this.srcVal = valid;
                            this.document = SourceUtil.toDOM(src);
                        }
                    }
                    dom = this.document;
                }
                catch (Throwable throwable) {
                    resolver.release(src);
                    throw throwable;
                }
            }
            resolver.release(src);
            if (!this.cacheable) {
                if (logger.isDebugEnabled()) {
                    logger.debug("Not caching document cached... uri " + this.uri);
                }
                this.srcVal = null;
                this.document = null;
            }
            if (logger.isDebugEnabled()) {
                logger.debug("Done with document... uri " + this.uri);
            }
            return dom;
        }
    }
}

