/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.connector.warp;

import java.io.IOException;
import java.security.Principal;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Locale;
import java.util.TreeMap;
import javax.servlet.http.Cookie;
import org.apache.catalina.Context;
import org.apache.catalina.Host;
import org.apache.catalina.Request;
import org.apache.catalina.Response;
import org.apache.catalina.connector.warp.WarpConnection;
import org.apache.catalina.connector.warp.WarpConnector;
import org.apache.catalina.connector.warp.WarpLogger;
import org.apache.catalina.connector.warp.WarpPacket;
import org.apache.catalina.connector.warp.WarpRequest;
import org.apache.catalina.connector.warp.WarpResponse;
import org.apache.catalina.util.RequestUtil;
import org.apache.catalina.util.StringParser;

public class WarpRequestHandler {
    private StringParser parser = new StringParser();
    private static final String match = ";jsessionid=";

    public boolean handle(WarpConnection warpConnection, WarpPacket warpPacket) throws IOException {
        WarpLogger warpLogger = new WarpLogger(this);
        WarpConnector warpConnector = warpConnection.getConnector();
        warpLogger.setContainer(warpConnector.getContainer());
        WarpRequest warpRequest = new WarpRequest();
        WarpResponse warpResponse = new WarpResponse();
        warpResponse.setRequest((Request)warpRequest);
        warpResponse.setConnection(warpConnection);
        warpResponse.setPacket(warpPacket);
        warpRequest.setConnection(warpConnection);
        warpRequest.setConnector(warpConnector);
        warpPacket.reset();
        warpPacket.setType(15);
        warpConnection.send(warpPacket);
        block12: while (true) {
            warpConnection.recv(warpPacket);
            switch (warpPacket.getType()) {
                case 16: {
                    int n = warpPacket.readInteger();
                    String string5 = warpPacket.readString();
                    String string2 = warpPacket.readString();
                    String string3 = warpPacket.readString();
                    String string4 = warpPacket.readString();
                    warpRequest.recycle();
                    warpResponse.recycle();
                    warpResponse.setRequest((Request)warpRequest);
                    warpResponse.setConnection(warpConnection);
                    warpResponse.setPacket(warpPacket);
                    warpRequest.setMethod(string5);
                    this.processUri(warpLogger, warpRequest, string2);
                    if (string3.length() > 0) {
                        warpRequest.setQueryString(string3);
                    } else {
                        warpRequest.setQueryString(null);
                    }
                    warpRequest.setProtocol(string4);
                    warpRequest.setConnection(warpConnection);
                    Context context = warpConnector.applicationContext(n);
                    if (context == null) continue block12;
                    warpRequest.setContext(context);
                    warpRequest.setContextPath(context.getPath());
                    warpRequest.setHost((Host)context.getParent());
                    continue block12;
                }
                case 17: {
                    String string = warpPacket.readString();
                    int n = warpPacket.readInteger();
                    if (string.length() > 0) {
                        warpRequest.setContentType(string);
                    }
                    if (n <= 0) continue block12;
                    warpRequest.setContentLength(n);
                    continue block12;
                }
                case 18: {
                    String string = warpPacket.readString();
                    warpRequest.setScheme(string);
                    if (!string.equals("https")) continue block12;
                    warpRequest.setSecure(true);
                    continue block12;
                }
                case 19: {
                    String string = warpPacket.readString();
                    String string5 = warpPacket.readString();
                    warpRequest.setAuthType(string5);
                    if (string == null || string5 == null || !string5.equals("Basic")) continue block12;
                    BasicPrincipal basicPrincipal = new BasicPrincipal(string);
                    warpRequest.setUserPrincipal(basicPrincipal);
                    continue block12;
                }
                case 20: {
                    String string = warpPacket.readString();
                    String string5 = warpPacket.readString();
                    this.processHeader(warpLogger, warpRequest, string, string5);
                    continue block12;
                }
                case 21: {
                    String string = warpPacket.readString();
                    String string5 = warpPacket.readString();
                    int n = warpPacket.readUnsignedShort();
                    warpRequest.setServerName(string);
                    warpRequest.setServerPort(n);
                    continue block12;
                }
                case 22: {
                    String string = warpPacket.readString();
                    String string5 = warpPacket.readString();
                    int n = warpPacket.readUnsignedShort();
                    warpRequest.setRemoteHost(string);
                    warpRequest.setRemoteAddr(string5);
                    continue block12;
                }
                case 31: {
                    try {
                        warpConnector.getContainer().invoke((Request)warpRequest, (Response)warpResponse);
                    }
                    catch (Exception exception) {
                        warpLogger.log(exception);
                    }
                    warpRequest.finishRequest();
                    warpResponse.finishResponse();
                    continue block12;
                }
            }
            break;
        }
        String string = "Invalid packet " + warpPacket.getType();
        warpLogger.log(string);
        warpPacket.reset();
        warpPacket.setType(255);
        warpPacket.writeString(string);
        warpConnection.send(warpPacket);
        return false;
    }

    private void processUri(WarpLogger warpLogger, WarpRequest warpRequest, String string) {
        int n = string.indexOf(match);
        if (n >= 0) {
            String string2 = string.substring(n + match.length());
            int n2 = string2.indexOf(59);
            if (n2 >= 0) {
                warpRequest.setRequestedSessionId(string2.substring(0, n2));
                string2 = string2.substring(n2);
            } else {
                warpRequest.setRequestedSessionId(string2);
                string2 = "";
            }
            warpRequest.setRequestedSessionURL(true);
            string = string.substring(0, n) + string2;
        } else {
            warpRequest.setRequestedSessionId(null);
            warpRequest.setRequestedSessionURL(false);
        }
        warpRequest.setRequestURI(string);
    }

    private void processHeader(WarpLogger warpLogger, WarpRequest warpRequest, String string, String string2) {
        if ("cookie".equalsIgnoreCase(string)) {
            Cookie[] cookieArray = RequestUtil.parseCookieHeader((String)string2);
            for (int i = 0; i < cookieArray.length; ++i) {
                if (cookieArray[i].getName().equals("JSESSIONID") && !warpRequest.isRequestedSessionIdFromCookie()) {
                    warpRequest.setRequestedSessionId(cookieArray[i].getValue());
                    warpRequest.setRequestedSessionCookie(true);
                    warpRequest.setRequestedSessionURL(false);
                }
                warpRequest.addCookie(cookieArray[i]);
            }
        }
        if (string.equalsIgnoreCase("Accept-Language")) {
            this.parseAcceptLanguage(warpLogger, warpRequest, string2);
        }
        if (string.equalsIgnoreCase("Authorization")) {
            warpRequest.setAuthorization(string2);
        }
        warpRequest.addHeader(string, string2);
    }

    private void parseAcceptLanguage(WarpLogger warpLogger, WarpRequest warpRequest, String string) {
        int n;
        int n2;
        TreeMap<Double, ArrayList<Locale>> treeMap = new TreeMap<Double, ArrayList<Locale>>();
        int n3 = string.indexOf(32);
        if (n3 < 0) {
            n3 = string.indexOf(9);
        }
        if (n3 >= 0) {
            StringBuffer stringBuffer = new StringBuffer();
            n2 = string.length();
            for (n = 0; n < n2; ++n) {
                char c = string.charAt(n);
                if (c == ' ' || c == '\t') continue;
                stringBuffer.append(c);
            }
            string = stringBuffer.toString();
        }
        this.parser.setString(string);
        int n4 = this.parser.getLength();
        while ((n2 = this.parser.getIndex()) < n4) {
            n = this.parser.findChar(',');
            String string2 = this.parser.extract(n2, n).trim();
            this.parser.advance();
            double d = 1.0;
            int n5 = string2.indexOf(";q=");
            if (n5 >= 0) {
                try {
                    d = Double.parseDouble(string2.substring(n5 + 3));
                }
                catch (NumberFormatException numberFormatException) {
                    d = 0.0;
                }
                string2 = string2.substring(0, n5);
            }
            if (d < 5.0E-5 || "*".equals(string2)) continue;
            String string3 = null;
            String string4 = null;
            int n6 = string2.indexOf(45);
            if (n6 < 0) {
                string3 = string2;
                string4 = "";
            } else {
                string3 = string2.substring(0, n6);
                string4 = string2.substring(n6 + 1);
            }
            Locale locale = new Locale(string3, string4);
            Double d2 = new Double(-d);
            ArrayList<Locale> arrayList = (ArrayList<Locale>)treeMap.get(d2);
            if (arrayList == null) {
                arrayList = new ArrayList<Locale>();
                treeMap.put(d2, arrayList);
            }
            arrayList.add(locale);
        }
        Iterator iterator = treeMap.keySet().iterator();
        while (iterator.hasNext()) {
            Double d = (Double)iterator.next();
            ArrayList arrayList = (ArrayList)treeMap.get(d);
            Iterator iterator2 = arrayList.iterator();
            while (iterator2.hasNext()) {
                Locale locale = (Locale)iterator2.next();
                warpRequest.addLocale(locale);
            }
        }
    }

    class BasicPrincipal
    implements Principal {
        private String user;

        BasicPrincipal(String string) {
            this.user = string;
        }

        public boolean equals(Object object) {
            return object instanceof Principal && ((Principal)object).getName().equals(this.user);
        }

        public String getName() {
            return this.user;
        }

        public String toString() {
            return this.getName();
        }
    }
}

