/*
 * Decompiled with CFR 0.152.
 */
package javax.management.monitor;

import javax.management.MBeanNotificationInfo;
import javax.management.monitor.CounterMonitorMBean;
import javax.management.monitor.Monitor;
import javax.management.monitor.MonitorMBean;

public class CounterMonitor
extends Monitor
implements MonitorMBean,
CounterMonitorMBean {
    private boolean notify = false;
    private boolean differenceMode = false;
    private Number modulus = new Integer(0);
    private Number offset = new Integer(0);
    private Number threshold = new Integer(0);
    private Number lastDerivatedGauge = new Integer(0);
    private long lastDerivatedGaugeTimestamp = 0L;
    private transient Number lastValue = null;
    private transient Number originalThreshold = null;
    private transient boolean wasNotified = false;
    private transient boolean errorNotified = false;
    private transient Class type = NONE;
    private static final Class NONE = null;
    private static final Class INT = class$java$lang$Integer == null ? (class$java$lang$Integer = CounterMonitor.class$("java.lang.Integer")) : class$java$lang$Integer;
    private static final Class LONG = class$java$lang$Long == null ? (class$java$lang$Long = CounterMonitor.class$("java.lang.Long")) : class$java$lang$Long;
    private static final Class BYTE = class$java$lang$Byte == null ? (class$java$lang$Byte = CounterMonitor.class$("java.lang.Byte")) : class$java$lang$Byte;
    private static final Class SHORT = class$java$lang$Short == null ? (class$java$lang$Short = CounterMonitor.class$("java.lang.Short")) : class$java$lang$Short;
    private static final MBeanNotificationInfo[] notificationInfos = new MBeanNotificationInfo[]{new MBeanNotificationInfo(new String[]{"jmx.monitor.error.runtime", "jmx.monitor.error.mbean", "jmx.monitor.error.attribute", "jmx.monitor.error.type", "jmx.monitor.error.threshold", "jmx.monitor.counter.threshold"}, "javax.management.monitor.MonitorNotification", "Notifications sent by the CounterMonitor MBean")};
    static /* synthetic */ Class class$java$lang$Integer;
    static /* synthetic */ Class class$java$lang$Long;
    static /* synthetic */ Class class$java$lang$Byte;
    static /* synthetic */ Class class$java$lang$Short;

    public synchronized void start() {
        this.doStart();
    }

    public synchronized void stop() {
        this.doStop();
    }

    void executeMonitor(Object attributeValue) {
        if (!(this.threshold != null && this.threshold.longValue() != 0L || this.errorNotified)) {
            this.getLogger().info(new StringBuffer("Monitor ").append(this).append(" threshold value is null or zero"));
            this.notifyListeners("jmx.monitor.error.threshold", this.objectName, this.attribute);
            this.errorNotified = true;
            return;
        }
        if (!(attributeValue instanceof Number) && !this.errorNotified) {
            this.getLogger().info(new StringBuffer("Monitor ").append(this).append(" attribute is not a Number"));
            this.notifyListeners("jmx.monitor.error.threshold", this.objectName, this.attribute);
            this.errorNotified = true;
            return;
        }
        this.determineType(attributeValue);
        if (this.type == NONE && !this.errorNotified) {
            this.getLogger().info(new StringBuffer("Monitor ").append(this).append(" attribute, threshold, offset and modules types don't match"));
            this.notifyListeners("jmx.monitor.error.threshold", this.objectName, this.attribute);
            this.errorNotified = true;
            return;
        }
        this.calculateDerivedGauge((Number)attributeValue);
        if (!this.wasNotified) {
            if (((Number)attributeValue).longValue() >= this.threshold.longValue()) {
                if (this.modulus != null && this.modulus.longValue() > 0L && ((Number)attributeValue).longValue() >= this.modulus.longValue()) {
                    this.threshold = this.originalThreshold;
                } else if (this.offset != null && this.offset.longValue() > 0L) {
                    while (this.threshold.longValue() <= ((Number)attributeValue).longValue()) {
                        this.threshold = this.createNumber(this.threshold.longValue() + this.offset.longValue());
                    }
                }
                if (this.notify) {
                    this.getLogger().info(new StringBuffer("Monitor ").append(this).append(" counter over the threshold"));
                    this.notifyListeners("jmx.monitor.counter.threshold", this.objectName, this.attribute);
                }
            }
            this.wasNotified = true;
        }
    }

    void determineType(Object attributeValue) {
        Class<?> targetClass = attributeValue.getClass();
        if (this.threshold != null) {
            if (targetClass.equals(this.threshold.getClass())) {
                boolean match = true;
                if (this.offset != null && !targetClass.equals(this.offset.getClass())) {
                    match = false;
                }
                if (this.modulus != null && !targetClass.equals(this.modulus.getClass())) {
                    match = false;
                }
                if (targetClass != INT && targetClass != LONG && targetClass != BYTE && targetClass != SHORT) {
                    match = false;
                }
                if (match) {
                    this.type = targetClass;
                }
            } else {
                this.type = NONE;
            }
        } else {
            this.type = NONE;
        }
    }

    void calculateDerivedGauge(Number attributeValue) {
        this.lastDerivatedGaugeTimestamp = System.currentTimeMillis();
        if (this.differenceMode && this.lastValue != null) {
            long difference = attributeValue.longValue() - this.lastValue.longValue();
            if (this.modulus != null && this.modulus.longValue() > 0L && attributeValue.longValue() > this.modulus.longValue()) {
                difference = attributeValue.longValue() - this.modulus.longValue();
            }
            this.lastDerivatedGauge = this.createNumber(difference);
        }
        if (this.lastValue != null && !this.lastValue.equals(attributeValue)) {
            this.wasNotified = false;
        }
        this.lastValue = attributeValue;
    }

    Number createNumber(long value) {
        Number result = null;
        if (this.type == INT) {
            result = new Integer((int)value);
        } else if (this.type == LONG) {
            result = new Long(value);
        } else if (this.type == SHORT) {
            result = new Short((short)value);
        } else if (this.type == BYTE) {
            result = new Byte((byte)value);
        }
        return result;
    }

    public Number getDerivedGauge() {
        return this.lastDerivatedGauge;
    }

    public long getDerivedGaugeTimeStamp() {
        return this.lastDerivatedGaugeTimestamp;
    }

    public Number getThreshold() {
        return this.threshold;
    }

    public void setThreshold(Number value) throws IllegalArgumentException {
        if (value == null || value.longValue() < 0L) {
            throw new IllegalArgumentException("The threshold value has to be a valid number higher than 0");
        }
        this.originalThreshold = value;
        this.threshold = value;
        this.lastValue = null;
        this.wasNotified = false;
    }

    public Number getOffset() {
        return this.offset;
    }

    public void setOffset(Number value) throws IllegalArgumentException {
        if (value == null || value.longValue() < 0L) {
            throw new IllegalArgumentException("The threshold value has to be a valid number higher than 0");
        }
        this.offset = value;
        this.wasNotified = false;
    }

    public Number getModulus() {
        return this.modulus;
    }

    public void setModulus(Number value) throws IllegalArgumentException {
        if (value == null || value.longValue() < 0L) {
            throw new IllegalArgumentException("The threshold value has to be a valid number higher than 0");
        }
        this.modulus = value;
    }

    public boolean getNotify() {
        return this.notify;
    }

    public void setNotify(boolean value) {
        this.notify = value;
    }

    public boolean getDifferenceMode() {
        return this.differenceMode;
    }

    public void setDifferenceMode(boolean value) {
        this.differenceMode = value;
    }

    public String toString() {
        return "CounterMonitor on " + super.toString();
    }

    public MBeanNotificationInfo[] getNotificationInfo() {
        return notificationInfos;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

