/*
 * Decompiled with CFR 0.152.
 */
package org.apache.excalibur.source.impl;

import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import org.apache.excalibur.source.Source;
import org.apache.excalibur.source.SourceException;
import org.apache.excalibur.source.SourceNotFoundException;
import org.apache.excalibur.source.SourceUtil;
import org.apache.excalibur.source.SourceValidity;
import org.apache.excalibur.source.impl.AbstractSource;
import org.apache.excalibur.source.impl.validity.NOPValidity;

public final class ResourceSource
extends AbstractSource
implements Source {
    private URL m_location;
    private String m_mimeType;

    public ResourceSource(String systemId) throws MalformedURLException {
        int pos = SourceUtil.indexOfSchemeColon(systemId);
        if (pos == -1 || !systemId.startsWith("://", pos)) {
            throw new MalformedURLException("Invalid format for ResourceSource : " + systemId);
        }
        this.setSystemId(systemId);
        this.m_location = this.getClassLoader().getResource(systemId.substring(pos + 3));
        this.setScheme(systemId.substring(0, pos));
    }

    public boolean exists() {
        return this.m_location != null;
    }

    protected void checkInfos() {
        super.checkInfos();
        URLConnection connection = null;
        try {
            connection = this.m_location.openConnection();
            this.setLastModified(connection.getLastModified());
            this.setContentLength(connection.getContentLength());
            this.m_mimeType = connection.getContentType();
        }
        catch (IOException ioe) {
            this.setLastModified(0L);
            this.setContentLength(-1L);
            this.m_mimeType = null;
        }
    }

    public String getMimeType() {
        return this.m_mimeType;
    }

    public InputStream getInputStream() throws IOException, SourceException {
        InputStream in = this.m_location.openStream();
        if (in == null) {
            throw new SourceNotFoundException("Source '" + this.m_location + "' was not found");
        }
        return in;
    }

    public SourceValidity getValidity() {
        return NOPValidity.SHARED_INSTANCE;
    }

    protected ClassLoader getClassLoader() {
        ClassLoader loader = Thread.currentThread().getContextClassLoader();
        if (loader == null) {
            loader = this.getClass().getClassLoader();
        }
        return loader;
    }
}

