<?xml version="1.0" encoding="ISO-8859-15"?>
<!-- 
 *   Copyright (C) 2002, 2003, 2004 Jatec AG, Switzerland
 *
 * This file is part of IronMailer.
 *
 * IronMailer is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.

 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
-->

<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0">

<xsl:template match="page/setupuser">
 <content>

   <xsl:variable name="update_action"
       select="'setupuser.xsl?act=setupuser'"/>
	  
   <xsl:if test="update/ok">
      <p class="simpletext" align="center">
         <img align="middle" border="0" src="images/gnome/dialog-info.png" />
         &#160;<xsl:value-of select="update/text"/>
      </p>
   </xsl:if>


   <!-- Header stuff -->
   <table cellpadding="4" cellspacing="2" border="0" width="100%">
    <tbody>
      <!-- Header row 1 -->
      <tr>
	<td class="simpletext" height="22">
		<img align="middle" hspace="5" src="images/gnome/configuration-32.png"/>
		<xsl:value-of select="normalize-space(headertext1)" />
		<br/>
		<span class="infotext">
		   <xsl:value-of select="normalize-space(userpreferencesstate)" />
		</span>
	</td>
      </tr>
    </tbody>
   </table>

	<form method="post">
	   <xsl:attribute name="action">
	      <xsl:value-of select="$update_action"/>
	   </xsl:attribute>
	   <table cellpadding="4" cellspacing="2" border="0" width="100%">
	   <tbody>

		<!-- signature stuff -->
		<tr class="field_light_bg" width="13%">
			<td class="simpletext" align="center">
				<xsl:value-of select="normalize-space(signature/header)" />
			</td>

			<td class="simpletext" width="64%">
				<textarea wrap="physical" class="simpletext" rows="5" cols="80" name="signature">
					<!-- don't use normalize-spaces here !! -->
					<xsl:if test="signature/value">
						<xsl:value-of select="signature/value" />
				        </xsl:if>
				</textarea>
			</td>
			<td class="simpletext" align="left" width="23%">
				<xsl:value-of select="normalize-space(signature/help)" />
			</td>
		</tr>
	   </tbody>
	   </table>
	
	   <br />
	   <table cellpadding="4" cellspacing="2" border="0" width="100%">
	   <tbody>

		<!-- fromAddress stuff -->
		<tr class="field_middle_bg">
			<td class="simpletext" align="center">
				<xsl:value-of select="normalize-space(fromAddress/header)" />
			</td>
			<!-- second column for from address: use a table for
		formatting 
			  -->
			<td class="simpletext">
     			  <table cellpadding="4" cellspacing="2" border="0" width="100%">
			  <tbody>
			    <tr class="simpletext">
				<td>
			          <xsl:value-of select="normalize-space(fromAddress/headerName)" />
				</td>
				<td>
				  <input type="text" size="30" name="fromAddressName">
				   <!-- don't use normalize-spaces here !! -->
				   <xsl:if test="fromAddress/value">
					<xsl:attribute name="value">
						<xsl:value-of select="fromAddress/value/name" />
					</xsl:attribute>
			           </xsl:if>
				  </input>
				</td>
			    </tr>
			    <tr class="simpletext">
			    	<td>
			    	  <xsl:value-of select="normalize-space(fromAddress/headerAddress)" />
				</td>
				<td>
				  <input type="text" size="30" name="fromAddressAddress">
					<xsl:attribute name="value">
					   <!-- don't use normalize-spaces here !! -->
					   <xsl:if test="fromAddress/value">
						<xsl:value-of select="fromAddress/value/address" />
				           </xsl:if>
					</xsl:attribute>
				  </input>
				</td>
			     </tr>
			   </tbody>
			   </table>
			   <!-- end formatting table for second column
			        of from address -->
			</td>
			<td class="simpletext" align="left">
				<xsl:value-of select="normalize-space(fromAddress/help)" />
			</td>
		<!-- end "from address" row -->
		</tr>

		<!-- Initial folder row -->
		<tr class="field_light_bg">
			<td class="simpletext" align="center">
				<xsl:value-of select="normalize-space(folderoptions/text1)" />
			</td>
			<td class="simpletext">
				<select class="simpletext" name="initialFolder">
			        <xsl:for-each select="folderoptions/destination">
					<option>
						<xsl:attribute name="value">
							<xsl:value-of select="normalize-space(folderNr)" />
						</xsl:attribute>
						<xsl:if test="current">
							<xsl:attribute name="selected">selected</xsl:attribute>
						</xsl:if>
			        		<xsl:value-of select="normalize-space(folderName)" />
					</option>
	       			</xsl:for-each>
				</select>
			</td>
			<td class="simpletext" align="left">
				<xsl:value-of select="normalize-space(folderoptions/help)" />
			</td>
		</tr>

		<!-- reply option -->
		<tr class="field_middle_bg">
			<td class="simpletext" align="center">
				<xsl:value-of select="normalize-space(replyto/header)" />
			</td>
			<td class="simpletext">
			    <img hspace="3" border="0" src="images/gnome/reply_to_all-16.png"/>
			    <input class="simpletext" name="replyToAll" value="true" type="checkbox">
				<xsl:if test="replyto/value_all_set">
				   <xsl:attribute name="checked">checked</xsl:attribute>
				</xsl:if>
			    </input>
			    <xsl:value-of select="normalize-space(replyto/value_all)" />
			</td>
			<td class="simpletext" align="left">
				<xsl:value-of select="normalize-space(replyto/help)" />
			</td>
		</tr>

		<!-- forwarding option -->
		<tr class="field_light_bg">
			<td class="simpletext" align="center">
				<xsl:value-of select="normalize-space(forward/header)" />
			</td>
			<td class="simpletext">
			    <input class="simpletext" name="forwardAsAttachment" value="true" type="checkbox">
				<xsl:if test="forward/value_set">
				   <xsl:attribute name="checked">checked</xsl:attribute>
				</xsl:if>
			    </input>
			    <xsl:value-of select="normalize-space(forward/value_set_text)" />
			</td>
			<td class="simpletext" align="left">
				<xsl:value-of select="normalize-space(forward/help)" />
			</td>
		</tr>

		<!-- reply separator option -->
		<tr class="field_middle_bg">
		   <td class="simpletext" align="center">
		      <xsl:value-of
		select="normalize-space(replyseparator/header)" />
		   </td>
		   <td class="simpletext">
		      <textarea wrap="physical" class="simpletext" rows="2" cols="40" name="replyseparator">
		           <!-- don't use normalize-spaces here !! -->
			   <xsl:if test="replyseparator/value">
				<xsl:value-of select="replyseparator/value" />
			   </xsl:if>
		      </textarea>
		   </td>
		   <td class="simpletext" align="left">
			<xsl:value-of select="normalize-space(replyseparator/help)" />
		   </td>
		</tr>

		<!-- forward separator option -->
		<tr class="field_light_bg">
		   <td class="simpletext" align="center">
		      <xsl:value-of
		select="normalize-space(forwardseparator/header)" />
		   </td>
		   <td class="simpletext">
		      <textarea wrap="physical" class="simpletext" rows="2" cols="40" name="forwardseparator">
		           <!-- don't use normalize-spaces here !! -->
			   <xsl:if test="forwardseparator/value">
				<xsl:value-of select="forwardseparator/value" />
			   </xsl:if>
		      </textarea>
		   </td>
		   <td class="simpletext" align="left">
			<xsl:value-of select="normalize-space(forwardseparator/help)" />
		   </td>
		</tr>

	   </tbody>
	   </table>

	   <p class="simpletext" align="center">
		<input name="store" class="simpletext" type="submit">
			<xsl:attribute name="value">
				<xsl:value-of select="normalize-space(actiontext)" />
			</xsl:attribute>
		</input>
	   </p>

	</form>



	<!-- <xsl:comment> 
		<xsl:value-of select="setupuser" />
	</xsl:comment> -->

  </content>
</xsl:template>

   <!-- stuff to pass on the rest of the content 
        (i.e., any parts that this stylesheet is not concerned with) -->
   <xsl:template match="@*|node()">
      <xsl:copy>
         <xsl:apply-templates select="@*|node()"/>
      </xsl:copy>
   </xsl:template>
   <xsl:template match="text()">
      <xsl:value-of select="."/>
   </xsl:template>

</xsl:stylesheet>
