/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.layout;

import java.util.ArrayList;
import org.apache.fop.fo.flow.Footnote;
import org.apache.fop.fo.flow.FootnoteBody;
import org.apache.fop.layout.Area;
import org.apache.fop.layout.FontState;
import org.apache.fop.layout.HyphenationProps;
import org.apache.fop.layout.LineArea;
import org.apache.fop.layout.LinkSet;
import org.apache.fop.layout.Page;
import org.apache.fop.render.Renderer;

public class BlockArea
extends Area {
    protected int startIndent;
    protected int endIndent;
    protected int textIndent;
    protected int lineHeight;
    protected int halfLeading;
    protected int align;
    protected int alignLastLine;
    protected LineArea currentLineArea;
    protected LinkSet currentLinkSet;
    protected HyphenationProps hyphProps;
    protected ArrayList pendingFootnotes = null;

    public BlockArea(FontState fontState, int allocationWidth, int maxHeight, int startIndent, int endIndent, int textIndent, int align, int alignLastLine, int lineHeight) {
        super(fontState, allocationWidth, maxHeight);
        this.startIndent = startIndent;
        this.endIndent = endIndent;
        this.textIndent = textIndent;
        this.contentRectangleWidth = allocationWidth - startIndent - endIndent;
        this.align = align;
        this.alignLastLine = alignLastLine;
        this.lineHeight = lineHeight;
        if (fontState != null) {
            this.halfLeading = (lineHeight - fontState.getFontSize()) / 2;
        }
    }

    public void render(Renderer renderer) {
        renderer.renderBlockArea(this);
    }

    protected void addLineArea(LineArea la) {
        if (!la.isEmpty()) {
            la.verticalAlign();
            this.addDisplaySpace(this.halfLeading);
            int size = la.getHeight();
            this.addChild(la);
            this.increaseHeight(size);
            this.addDisplaySpace(this.halfLeading);
        }
        if (this.pendingFootnotes != null) {
            int i = 0;
            while (i < this.pendingFootnotes.size()) {
                FootnoteBody fb = (FootnoteBody)this.pendingFootnotes.get(i);
                Page page = this.getPage();
                if (!Footnote.layoutFootnote(page, fb, this)) {
                    page.addPendingFootnote(fb);
                }
                ++i;
            }
            this.pendingFootnotes = null;
        }
    }

    public LineArea getCurrentLineArea() {
        if (this.currentHeight + this.lineHeight > this.maxHeight) {
            return null;
        }
        if (this.currentLineArea == null) {
            this.currentLineArea = new LineArea(this.fontState, this.lineHeight, this.halfLeading, this.allocationWidth, this.startIndent + this.textIndent, this.endIndent, null);
            this.currentLineArea.changeHyphenation(this.hyphProps);
        }
        return this.currentLineArea;
    }

    public LineArea createNextLineArea() {
        if (this.currentLineArea != null) {
            this.currentLineArea.align(this.align);
            this.addLineArea(this.currentLineArea);
        }
        if (this.currentHeight + this.lineHeight > this.maxHeight) {
            return null;
        }
        this.currentLineArea = new LineArea(this.fontState, this.lineHeight, this.halfLeading, this.allocationWidth, this.startIndent, this.endIndent, this.currentLineArea);
        this.currentLineArea.changeHyphenation(this.hyphProps);
        return this.currentLineArea;
    }

    public void setupLinkSet(LinkSet ls) {
        if (ls != null) {
            this.currentLinkSet = ls;
            ls.setYOffset(this.currentHeight);
        }
    }

    public void end() {
        if (this.currentLineArea != null) {
            this.currentLineArea.addPending();
            this.currentLineArea.align(this.alignLastLine);
            this.addLineArea(this.currentLineArea);
            this.currentLineArea = null;
        }
    }

    public void start() {
    }

    public int getEndIndent() {
        return this.endIndent;
    }

    public int getStartIndent() {
        return this.startIndent;
    }

    public void setIndents(int startIndent, int endIndent) {
        this.startIndent = startIndent;
        this.endIndent = endIndent;
        this.contentRectangleWidth = this.allocationWidth - startIndent - endIndent;
    }

    public int spaceLeft() {
        return this.maxHeight - this.currentHeight - (this.getPaddingTop() + this.getPaddingBottom() + this.getBorderTopWidth() + this.getBorderBottomWidth());
    }

    public int getHalfLeading() {
        return this.halfLeading;
    }

    public void setHyphenation(HyphenationProps hyphProps) {
        this.hyphProps = hyphProps;
    }

    public void addFootnote(FootnoteBody fb) {
        if (this.pendingFootnotes == null) {
            this.pendingFootnotes = new ArrayList();
        }
        this.pendingFootnotes.add(fb);
    }
}

