/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.compiler.ast;

import org.eclipse.jdt.internal.compiler.IAbstractSyntaxTreeVisitor;
import org.eclipse.jdt.internal.compiler.ast.AbstractMethodDeclaration;
import org.eclipse.jdt.internal.compiler.ast.AstNode;
import org.eclipse.jdt.internal.compiler.ast.Expression;
import org.eclipse.jdt.internal.compiler.ast.Statement;
import org.eclipse.jdt.internal.compiler.ast.SynchronizedStatement;
import org.eclipse.jdt.internal.compiler.ast.TryStatement;
import org.eclipse.jdt.internal.compiler.codegen.CodeStream;
import org.eclipse.jdt.internal.compiler.flow.FlowContext;
import org.eclipse.jdt.internal.compiler.flow.FlowInfo;
import org.eclipse.jdt.internal.compiler.flow.InitializationFlowContext;
import org.eclipse.jdt.internal.compiler.lookup.BaseTypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.BaseTypes;
import org.eclipse.jdt.internal.compiler.lookup.BlockScope;
import org.eclipse.jdt.internal.compiler.lookup.LocalVariableBinding;
import org.eclipse.jdt.internal.compiler.lookup.MethodBinding;
import org.eclipse.jdt.internal.compiler.lookup.MethodScope;
import org.eclipse.jdt.internal.compiler.lookup.TypeBinding;

public class ReturnStatement
extends Statement {
    public Expression expression;
    public TypeBinding expressionType;
    public boolean isSynchronized;
    public AstNode[] subroutines;
    public LocalVariableBinding saveValueVariable;

    public ReturnStatement(Expression expr, int s, int e) {
        this.sourceStart = s;
        this.sourceEnd = e;
        this.expression = expr;
    }

    public FlowInfo analyseCode(BlockScope currentScope, FlowContext flowContext, FlowInfo flowInfo) {
        boolean hasValueToSave;
        if (this.expression != null) {
            flowInfo = this.expression.analyseCode(currentScope, flowContext, flowInfo);
        }
        FlowContext traversedContext = flowContext;
        int subIndex = 0;
        int maxSub = 5;
        boolean saveValueNeeded = false;
        boolean bl = hasValueToSave = this.expression != null && this.expression.constant == AstNode.NotAConstant;
        do {
            AstNode sub;
            if ((sub = traversedContext.subRoutine()) != null) {
                if (this.subroutines == null) {
                    this.subroutines = new AstNode[maxSub];
                }
                if (subIndex == maxSub) {
                    this.subroutines = new AstNode[maxSub *= 2];
                    System.arraycopy(this.subroutines, 0, this.subroutines, 0, subIndex);
                }
                this.subroutines[subIndex++] = sub;
                if (sub.cannotReturn()) {
                    saveValueNeeded = false;
                    break;
                }
            }
            traversedContext.recordReturnFrom(flowInfo.unconditionalInits());
            AstNode node = traversedContext.associatedNode;
            if (node instanceof SynchronizedStatement) {
                this.isSynchronized = true;
                continue;
            }
            if (node instanceof TryStatement) {
                TryStatement tryStatement = (TryStatement)node;
                flowInfo.addInitializationsFrom(tryStatement.subRoutineInits);
                if (!hasValueToSave) continue;
                if (this.saveValueVariable == null) {
                    this.prepareSaveValueLocation(tryStatement);
                }
                saveValueNeeded = true;
                continue;
            }
            if (!(traversedContext instanceof InitializationFlowContext)) continue;
            currentScope.problemReporter().cannotReturnInInitializer(this);
            return FlowInfo.DEAD_END;
        } while ((traversedContext = traversedContext.parent) != null);
        if (this.subroutines != null && subIndex != maxSub) {
            this.subroutines = new AstNode[subIndex];
            System.arraycopy(this.subroutines, 0, this.subroutines, 0, subIndex);
        }
        if (saveValueNeeded) {
            if (this.saveValueVariable != null) {
                this.saveValueVariable.useFlag = 1;
            }
        } else {
            this.saveValueVariable = null;
            if (!this.isSynchronized && this.expressionType == BaseTypes.BooleanBinding) {
                this.expression.bits |= 0x10;
            }
        }
        return FlowInfo.DEAD_END;
    }

    public void generateCode(BlockScope currentScope, CodeStream codeStream) {
        if ((this.bits & Integer.MIN_VALUE) == 0) {
            return;
        }
        int pc = codeStream.position;
        if (this.expression != null && this.expression.constant == AstNode.NotAConstant) {
            this.expression.generateCode(currentScope, codeStream, this.needValue());
            this.generateStoreSaveValueIfNecessary(codeStream);
        }
        if (this.subroutines != null) {
            int i = 0;
            int max = this.subroutines.length;
            while (i < max) {
                AstNode sub = this.subroutines[i];
                if (sub instanceof SynchronizedStatement) {
                    codeStream.load(((SynchronizedStatement)sub).synchroVariable);
                    codeStream.monitorexit();
                } else {
                    TryStatement trySub = (TryStatement)sub;
                    if (trySub.subRoutineCannotReturn) {
                        codeStream.goto_(trySub.subRoutineStartLabel);
                        codeStream.recordPositionsFrom(pc, this.sourceStart);
                        return;
                    }
                    codeStream.jsr(trySub.subRoutineStartLabel);
                }
                ++i;
            }
        }
        if (this.saveValueVariable != null) {
            codeStream.load(this.saveValueVariable);
        }
        if (this.expression != null && this.expression.constant != AstNode.NotAConstant) {
            codeStream.generateConstant(this.expression.constant, this.expression.implicitConversion);
            this.generateStoreSaveValueIfNecessary(codeStream);
        }
        this.generateReturnBytecode(codeStream);
        codeStream.recordPositionsFrom(pc, this.sourceStart);
    }

    public void generateReturnBytecode(CodeStream codeStream) {
        if (this.expression == null) {
            codeStream.return_();
        } else {
            switch (this.expression.implicitConversion >> 4) {
                case 5: 
                case 10: {
                    codeStream.ireturn();
                    break;
                }
                case 9: {
                    codeStream.freturn();
                    break;
                }
                case 7: {
                    codeStream.lreturn();
                    break;
                }
                case 8: {
                    codeStream.dreturn();
                    break;
                }
                default: {
                    codeStream.areturn();
                }
            }
        }
    }

    public void generateStoreSaveValueIfNecessary(CodeStream codeStream) {
        if (this.saveValueVariable != null) {
            codeStream.store(this.saveValueVariable, false);
        }
    }

    public boolean needValue() {
        return this.subroutines == null || this.saveValueVariable != null || this.isSynchronized;
    }

    public void prepareSaveValueLocation(TryStatement targetTryStatement) {
        this.saveValueVariable = targetTryStatement.secretReturnValue;
    }

    public void resolve(BlockScope scope) {
        BaseTypeBinding methodType;
        MethodBinding methodBinding;
        MethodScope methodScope = scope.methodScope();
        Object object = methodScope.referenceContext instanceof AbstractMethodDeclaration ? ((methodBinding = ((AbstractMethodDeclaration)methodScope.referenceContext).binding) == null ? null : methodBinding.returnType) : (methodType = BaseTypes.VoidBinding);
        if (methodType == BaseTypes.VoidBinding) {
            if (this.expression == null) {
                return;
            }
            this.expressionType = this.expression.resolveType(scope);
            if (this.expressionType != null) {
                scope.problemReporter().attemptToReturnNonVoidExpression(this, this.expressionType);
            }
            return;
        }
        if (this.expression == null) {
            if (methodType != null) {
                scope.problemReporter().shouldReturn(methodType, this);
            }
            return;
        }
        this.expressionType = this.expression.resolveType(scope);
        if (this.expressionType == null) {
            return;
        }
        if (methodType != null && this.expression.isConstantValueOfTypeAssignableToType(this.expressionType, methodType)) {
            this.expression.implicitWidening(methodType, this.expressionType);
            return;
        }
        if (this.expressionType == BaseTypes.VoidBinding) {
            scope.problemReporter().attemptToReturnVoidValue(this);
            return;
        }
        if (methodType != null && this.expressionType.isCompatibleWith(methodType)) {
            this.expression.implicitWidening(methodType, this.expressionType);
            return;
        }
        if (methodType != null) {
            scope.problemReporter().typeMismatchErrorActualTypeExpectedType(this.expression, this.expressionType, methodType);
        }
    }

    public String toString(int tab) {
        String s = AstNode.tabString(tab);
        s = String.valueOf(s) + "return ";
        if (this.expression != null) {
            s = String.valueOf(s) + this.expression.toStringExpression();
        }
        return s;
    }

    public void traverse(IAbstractSyntaxTreeVisitor visitor, BlockScope scope) {
        if (visitor.visit(this, scope) && this.expression != null) {
            this.expression.traverse(visitor, scope);
        }
        visitor.endVisit(this, scope);
    }
}

