/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.core;

import java.io.InputStream;
import java.util.ArrayList;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.core.ICompletionRequestor;
import org.eclipse.jdt.core.IField;
import org.eclipse.jdt.core.IInitializer;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.ITypeHierarchy;
import org.eclipse.jdt.core.IWorkingCopy;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.compiler.CharOperation;
import org.eclipse.jdt.core.compiler.IProblem;
import org.eclipse.jdt.core.jdom.IDOMNode;
import org.eclipse.jdt.core.search.SearchEngine;
import org.eclipse.jdt.internal.codeassist.CompletionEngine;
import org.eclipse.jdt.internal.codeassist.ISearchableNameEnvironment;
import org.eclipse.jdt.internal.codeassist.ISelectionRequestor;
import org.eclipse.jdt.internal.codeassist.SelectionEngine;
import org.eclipse.jdt.internal.compiler.env.ISourceType;
import org.eclipse.jdt.internal.core.Assert;
import org.eclipse.jdt.internal.core.BasicCompilationUnit;
import org.eclipse.jdt.internal.core.CompletionRequestorWrapper;
import org.eclipse.jdt.internal.core.CreateFieldOperation;
import org.eclipse.jdt.internal.core.CreateInitializerOperation;
import org.eclipse.jdt.internal.core.CreateMethodOperation;
import org.eclipse.jdt.internal.core.CreateTypeHierarchyOperation;
import org.eclipse.jdt.internal.core.CreateTypeOperation;
import org.eclipse.jdt.internal.core.Initializer;
import org.eclipse.jdt.internal.core.JavaElement;
import org.eclipse.jdt.internal.core.JavaProject;
import org.eclipse.jdt.internal.core.Member;
import org.eclipse.jdt.internal.core.NameLookup;
import org.eclipse.jdt.internal.core.SearchableEnvironment;
import org.eclipse.jdt.internal.core.SourceField;
import org.eclipse.jdt.internal.core.SourceMethod;
import org.eclipse.jdt.internal.core.SourceType;
import org.eclipse.jdt.internal.core.SourceTypeElementInfo;
import org.eclipse.jdt.internal.core.Util;
import org.eclipse.jdt.internal.core.hierarchy.TypeHierarchy;

public class SourceType
extends Member
implements IType {
    protected static final String[] fgEmptyList = new String[0];

    protected SourceType(IJavaElement parent, String name) {
        super(7, parent, name);
        Assert.isTrue(name.indexOf(46) == -1);
    }

    public void codeComplete(char[] snippet, int insertion, int position, char[][] localVariableTypeNames, char[][] localVariableNames, int[] localVariableModifiers, boolean isStatic, ICompletionRequestor requestor) throws JavaModelException {
        if (requestor == null) {
            throw new IllegalArgumentException(Util.bind("codeAssist.nullRequestor"));
        }
        JavaProject project = (JavaProject)this.getJavaProject();
        SearchableEnvironment environment = (SearchableEnvironment)project.getSearchableNameEnvironment();
        NameLookup nameLookup = project.getNameLookup();
        CompletionEngine engine = new CompletionEngine(environment, new CompletionRequestorWrapper(requestor, nameLookup), project.getOptions(true), project);
        String source = this.getCompilationUnit().getSource();
        if (source != null && insertion > -1 && insertion < source.length()) {
            String encoding = project.getOption("org.eclipse.jdt.core.encoding", true);
            char[] prefix = CharOperation.concat(source.substring(0, insertion).toCharArray(), new char[]{'{'});
            char[] suffix = CharOperation.concat(new char[]{'}'}, source.substring(insertion).toCharArray());
            char[] fakeSource = CharOperation.concat(prefix, snippet, suffix);
            BasicCompilationUnit cu = new BasicCompilationUnit(fakeSource, null, this.getElementName(), encoding);
            engine.complete(cu, prefix.length + position, prefix.length);
        } else {
            engine.complete(this, snippet, position, localVariableTypeNames, localVariableNames, localVariableModifiers, isStatic);
        }
    }

    public IField createField(String contents, IJavaElement sibling, boolean force, IProgressMonitor monitor) throws JavaModelException {
        CreateFieldOperation op = new CreateFieldOperation(this, contents, force);
        if (sibling != null) {
            op.createBefore(sibling);
        }
        JavaElement.runOperation(op, monitor);
        return (IField)op.getResultElements()[0];
    }

    public IInitializer createInitializer(String contents, IJavaElement sibling, IProgressMonitor monitor) throws JavaModelException {
        CreateInitializerOperation op = new CreateInitializerOperation(this, contents);
        if (sibling != null) {
            op.createBefore(sibling);
        }
        JavaElement.runOperation(op, monitor);
        return (IInitializer)op.getResultElements()[0];
    }

    public IMethod createMethod(String contents, IJavaElement sibling, boolean force, IProgressMonitor monitor) throws JavaModelException {
        CreateMethodOperation op = new CreateMethodOperation(this, contents, force);
        if (sibling != null) {
            op.createBefore(sibling);
        }
        JavaElement.runOperation(op, monitor);
        return (IMethod)op.getResultElements()[0];
    }

    public IType createType(String contents, IJavaElement sibling, boolean force, IProgressMonitor monitor) throws JavaModelException {
        CreateTypeOperation op = new CreateTypeOperation(this, contents, force);
        if (sibling != null) {
            op.createBefore(sibling);
        }
        JavaElement.runOperation(op, monitor);
        return (IType)op.getResultElements()[0];
    }

    protected boolean equalsDOMNode(IDOMNode node) throws JavaModelException {
        return node.getNodeType() == 4 && super.equalsDOMNode(node);
    }

    public IMethod[] findMethods(IMethod method) {
        try {
            return this.findMethods(method, this.getMethods());
        }
        catch (JavaModelException javaModelException) {
            return null;
        }
    }

    public IType getDeclaringType() {
        for (IJavaElement parent = this.getParent(); parent != null; parent = parent.getParent()) {
            if (parent.getElementType() == 7) {
                return (IType)parent;
            }
            if (parent instanceof IMember) {
                continue;
            }
            return null;
        }
        return null;
    }

    public IField getField(String name) {
        return new SourceField(this, name);
    }

    public IField[] getFields() throws JavaModelException {
        ArrayList list = this.getChildrenOfType(8);
        IField[] array = new IField[list.size()];
        list.toArray(array);
        return array;
    }

    public String getFullyQualifiedName() {
        return this.getFullyQualifiedName('$');
    }

    public String getFullyQualifiedName(char enclosingTypeSeparator) {
        String packageName = this.getPackageFragment().getElementName();
        if (packageName.equals("")) {
            return this.getTypeQualifiedName(enclosingTypeSeparator);
        }
        return String.valueOf(packageName) + '.' + this.getTypeQualifiedName(enclosingTypeSeparator);
    }

    public IInitializer getInitializer(int occurrenceCount) {
        return new Initializer(this, occurrenceCount);
    }

    public IInitializer[] getInitializers() throws JavaModelException {
        ArrayList list = this.getChildrenOfType(10);
        IInitializer[] array = new IInitializer[list.size()];
        list.toArray(array);
        return array;
    }

    public IMethod getMethod(String name, String[] parameterTypeSignatures) {
        return new SourceMethod(this, name, parameterTypeSignatures);
    }

    public IMethod[] getMethods() throws JavaModelException {
        ArrayList list = this.getChildrenOfType(9);
        IMethod[] array = new IMethod[list.size()];
        list.toArray(array);
        return array;
    }

    public IPackageFragment getPackageFragment() {
        IJavaElement parent = this.fParent;
        while (parent != null) {
            if (parent.getElementType() == 4) {
                return (IPackageFragment)parent;
            }
            parent = parent.getParent();
        }
        Assert.isTrue(false);
        return null;
    }

    public String getSuperclassName() throws JavaModelException {
        SourceTypeElementInfo info = (SourceTypeElementInfo)this.getElementInfo();
        char[] superclassName = info.getSuperclassName();
        if (superclassName == null) {
            return null;
        }
        return new String(superclassName);
    }

    public String[] getSuperInterfaceNames() throws JavaModelException {
        SourceTypeElementInfo info = (SourceTypeElementInfo)this.getElementInfo();
        char[][] names = info.getInterfaceNames();
        if (names == null) {
            return fgEmptyList;
        }
        String[] strings = new String[names.length];
        int i = 0;
        while (i < names.length) {
            strings[i] = new String(names[i]);
            ++i;
        }
        return strings;
    }

    public IType getType(String name) {
        return new SourceType(this, name);
    }

    public String getTypeQualifiedName() {
        return this.getTypeQualifiedName('$');
    }

    public String getTypeQualifiedName(char enclosingTypeSeparator) {
        if (this.fParent.getElementType() == 5) {
            return this.fName;
        }
        return String.valueOf(((IType)this.fParent).getTypeQualifiedName(enclosingTypeSeparator)) + enclosingTypeSeparator + this.fName;
    }

    public IType[] getTypes() throws JavaModelException {
        ArrayList list = this.getChildrenOfType(7);
        IType[] array = new IType[list.size()];
        list.toArray(array);
        return array;
    }

    public boolean hasChildren() throws JavaModelException {
        return this.getChildren().length > 0;
    }

    public boolean isAnonymous() throws JavaModelException {
        return false;
    }

    public boolean isClass() throws JavaModelException {
        return !this.isInterface();
    }

    public boolean isInterface() throws JavaModelException {
        SourceTypeElementInfo info = (SourceTypeElementInfo)this.getElementInfo();
        return info.isInterface();
    }

    public boolean isLocal() throws JavaModelException {
        return false;
    }

    public boolean isMember() throws JavaModelException {
        return this.getDeclaringType() != null;
    }

    public ITypeHierarchy loadTypeHierachy(InputStream input, IProgressMonitor monitor) throws JavaModelException {
        return TypeHierarchy.load(this, input);
    }

    public ITypeHierarchy newSupertypeHierarchy(IProgressMonitor monitor) throws JavaModelException {
        return this.newSupertypeHierarchy(null, monitor);
    }

    public ITypeHierarchy newSupertypeHierarchy(IWorkingCopy[] workingCopies, IProgressMonitor monitor) throws JavaModelException {
        CreateTypeHierarchyOperation op = new CreateTypeHierarchyOperation((IType)this, workingCopies, SearchEngine.createWorkspaceScope(), false);
        JavaElement.runOperation(op, monitor);
        return op.getResult();
    }

    public ITypeHierarchy newTypeHierarchy(IProgressMonitor monitor) throws JavaModelException {
        return this.newTypeHierarchy((IWorkingCopy[])null, monitor);
    }

    public ITypeHierarchy newTypeHierarchy(IWorkingCopy[] workingCopies, IProgressMonitor monitor) throws JavaModelException {
        CreateTypeHierarchyOperation op = new CreateTypeHierarchyOperation((IType)this, workingCopies, SearchEngine.createWorkspaceScope(), true);
        JavaElement.runOperation(op, monitor);
        return op.getResult();
    }

    public ITypeHierarchy newTypeHierarchy(IJavaProject project, IProgressMonitor monitor) throws JavaModelException {
        if (project == null) {
            throw new IllegalArgumentException(Util.bind("hierarchy.nullProject"));
        }
        CreateTypeHierarchyOperation op = new CreateTypeHierarchyOperation((IType)this, null, project, true);
        JavaElement.runOperation(op, monitor);
        return op.getResult();
    }

    public String[][] resolveType(String typeName) throws JavaModelException {
        ISourceType info = (ISourceType)this.getElementInfo();
        ISearchableNameEnvironment environment = ((JavaProject)this.getJavaProject()).getSearchableNameEnvironment();
        class TypeResolveRequestor
        implements ISelectionRequestor {
            String[][] answers;

            TypeResolveRequestor() {
                this.answers = null;
            }

            void acceptType(String[] answer) {
                if (this.answers == null) {
                    this.answers = new String[][]{answer};
                } else {
                    int length = this.answers.length;
                    this.answers = new String[length + 1][];
                    System.arraycopy(this.answers, 0, this.answers, 0, length);
                    this.answers[length] = answer;
                }
            }

            public void acceptClass(char[] packageName, char[] className, boolean needQualification) {
                this.acceptType(new String[]{new String(packageName), new String(className)});
            }

            public void acceptInterface(char[] packageName, char[] interfaceName, boolean needQualification) {
                this.acceptType(new String[]{new String(packageName), new String(interfaceName)});
            }

            public void acceptError(IProblem error) {
            }

            public void acceptField(char[] declaringTypePackageName, char[] declaringTypeName, char[] name) {
            }

            public void acceptMethod(char[] declaringTypePackageName, char[] declaringTypeName, char[] selector, char[][] parameterPackageNames, char[][] parameterTypeNames, boolean isConstructor) {
            }

            public void acceptPackage(char[] packageName) {
            }
        }
        TypeResolveRequestor requestor = new TypeResolveRequestor();
        SelectionEngine engine = new SelectionEngine(environment, requestor, this.getJavaProject().getOptions(true));
        IType[] topLevelTypes = this.getCompilationUnit().getTypes();
        int length = topLevelTypes.length;
        ISourceType[] topLevelInfos = new ISourceType[length];
        int i = 0;
        while (i < length) {
            topLevelInfos[i] = (ISourceType)((SourceType)topLevelTypes[i]).getElementInfo();
            ++i;
        }
        engine.selectType(info, typeName.toCharArray(), topLevelInfos, false);
        return requestor.answers;
    }

    protected void toStringInfo(int tab, StringBuffer buffer, Object info) {
        buffer.append(this.tabString(tab));
        if (info == null) {
            buffer.append(this.getElementName());
            buffer.append(" (not open)");
        } else if (info == JavaElement.NO_INFO) {
            buffer.append(this.getElementName());
        } else {
            try {
                if (this.isInterface()) {
                    buffer.append("interface ");
                } else {
                    buffer.append("class ");
                }
                buffer.append(this.getElementName());
            }
            catch (JavaModelException javaModelException) {
                buffer.append("<JavaModelException in toString of " + this.getElementName());
            }
        }
    }
}

