/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.components.treeprocessor.variables;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.avalon.framework.activity.Disposable;
import org.apache.avalon.framework.component.Component;
import org.apache.avalon.framework.component.ComponentException;
import org.apache.avalon.framework.component.ComponentManager;
import org.apache.avalon.framework.component.ComponentSelector;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.apache.avalon.framework.thread.ThreadSafe;
import org.apache.cocoon.components.modules.input.InputModule;
import org.apache.cocoon.components.treeprocessor.InvokeContext;
import org.apache.cocoon.components.treeprocessor.variables.VariableResolver;
import org.apache.cocoon.sitemap.PatternException;

public final class PreparedVariableResolver
extends VariableResolver
implements Disposable {
    private ComponentManager manager;
    private ComponentSelector selector;
    private final List items = new ArrayList();
    static final int ROOT = 0;
    static final int ANCHOR = -1;
    static final int LITERAL = -2;
    static final int THREADSAFE_MODULE = -3;
    static final int STATEFUL_MODULE = -4;
    private static final Integer ROOT_OBJ = new Integer(0);
    private static final Integer LITERAL_OBJ = new Integer(-2);
    private static final Integer THREADSAFE_MODULE_OBJ = new Integer(-3);
    private static final Integer STATEFUL_MODULE_OBJ = new Integer(-4);
    private static final Integer ANCHOR_OBJ = new Integer(-1);

    public PreparedVariableResolver(String expr, ComponentManager manager) throws PatternException {
        super(expr);
        this.manager = manager;
        int length = expr.length();
        int prev = 0;
        while (prev < length) {
            int end;
            int pos = prev;
            while (pos < length && (pos = expr.indexOf(123, pos)) != -1 && pos != 0 && expr.charAt(pos - 1) == '\\') {
                ++pos;
            }
            if (pos >= length || pos == -1) {
                if (prev >= length) break;
                this.addLiteral(expr.substring(prev));
                break;
            }
            if (prev < ++pos - 1) {
                this.addLiteral(expr.substring(prev, pos - 1));
            }
            if ((end = expr.indexOf(125, pos)) == -1) {
                throw new PatternException("Unmatched '{' in " + expr);
            }
            int colon = expr.indexOf(58, pos);
            if (colon != -1 && colon < end) {
                if (expr.startsWith("sitemap:", pos)) {
                    String variable = expr.substring(pos + "sitemap:".length(), end);
                    this.addSitemapVariable(variable);
                } else {
                    String module = expr.substring(pos, colon);
                    String variable = expr.substring(colon + 1, end);
                    if (module.startsWith("#")) {
                        this.addAnchorVariable(module.substring(1), variable);
                    } else {
                        this.addModuleVariable(module, variable);
                    }
                }
            } else {
                this.addSitemapVariable(expr.substring(pos, end));
            }
            prev = end + 1;
        }
    }

    private void addLiteral(String litteral) {
        this.items.add(LITERAL_OBJ);
        this.items.add(litteral);
    }

    private void addSitemapVariable(String variable) {
        if (variable.startsWith("/")) {
            this.items.add(ROOT_OBJ);
            this.items.add(variable.substring(1));
        } else {
            int level = 1;
            int pos = 0;
            while (variable.startsWith("../", pos)) {
                ++level;
                pos += "../".length();
            }
            this.items.add(new Integer(level));
            this.items.add(variable.substring(pos));
        }
    }

    private void addAnchorVariable(String anchor, String variable) throws PatternException {
        this.items.add(ANCHOR_OBJ);
        this.items.add(anchor);
        this.items.add(variable);
    }

    private void addModuleVariable(String moduleName, String variable) throws PatternException {
        InputModule module;
        if (this.selector == null) {
            try {
                this.selector = (ComponentSelector)this.manager.lookup(InputModule.ROLE + "Selector");
            }
            catch (ComponentException ce) {
                throw new PatternException("Cannot access input modules selector", ce);
            }
        }
        try {
            module = (InputModule)this.selector.select((Object)moduleName);
        }
        catch (ComponentException ce) {
            throw new PatternException("Cannot get InputModule named '" + moduleName + "' in expression '" + this.originalExpr + "'", ce);
        }
        if (module instanceof ThreadSafe) {
            this.items.add(THREADSAFE_MODULE_OBJ);
            this.items.add(module);
            this.items.add(variable);
        } else {
            this.selector.release((Component)module);
            this.items.add(STATEFUL_MODULE_OBJ);
            this.items.add(moduleName);
            this.items.add(variable);
        }
    }

    public final String resolve(InvokeContext context, Map objectModel) throws PatternException {
        List mapStack = null;
        int stackSize = 0;
        StringBuffer result = new StringBuffer();
        block15: for (int i = 0; i < this.items.size(); ++i) {
            Object value;
            Object key;
            int type = (Integer)this.items.get(i);
            if (type >= -1 && mapStack == null) {
                if (context == null) {
                    throw new PatternException("Need an invoke context to resolve " + this);
                }
                mapStack = context.getMapStack();
                stackSize = mapStack.size();
            }
            if (type > 0) {
                if (type > stackSize) {
                    throw new PatternException("Error while evaluating '" + this.originalExpr + "' : not so many levels");
                }
                key = this.items.get(++i);
                value = ((Map)mapStack.get(stackSize - type)).get(key);
                if (value == null) continue;
                result.append(value);
                continue;
            }
            switch (type) {
                case -2: {
                    result.append(this.items.get(++i));
                    continue block15;
                }
                case 0: {
                    key = this.items.get(++i);
                    value = ((Map)mapStack.get(0)).get(key);
                    if (value == null) continue block15;
                    result.append(value);
                    continue block15;
                }
                case -1: {
                    String name = (String)this.items.get(++i);
                    Object variable = this.items.get(++i);
                    Map levelResult = context.getMapByAnchor(name);
                    if (levelResult == null) {
                        throw new PatternException("Error while evaluating '" + this.originalExpr + "' : no anchor '" + String.valueOf(name) + "' found in context");
                    }
                    Object value2 = levelResult.get(variable);
                    if (value2 == null) continue block15;
                    result.append(value2);
                    continue block15;
                }
                case -3: {
                    InputModule module = (InputModule)this.items.get(++i);
                    Object variable = (String)this.items.get(++i);
                    try {
                        Object value3 = module.getAttribute((String)variable, null, objectModel);
                        if (value3 == null) continue block15;
                        result.append(value3);
                        continue block15;
                    }
                    catch (ConfigurationException confEx) {
                        throw new PatternException("Cannot get variable '" + variable + "' in expression '" + this.originalExpr + "'", confEx);
                    }
                }
                case -4: {
                    Object value2;
                    InputModule module = null;
                    String moduleName = (String)this.items.get(++i);
                    String variableName = (String)this.items.get(++i);
                    try {
                        module = (InputModule)this.selector.select((Object)moduleName);
                        value2 = module.getAttribute(variableName, null, objectModel);
                        if (value2 == null) continue block15;
                        result.append(value2);
                        continue block15;
                    }
                    catch (ComponentException compEx) {
                        throw new PatternException("Cannot get module '" + moduleName + "' in expression '" + this.originalExpr + "'", compEx);
                    }
                    catch (ConfigurationException confEx) {
                        throw new PatternException("Cannot get variable '" + variableName + "' in expression '" + this.originalExpr + "'", confEx);
                    }
                    finally {
                        this.selector.release((Component)module);
                    }
                }
            }
        }
        return result.toString();
    }

    public final void dispose() {
        if (this.selector != null) {
            block7: for (int i = 0; i < this.items.size(); ++i) {
                int type = (Integer)this.items.get(i);
                switch (type) {
                    case 0: {
                        ++i;
                        continue block7;
                    }
                    case -2: {
                        ++i;
                        continue block7;
                    }
                    case -1: {
                        i += 2;
                        continue block7;
                    }
                    case -3: {
                        this.selector.release((Component)((InputModule)this.items.get(++i)));
                        ++i;
                        continue block7;
                    }
                    case -4: {
                        i += 2;
                        continue block7;
                    }
                    default: {
                        ++i;
                    }
                }
            }
            this.manager.release((Component)this.selector);
            this.selector = null;
            this.manager = null;
        }
    }
}

