/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.components.xpointer;

import java.util.HashMap;
import org.apache.avalon.framework.component.ComponentManager;
import org.apache.avalon.framework.logger.Logger;
import org.apache.cocoon.components.source.SourceUtil;
import org.apache.cocoon.xml.XMLConsumer;
import org.apache.excalibur.source.Source;
import org.apache.excalibur.xml.xpath.PrefixResolver;
import org.w3c.dom.Document;
import org.xml.sax.SAXException;

public class XPointerContext
implements PrefixResolver {
    private Source source;
    private Document document;
    private XMLConsumer xmlConsumer;
    private Logger logger;
    private String xpointer;
    private HashMap prefixes = new HashMap();
    private ComponentManager componentManager;

    public XPointerContext(String xpointer, Source source, XMLConsumer xmlConsumer, Logger logger, ComponentManager componentManager) {
        this.source = source;
        this.xmlConsumer = xmlConsumer;
        this.logger = logger;
        this.componentManager = componentManager;
        this.xpointer = xpointer;
        this.prefixes.put("xml", "http://www.w3.org/XML/1998/namespace");
    }

    public Document getDocument() throws SAXException {
        if (this.document == null) {
            try {
                this.document = SourceUtil.toDOM(this.source);
            }
            catch (Exception e) {
                throw new SAXException("Error during XPointer evaluation while trying to load " + this.source.getURI(), e);
            }
        }
        return this.document;
    }

    public Source getSource() {
        return this.source;
    }

    public XMLConsumer getXmlConsumer() {
        return this.xmlConsumer;
    }

    public Logger getLogger() {
        return this.logger;
    }

    public String getXPointer() {
        return this.xpointer;
    }

    public ComponentManager getComponentManager() {
        return this.componentManager;
    }

    public void addPrefix(String prefix, String namespace) throws SAXException {
        if (prefix.equalsIgnoreCase("xml")) {
            return;
        }
        if (prefix.equals("xmlns")) {
            return;
        }
        if (namespace.equals("http://www.w3.org/XML/1998/namespace")) {
            return;
        }
        if (namespace.equals("http://www.w3.org/2000/xmlns/")) {
            return;
        }
        this.prefixes.put(prefix, namespace);
    }

    public String prefixToNamespace(String prefix) {
        return (String)this.prefixes.get(prefix);
    }
}

