/* Copyright 2005 by Stefan Thesing
<p>This program is free software; you can 
redistribute it and/or modify it under the terms 
of the GNU General Public License as published by 
the Free Software Foundation; either version 2 of 
the License, or (at your option) any later version.</p>
<p>This program is distributed in the hope that it 
will be useful, but WITHOUT ANY WARRANTY; without 
even the implied warranty of MERCHANTABILITY or 
FITNESS FOR A PARTICULAR PURPOSE.  See the GNU 
General Public License for more details.</p>
<p>You should have received a copy of the GNU 
General Public License along with this program; 
if not, write to the <br>
Free Software Foundation, Inc.,<br>
51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA.<br>
*/
package de.webdings.tools;


/**
 * CharToFloat is used to convert textual representations
 * of float numbers to the primitive data type float.
 * 
 * @author Copyright 2005 by Stefan Thesing
 * Website: <a href="http://www.webdings.de">http://www.webdings.de</a>
 * @version 1.0 Created on 23.05.2005
 * 
 */
public class CharToFloat {
    /**
     * @param s A String representation of a float number
     * @return float value of the represented number
     */
    public static float convert(String s) 
    {
        Float f = new Float(s);
        return f.floatValue();
    }

    /**
     * @param c A char array representation of a float number
     * @return float value of the represented number
     */
    public static float convert(char[] c)
    {
       int i;
       String s = new String();
       for(i=0;i<c.length;++i)
       {
         s = s + c[i];
       }
       return convert(s);
    }
    
    /**
     * @param s StringBuffer representation of a float number
     * @return float value of the represented number
     */
    public static float convert(StringBuffer s)
    {
        return convert(new String(s));
    }
    
}
