/* Copyright 2005 by Stefan Thesing
<p>This program is free software; you can 
redistribute it and/or modify it under the terms 
of the GNU General Public License as published by 
the Free Software Foundation; either version 2 of 
the License, or (at your option) any later version.</p>
<p>This program is distributed in the hope that it 
will be useful, but WITHOUT ANY WARRANTY; without 
even the implied warranty of MERCHANTABILITY or 
FITNESS FOR A PARTICULAR PURPOSE.  See the GNU 
General Public License for more details.</p>
<p>You should have received a copy of the GNU 
General Public License along with this program; 
if not, write to the <br>
Free Software Foundation, Inc.,<br>
51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA.<br>
*/
package de.webdings.tools.files;

import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;

/**
 * TextFiles is used to write and read text files from and
 * to strings.
 * 
 * @author Copyright 2005 by Stefan Thesing
 * Website: <a href="http://www.webdings.de">http://www.webdings.de</a>
 * @version 1.0 Modified on 26.05.2005
 */
public class TextFiles {
    /**
     * Writes a specified String to a text file
     * with a specified file name.
     * @param fileName Name of the text file
     * @param content content to be written
     * @throws IOException
     */
    public static void writeToFile(String fileName, String content) throws IOException {
        File f = new File(fileName);
        FileWriter w = new FileWriter(f);
        w.write(content);
        w.close();
    }
    /**
     * Reads the contents of the specified file
     * and returns it as a String
     * @param fileName Name of the file to be read
     * @return the contents of the file as a String
     * @throws Exception
     */
    public static String readFromFile(String fileName) throws Exception
    {    
            File f = new File(fileName);
            int fileSize = (int) f.length();
            int chars_gelesen = 0;
            FileReader r = new FileReader(f);
            char[] buffer = new char[fileSize];
            while (r.ready())
            {
                chars_gelesen +=
                r.read(buffer, chars_gelesen, 
                        fileSize - chars_gelesen);
            }
            r.close();
            String s = new String(buffer, 0, chars_gelesen);
            return s;
    }
}
