/* EasyDateCreateException.java - Copyright (c) 2005 by Stefan Thesing
 <p>This file is part of Webdings Tools.</p>
 <p>Webdings Tools is free software; you can redistribute it and/or modify
 it under the terms of the GNU General Public License as published by
 the Free Software Foundation; either version 2 of the License, or
 (at your option) any later version.</p>
<p>Webdings Tools is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.</p>
<p>You should have received a copy of the GNU General Public License
along with Webdings Tools; if not, write to the<br>
Free Software Foundation, Inc.,<br>
51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA<br>
*/
package de.webdings.tools.time;


/**
 * EasyDateCreateException is used in the contstruction
 * of {@link EasyDate}.
 * Its thrown when an invalid month-value is specified.
 * @author Stefan Thesing<br>
 * Website: <a href="http://www.webdings.de">http://www.webdings.de</a>
 * @version 1.0.1 10.08.2005
 * @see EasyDate
 * 
 */
public class EasyDateCreateException extends java.lang.Exception {
    /**
	 * 
	 */
	private static final long serialVersionUID = -4911661781409420883L;

	public EasyDateCreateException(int month) {
		super("EasyDate could not be created. " + month + " is not a valid month-value. Note that January is represented by 1 not by 0!");
	}
}
