/*
 * Decompiled with CFR 0.152.
 */
package ch.fhnw.jbackpack;

import java.awt.Cursor;
import java.awt.Desktop;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.net.URISyntaxException;
import java.net.URL;
import java.text.MessageFormat;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.LayoutStyle;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;

public class AboutDialog
extends JDialog {
    private static final Logger LOGGER = Logger.getLogger(AboutDialog.class.getName());
    private JEditorPane creditsEditorPane;
    private JScrollPane creditsScrollPane;
    private JEditorPane licenseEditorPane;
    private JScrollPane licenseScrollPane;
    private JButton okButton;
    private JPanel okButtonPanel;
    private JTabbedPane tabbedPane;
    private JLabel versionLabel;

    public AboutDialog(Frame parent) {
        super(parent, true);
        this.initComponents();
        ResourceBundle bundle = ResourceBundle.getBundle("ch/fhnw/jbackpack/Strings");
        String versionString = bundle.getString("JBackpack_Version");
        String title = MessageFormat.format(bundle.getString("ProgramTitle"), versionString);
        this.versionLabel.setText(title);
        Class<?> thisClass = this.getClass();
        String aboutFileName = bundle.getString("About_Message_File");
        URL fileURL = thisClass.getResource(aboutFileName);
        try {
            this.creditsEditorPane.setPage(fileURL);
        }
        catch (IOException ex) {
            LOGGER.log(Level.SEVERE, "could not load file with \"about\" info", ex);
        }
        String licenseFileName = bundle.getString("License_File");
        fileURL = thisClass.getResource(licenseFileName);
        try {
            this.licenseEditorPane.setPage(fileURL);
        }
        catch (IOException ex) {
            LOGGER.log(Level.SEVERE, "could not load license file", ex);
        }
        this.setLocationRelativeTo(parent);
    }

    private void initComponents() {
        this.versionLabel = new JLabel();
        this.tabbedPane = new JTabbedPane();
        this.creditsScrollPane = new JScrollPane();
        this.creditsEditorPane = new JEditorPane();
        this.licenseScrollPane = new JScrollPane();
        this.licenseEditorPane = new JEditorPane();
        this.okButtonPanel = new JPanel();
        this.okButton = new JButton();
        this.setDefaultCloseOperation(2);
        ResourceBundle bundle = ResourceBundle.getBundle("ch/fhnw/jbackpack/Strings");
        this.setTitle(bundle.getString("AboutDialog.title"));
        this.versionLabel.setHorizontalAlignment(0);
        this.versionLabel.setIcon(new ImageIcon(this.getClass().getResource("/ch/fhnw/jbackpack/icons/64x64/backpack.png")));
        this.versionLabel.setText(bundle.getString("ProgramTitle"));
        this.creditsEditorPane.setContentType(bundle.getString("AboutDialog.creditsEditorPane.contentType"));
        this.creditsEditorPane.setEditable(false);
        this.creditsEditorPane.addHyperlinkListener(new HyperlinkListener(){

            public void hyperlinkUpdate(HyperlinkEvent evt) {
                AboutDialog.this.creditsEditorPaneHyperlinkUpdate(evt);
            }
        });
        this.creditsScrollPane.setViewportView(this.creditsEditorPane);
        this.tabbedPane.addTab(bundle.getString("AboutDialog.creditsScrollPane.TabConstraints.tabTitle"), this.creditsScrollPane);
        this.licenseEditorPane.setContentType(bundle.getString("AboutDialog.licenseEditorPane.contentType"));
        this.licenseEditorPane.setEditable(false);
        this.licenseEditorPane.addHyperlinkListener(new HyperlinkListener(){

            public void hyperlinkUpdate(HyperlinkEvent evt) {
                AboutDialog.this.licenseEditorPaneHyperlinkUpdate(evt);
            }
        });
        this.licenseScrollPane.setViewportView(this.licenseEditorPane);
        this.tabbedPane.addTab(bundle.getString("AboutDialog.licenseScrollPane.TabConstraints.tabTitle"), this.licenseScrollPane);
        this.okButton.setText(bundle.getString("AboutDialog.okButton.text"));
        this.okButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                AboutDialog.this.okButtonActionPerformed(evt);
            }
        });
        this.okButtonPanel.add(this.okButton);
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.tabbedPane, GroupLayout.Alignment.LEADING, -1, 510, Short.MAX_VALUE).addComponent(this.okButtonPanel, GroupLayout.Alignment.LEADING, -1, 510, Short.MAX_VALUE).addComponent(this.versionLabel, GroupLayout.Alignment.LEADING, -1, 510, Short.MAX_VALUE)).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addContainerGap().addComponent(this.versionLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.tabbedPane, -1, 300, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.okButtonPanel, -2, -1, -2).addContainerGap()));
        this.pack();
    }

    private void licenseEditorPaneHyperlinkUpdate(HyperlinkEvent evt) {
        this.openLink(evt);
    }

    private void creditsEditorPaneHyperlinkUpdate(HyperlinkEvent evt) {
        this.openLink(evt);
    }

    private void openLink(HyperlinkEvent hyperlinkEvent) {
        if (hyperlinkEvent.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
            try {
                Desktop.getDesktop().browse(hyperlinkEvent.getURL().toURI());
            }
            catch (URISyntaxException ex) {
                LOGGER.log(Level.SEVERE, null, ex);
            }
            catch (IOException ex) {
                LOGGER.log(Level.SEVERE, null, ex);
            }
            final JEditorPane source = (JEditorPane)hyperlinkEvent.getSource();
            Thread guiThread = new Thread(){

                public void run() {
                    source.setEnabled(false);
                    AboutDialog.this.setCursor(Cursor.getPredefinedCursor(3));
                    try {
                        Thread.sleep(4000L);
                    }
                    catch (InterruptedException ex) {
                        LOGGER.log(Level.SEVERE, null, ex);
                    }
                    source.setEnabled(true);
                    AboutDialog.this.setCursor(Cursor.getPredefinedCursor(0));
                }
            };
            guiThread.start();
        }
    }

    private void okButtonActionPerformed(ActionEvent evt) {
        this.dispose();
        this.setVisible(false);
    }
}

