/*
 * Decompiled with CFR 0.152.
 */
package ch.fhnw.jbackpack;

import ch.fhnw.jbackpack.BackupMainPanel;
import ch.fhnw.jbackpack.IconManager;
import ch.fhnw.jbackpack.ProgressDialog;
import ch.fhnw.util.FileTools;
import ch.fhnw.util.ModalDialogHandler;
import ch.fhnw.util.ProcessExecutor;
import java.awt.Frame;
import java.awt.Window;
import java.io.File;
import java.util.ResourceBundle;
import java.util.concurrent.ExecutionException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JOptionPane;
import javax.swing.SwingWorker;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DecryptionFinishSwingWorker
extends SwingWorker<Boolean, Void> {
    private static final Logger LOGGER = Logger.getLogger(DecryptionFinishSwingWorker.class.getName());
    private static final ResourceBundle BUNDLE = ResourceBundle.getBundle("ch/fhnw/jbackpack/Strings");
    private final Frame parentFrame;
    private final BackupMainPanel backupMainPanel;
    private final File cipherDir;
    private final File plainMountPoint;
    private final String tmpPlainPath;
    private final ProgressDialog progressDialog;
    private final ModalDialogHandler dialogHandler;
    private final ProcessExecutor processExecutor;

    public DecryptionFinishSwingWorker(Frame parentFrame, BackupMainPanel backupMainPanel, File cipherDir, File plainMountPoint, String tmpPlainPath) {
        this.parentFrame = parentFrame;
        this.backupMainPanel = backupMainPanel;
        this.cipherDir = cipherDir;
        this.plainMountPoint = plainMountPoint;
        this.tmpPlainPath = tmpPlainPath;
        this.processExecutor = new ProcessExecutor();
        this.progressDialog = new ProgressDialog((Window)parentFrame, this.processExecutor);
        this.progressDialog.setIcon(IconManager.INFORMATION_ICON);
        this.progressDialog.setMessage(BUNDLE.getString("Removing_Encrypted_Files"));
        this.progressDialog.setSpecialIcon(null);
        this.progressDialog.setIndeterminate(true);
        this.progressDialog.setCancelButtonVisible(false);
        this.dialogHandler = new ModalDialogHandler(this.progressDialog);
        this.dialogHandler.show();
    }

    @Override
    protected Boolean doInBackground() {
        String cipherPath = this.cipherDir.getPath();
        if (!FileTools.umountFUSE(this.plainMountPoint, true)) {
            return false;
        }
        int returnValue = this.processExecutor.executeProcess("rm", "-rf", cipherPath);
        if (returnValue != 0) {
            LOGGER.log(Level.WARNING, "could not remove {0}", cipherPath);
            return false;
        }
        returnValue = this.processExecutor.executeProcess("mv", this.tmpPlainPath, cipherPath);
        if (returnValue != 0) {
            if (LOGGER.isLoggable(Level.WARNING)) {
                LOGGER.log(Level.WARNING, "could not move {0} to {1}", new Object[]{this.tmpPlainPath, cipherPath});
            }
            return false;
        }
        return true;
    }

    @Override
    protected void done() {
        this.dialogHandler.hide();
        try {
            if (((Boolean)this.get()).booleanValue()) {
                this.backupMainPanel.setDestinationEncrypted(false);
                this.backupMainPanel.setEncfsMountPoint(null);
                this.backupMainPanel.checkDestinationCommon();
                JOptionPane.showMessageDialog(this.parentFrame, BUNDLE.getString("Destination_Decrypted"), BUNDLE.getString("Information"), 1, IconManager.INFORMATION_ICON);
            } else {
                JOptionPane.showMessageDialog(this.parentFrame, BUNDLE.getString("Decryption_Failed"), BUNDLE.getString("Error"), 0);
            }
        }
        catch (InterruptedException ex) {
            LOGGER.log(Level.SEVERE, null, ex);
        }
        catch (ExecutionException ex) {
            LOGGER.log(Level.SEVERE, null, ex);
        }
    }
}

