/*
 * Decompiled with CFR 0.152.
 */
package ch.fhnw.jbackpack;

import ch.fhnw.jbackpack.BackupFrame;
import ch.fhnw.jbackpack.MacOSXSetupHelpFrame;
import ch.fhnw.jbackpack.WindowsSetupHelpFrame;
import ch.fhnw.util.CurrentOperatingSystem;
import ch.fhnw.util.ProcessExecutor;
import java.awt.EventQueue;
import java.awt.SplashScreen;
import java.text.DateFormat;
import java.text.MessageFormat;
import java.util.Date;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.prefs.Preferences;
import javax.swing.JOptionPane;
import javax.swing.UIManager;

public class JBackpack {
    public static final String LAST_BACKUP = "last_backup";
    public static final String SHOW_REMINDER = "show_reminder";
    public static final String REMINDER_TIMEOUT = "reminder_timeout";

    public static void main(String[] args) {
        if (args.length > 0 && "--reminder".equals(args[0])) {
            int returnValue;
            long now;
            int daysSinceLastBackup;
            Preferences preferences = Preferences.userNodeForPackage(JBackpack.class);
            if (!preferences.getBoolean(SHOW_REMINDER, false)) {
                return;
            }
            int reminderTimeout = preferences.getInt(REMINDER_TIMEOUT, Integer.MIN_VALUE);
            if (reminderTimeout == Integer.MIN_VALUE) {
                Logger.getLogger(JBackpack.class.getName()).warning("could not find reminder timeout in preferences!");
                return;
            }
            long lastBackup = preferences.getLong(LAST_BACKUP, Long.MIN_VALUE);
            if (lastBackup == Long.MIN_VALUE) {
                Logger.getLogger(JBackpack.class.getName()).info("no backup timestamp found");
            }
            if ((daysSinceLastBackup = (int)(((now = System.currentTimeMillis()) - lastBackup) / 86400000L)) < reminderTimeout) {
                return;
            }
            JBackpack.setLookAndFeel();
            JBackpack.checkJavaVersion();
            Date lastBackupDate = new Date(lastBackup);
            DateFormat dateFormat = DateFormat.getDateTimeInstance(0, 2);
            String timeString = dateFormat.format(lastBackupDate);
            ResourceBundle bundle = ResourceBundle.getBundle("ch/fhnw/jbackpack/Strings");
            String message = bundle.getString("Reminder_Message");
            message = MessageFormat.format(message, timeString);
            Object[] options = new Object[]{bundle.getString("Start_Backup_Program"), bundle.getString("Cancel")};
            SplashScreen splashScreen = SplashScreen.getSplashScreen();
            if (splashScreen != null) {
                splashScreen.close();
            }
            if ((returnValue = JOptionPane.showOptionDialog(null, message, bundle.getString("Reminder"), 0, 2, null, options, options[0])) == 0) {
                JBackpack.systemCheck();
            }
        } else {
            JBackpack.setLookAndFeel();
            JBackpack.checkJavaVersion();
            JBackpack.systemCheck();
        }
    }

    public static void setLookAndFeel() {
        System.setProperty("awt.useSystemAAFontSettings", "on");
        switch (CurrentOperatingSystem.OS) {
            case Linux: {
                try {
                    UIManager.setLookAndFeel("com.sun.java.swing.plaf.nimbus.NimbusLookAndFeel");
                }
                catch (Exception ex) {
                    Logger.getLogger(JBackpack.class.getName()).log(Level.WARNING, "failed to set look&feel", ex);
                }
                break;
            }
            case Windows: {
                try {
                    UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
                }
                catch (Exception ex) {
                    Logger.getLogger(JBackpack.class.getName()).log(Level.WARNING, "failed to set system look&feel", ex);
                }
                break;
            }
            case Mac_OS_X: {
                System.setProperty("apple.laf.useScreenMenuBar", "true");
            }
        }
    }

    public static void systemCheck() {
        ProcessExecutor processExecutor = new ProcessExecutor();
        int returnValue = processExecutor.executeProcess("rdiff-backup", "--version");
        if (returnValue == 0) {
            EventQueue.invokeLater(new Runnable(){

                public void run() {
                    new BackupFrame().setVisible(true);
                }
            });
        } else {
            Logger.getLogger(JBackpack.class.getName()).log(Level.INFO, "return value of \"rdiff-backup --version\": {0}", returnValue);
            ResourceBundle bundle = ResourceBundle.getBundle("ch/fhnw/jbackpack/Strings");
            switch (CurrentOperatingSystem.OS) {
                case Mac_OS_X: {
                    MacOSXSetupHelpFrame macFrame = new MacOSXSetupHelpFrame();
                    macFrame.setVisible(true);
                    break;
                }
                case Windows: {
                    WindowsSetupHelpFrame frame = new WindowsSetupHelpFrame();
                    frame.setVisible(true);
                    break;
                }
                default: {
                    JOptionPane.showMessageDialog(null, bundle.getString("Error_No_Rdiff-Backup"), bundle.getString("Error"), 0);
                    System.exit(-1);
                }
            }
        }
    }

    private static void checkJavaVersion() {
        String javaVersion = System.getProperty("java.version");
        String[] tokens = javaVersion.split("\\.");
        int majorVersion = Integer.parseInt(tokens[0]);
        int minorVersion = Integer.parseInt(tokens[1]);
        if (majorVersion <= 1 && minorVersion <= 5) {
            ResourceBundle bundle = ResourceBundle.getBundle("ch/fhnw/jbackpack/Strings");
            String errorMessage = bundle.getString("Error_Java_Version");
            Logger.getLogger(JBackpack.class.getName()).log(Level.SEVERE, errorMessage);
            JOptionPane.showMessageDialog(null, errorMessage, bundle.getString("Error"), 0);
            System.exit(-1);
        }
    }
}

