/*
 * Decompiled with CFR 0.152.
 */
package ch.fhnw.jbackpack;

import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Insets;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import javax.swing.JLabel;
import javax.swing.border.Border;

public class JSqueezedLabel
extends JLabel {
    private String originalText;

    public JSqueezedLabel() {
        this.addComponentListener(new ComponentAdapter(){

            public void componentResized(ComponentEvent evt) {
                String squeezedText = JSqueezedLabel.this.squeeze();
                JSqueezedLabel.super.setText(squeezedText);
            }
        });
    }

    public void setText(String text) {
        this.originalText = text;
        String squeezedText = this.squeeze();
        super.setText(squeezedText);
    }

    private String squeeze() {
        String squeezedString;
        if (this.originalText == null) {
            return null;
        }
        Font font = this.getFont();
        if (font == null) {
            return this.originalText;
        }
        FontMetrics fontMetrics = this.getFontMetrics(font);
        int originalWidth = fontMetrics.stringWidth(this.originalText);
        int width = this.getWidth();
        Border border = this.getBorder();
        if (border != null) {
            Insets borderInsets = border.getBorderInsets(this);
            width -= borderInsets.left + borderInsets.right;
        }
        if (originalWidth < width) {
            return this.originalText;
        }
        int originalLength = this.originalText.length();
        int squeezedLength = originalLength * width / originalWidth;
        if (squeezedLength == 0) {
            return ".";
        }
        String dottedString = this.getDottedString(this.originalText, squeezedLength);
        int dottedWidth = fontMetrics.stringWidth(dottedString);
        if (dottedWidth < width) {
            do {
                squeezedString = dottedString;
            } while ((dottedWidth = fontMetrics.stringWidth(dottedString = this.getDottedString(this.originalText, ++squeezedLength))) < width);
        } else {
            do {
                dottedString = this.getDottedString(this.originalText, --squeezedLength);
                dottedWidth = fontMetrics.stringWidth(dottedString);
                squeezedString = dottedString;
            } while (dottedWidth > width && squeezedLength > 0);
        }
        return squeezedString;
    }

    private String getDottedString(String string, int length) {
        int stringLength = string.length();
        if (stringLength < length) {
            return string;
        }
        int halfLength = length / 2;
        return string.substring(0, halfLength) + "..." + string.substring(stringLength - halfLength, stringLength);
    }
}

