/*
 * Decompiled with CFR 0.152.
 */
package ch.fhnw.jbackpack;

import ch.fhnw.jbackpack.chooser.RdiffFile;
import ch.fhnw.util.CurrentOperatingSystem;
import ch.fhnw.util.FileTools;
import ch.fhnw.util.OperatingSystem;
import ch.fhnw.util.ProcessExecutor;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.atomic.AtomicLong;
import java.util.logging.Level;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RdiffBackupRestore {
    private static final Logger LOGGER = Logger.getLogger(RdiffBackupRestore.class.getName());
    private static final String LINE_SEPARATOR = System.getProperty("line.separator");
    private static final String PROCESSING_STRING = "Processing changed file ";
    private static final String APPLYING_PATCH_STRING = "Applying patch ";
    private ScheduledExecutorService scheduler;
    private ProcessExecutor processExecutor;
    private String currentFile;
    private AtomicLong fileCounter = new AtomicLong();
    private AtomicLong restoreCounter = new AtomicLong();
    private RestoreState restoreState;
    private File includesFile;
    private File excludesFile;

    public static String quoteBackup(String baseDirectory, String path) {
        if (CurrentOperatingSystem.OS == OperatingSystem.Windows) {
            String remainder = path.substring(baseDirectory.length());
            baseDirectory = baseDirectory.replace("\\", "\\\\");
            remainder = remainder.replace("\\", "/");
            path = baseDirectory + remainder;
        }
        return path;
    }

    public boolean backupViaFileSystem(File source, File destination, String tempDirPath, String excludes, String includes, boolean compressFiles, Long maxFileSize, Long minFileSize, boolean excludeDeviceFiles, boolean excludeFifos, boolean excludeOtherFileSystems, boolean excludeSockets, boolean excludeSymlinks) throws IOException {
        List<String> commandList = this.createBackupCommandList(source, includes, excludes, tempDirPath, maxFileSize, minFileSize, compressFiles, excludeDeviceFiles, excludeFifos, excludeOtherFileSystems, excludeSockets, excludeSymlinks);
        commandList.add(destination.getPath());
        String[] commandArray = new String[commandList.size()];
        commandArray = commandList.toArray(commandArray);
        int returnValue = this.processExecutor.executeProcess(false, true, commandArray);
        this.deleteIncludeExcludeFiles();
        return returnValue == 0;
    }

    public boolean backupViaSSH(File source, String user, String host, String directory, String password, String tempDirPath, String excludes, String includes, boolean compressFiles, Long maxFileSize, Long minFileSize, boolean excludeDeviceFiles, boolean excludeFifos, boolean excludeOtherFileSystems, boolean excludeSockets, boolean excludeSymlinks) throws IOException {
        List<String> commandList = this.createBackupCommandList(source, includes, excludes, tempDirPath, maxFileSize, minFileSize, compressFiles, excludeDeviceFiles, excludeFifos, excludeOtherFileSystems, excludeSockets, excludeSymlinks);
        commandList.add(user + '@' + host + "::" + directory);
        StringBuilder stringBuilder = new StringBuilder();
        for (String command : commandList) {
            stringBuilder.append(command);
            stringBuilder.append(' ');
        }
        String backupScript = "#!/usr/bin/expect -f" + LINE_SEPARATOR + "set password [lindex $argv 0]" + LINE_SEPARATOR + "spawn -ignore HUP " + stringBuilder.toString() + LINE_SEPARATOR + "while 1 {" + LINE_SEPARATOR + "    expect {" + LINE_SEPARATOR + "        eof {" + LINE_SEPARATOR + "            break" + LINE_SEPARATOR + "        }" + LINE_SEPARATOR + "        \"continue connecting*\" {" + LINE_SEPARATOR + "            send \"yes\r\"" + LINE_SEPARATOR + "        }" + LINE_SEPARATOR + "        \"" + user + '@' + host + "'s password:\" {" + LINE_SEPARATOR + "            send \"$password\r\"" + LINE_SEPARATOR + "        }" + LINE_SEPARATOR + "    }" + LINE_SEPARATOR + "}" + LINE_SEPARATOR + "set ret [lindex [wait] 3]" + LINE_SEPARATOR + "puts \"return value: $ret\"" + LINE_SEPARATOR + "exit $ret";
        int returnValue = this.processExecutor.executeScript(false, true, backupScript, password);
        this.deleteIncludeExcludeFiles();
        return returnValue == 0;
    }

    public boolean restore(String rdiffTimestamp, RdiffFile[] selectedFiles, File backupDirectory, File restoreDirectory, String tempDirPath, boolean countFiles) throws IOException {
        boolean success;
        this.processExecutor = new ProcessExecutor();
        this.currentFile = "";
        this.fileCounter.set(0L);
        this.restoreCounter.set(0L);
        if (countFiles) {
            this.restoreState = RestoreState.Counting;
            for (RdiffFile selectedFile : selectedFiles) {
                this.countRestoreFiles(selectedFile);
            }
        }
        this.restoreState = RestoreState.Restoring;
        this.processExecutor.addPropertyChangeListener(new MyPropertyChangeListener());
        String restorePath = restoreDirectory.getPath();
        String includes = null;
        String excludes = null;
        this.includesFile = null;
        this.excludesFile = null;
        if (selectedFiles.length != 1 || selectedFiles[0].getParentFile() != null) {
            StringBuilder stringBuilder = new StringBuilder();
            int length = selectedFiles.length;
            for (int i = 0; i < length; ++i) {
                File realFile;
                RdiffFile selectedFile = selectedFiles[i];
                if (CurrentOperatingSystem.OS == OperatingSystem.Windows && (realFile = new File(restoreDirectory, selectedFile.getPath())).exists() && !FileTools.recursiveDelete(realFile, true)) {
                    LOGGER.log(Level.WARNING, "could not delete {0}", realFile);
                }
                stringBuilder.append(RdiffBackupRestore.quoteRestore(restorePath));
                stringBuilder.append('/');
                if (selectedFile.getParentFile() == null) {
                    stringBuilder.append("*");
                } else {
                    String absolutePath = selectedFile.getAbsolutePath();
                    stringBuilder.append(RdiffBackupRestore.quoteRestore(absolutePath));
                }
                if (i == length - 1) continue;
                stringBuilder.append(LINE_SEPARATOR);
            }
            includes = stringBuilder.toString();
            excludes = RdiffBackupRestore.quoteRestore(restorePath) + "/**";
            this.includesFile = File.createTempFile("jbackpack_includes_", null);
            this.excludesFile = File.createTempFile("jbackpack_excludes_", null);
        }
        List<String> commandList = this.createCommandList(tempDirPath, this.includesFile, includes, this.excludesFile, excludes);
        commandList.add("--force");
        commandList.add("-r");
        commandList.add(rdiffTimestamp);
        commandList.add(backupDirectory.getPath());
        commandList.add(RdiffBackupRestore.quoteRestorePath(restorePath));
        String[] commandArray = new String[commandList.size()];
        commandArray = commandList.toArray(commandArray);
        int returnValue = this.processExecutor.executeProcess(false, true, commandArray);
        boolean bl = success = returnValue == 0;
        if (success) {
            if (this.includesFile != null && !this.includesFile.delete()) {
                LOGGER.log(Level.WARNING, "could not delete {0}", this.includesFile);
            }
            if (this.excludesFile != null && !this.excludesFile.delete()) {
                LOGGER.log(Level.WARNING, "could not delete {0}", this.excludesFile);
            }
        }
        return success;
    }

    public RestoreState getRestoreState() {
        return this.restoreState;
    }

    public long getRestoreCounter() {
        return this.restoreCounter.get();
    }

    public void cancelRdiffOperation() {
        if (this.processExecutor != null) {
            this.processExecutor.destroy();
        }
        if (this.scheduler != null) {
            this.scheduler.shutdown();
        }
    }

    public String getCurrentFile() {
        return this.currentFile;
    }

    public long getFileCounter() {
        return this.fileCounter.get();
    }

    public String getStdOut() {
        return this.processExecutor.getStdOut();
    }

    public String getStdErr() {
        return this.processExecutor.getStdErr();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getBackupSessionStatistics(String backupDirectory) {
        HashMap<String, String> sessionStatistics = new HashMap<String, String>();
        String sessionName = "session_statistics" + this.getCurrentMirror(backupDirectory).getName().replaceAll("current_mirror", "");
        InputStreamReader fileReader = null;
        BufferedReader bufferedReader = null;
        try {
            String line;
            fileReader = new FileReader(backupDirectory + File.separator + "rdiff-backup-data" + File.separator + sessionName);
            if (LOGGER.isLoggable(Level.INFO)) {
                LOGGER.log(Level.INFO, "Reading statistics data from:{0}{1}rdiff-backup-data{2}{3}", new Object[]{backupDirectory, File.separator, File.separator, sessionName});
            }
            bufferedReader = new BufferedReader(fileReader);
            while ((line = bufferedReader.readLine()) != null) {
                String[] tokens = line.split(" ");
                if (tokens.length <= 1) continue;
                if (LOGGER.isLoggable(Level.INFO)) {
                    LOGGER.log(Level.INFO, "Storing (key,value):{0},{1}", new Object[]{tokens[0], tokens[1]});
                }
                sessionStatistics.put(tokens[0], tokens[1]);
            }
        }
        catch (IOException ex) {
            LOGGER.log(Level.INFO, "could not load increment size", ex);
        }
        finally {
            if (fileReader != null) {
                try {
                    fileReader.close();
                }
                catch (IOException ex) {
                    LOGGER.log(Level.SEVERE, null, ex);
                }
            }
            if (bufferedReader != null) {
                try {
                    bufferedReader.close();
                }
                catch (IOException ex) {
                    LOGGER.log(Level.SEVERE, null, ex);
                }
            }
        }
        return sessionStatistics;
    }

    private List<String> createBackupCommandList(File source, String includes, String excludes, String tempDirPath, Long maxFileSize, Long minFileSize, boolean compressFiles, boolean excludeDeviceFiles, boolean excludeFifos, boolean excludeOtherFileSystems, boolean excludeSockets, boolean excludeSymlinks) throws IOException {
        this.processExecutor = new ProcessExecutor();
        this.currentFile = "";
        this.fileCounter.set(0L);
        this.processExecutor.addPropertyChangeListener(new MyPropertyChangeListener());
        this.includesFile = includes != null && includes.length() > 0 ? File.createTempFile("jbackpack_includes_", null) : null;
        this.excludesFile = excludes != null && excludes.length() > 0 ? File.createTempFile("jbackpack_excludes_", null) : null;
        List<String> commandList = this.createCommandList(tempDirPath, this.includesFile, includes, this.excludesFile, excludes);
        if (maxFileSize != null) {
            commandList.add("--max-file-size");
            commandList.add(String.valueOf(maxFileSize));
        }
        if (minFileSize != null) {
            commandList.add("--min-file-size");
            commandList.add(String.valueOf(minFileSize));
        }
        if (excludeDeviceFiles) {
            commandList.add("--exclude-device-files");
        }
        if (excludeFifos) {
            commandList.add("--exclude-fifos");
        }
        if (excludeOtherFileSystems) {
            commandList.add("--exclude-other-filesystems");
        }
        if (excludeSockets) {
            commandList.add("--exclude-sockets");
        }
        if (excludeSymlinks) {
            commandList.add("--exclude-symbolic-links");
        }
        if (!compressFiles) {
            commandList.add("--no-compression");
        }
        String sourcePath = source.getPath();
        if (CurrentOperatingSystem.OS == OperatingSystem.Windows) {
            sourcePath = sourcePath + '/';
        }
        commandList.add(sourcePath);
        return commandList;
    }

    private void deleteIncludeExcludeFiles() {
        if (this.includesFile != null && !this.includesFile.delete()) {
            LOGGER.log(Level.WARNING, "could not delete {0}", this.includesFile);
        }
        if (this.excludesFile != null && !this.excludesFile.delete()) {
            LOGGER.log(Level.WARNING, "could not delete {0}", this.excludesFile);
        }
    }

    private List<String> createCommandList(String tempDirPath, File includesFile, String includes, File excludesFile, String excludes) {
        ArrayList<String> commandList = new ArrayList<String>();
        commandList.add("rdiff-backup");
        commandList.add("--terminal-verbosity");
        commandList.add("7");
        if (tempDirPath != null) {
            commandList.add("--tempdir");
            commandList.add(tempDirPath);
        }
        if (includes != null && includes.length() > 0) {
            this.writeTempFile(includesFile, includes);
            commandList.add("--include-globbing-filelist");
            commandList.add(includesFile.getPath());
        }
        if (excludes != null && excludes.length() > 0) {
            this.writeTempFile(excludesFile, excludes);
            commandList.add("--exclude-globbing-filelist");
            commandList.add(excludesFile.getPath());
        }
        return commandList;
    }

    private File getCurrentMirror(String backupDst) {
        File rdiffBackupDataDirectory = new File(backupDst + File.separator + "rdiff-backup-data");
        if (!rdiffBackupDataDirectory.exists()) {
            return null;
        }
        File[] currentBackup = rdiffBackupDataDirectory.listFiles(new FilenameFilter(){

            public boolean accept(File dir, String name) {
                return name.matches("current_mirror.*");
            }
        });
        return currentBackup.length == 0 ? null : currentBackup[0];
    }

    private void countRestoreFiles(File file) {
        this.currentFile = file.getAbsolutePath();
        this.restoreCounter.incrementAndGet();
        if (file.isDirectory()) {
            for (File subFile : file.listFiles()) {
                this.countRestoreFiles(subFile);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeTempFile(File tmpFile, String content) {
        FileWriter fileWriter = null;
        try {
            fileWriter = new FileWriter(tmpFile);
            fileWriter.write(content);
            fileWriter.flush();
        }
        catch (IOException ex) {
            LOGGER.log(Level.SEVERE, null, ex);
        }
        finally {
            if (fileWriter != null) {
                try {
                    fileWriter.close();
                }
                catch (IOException ex) {
                    LOGGER.log(Level.SEVERE, null, ex);
                }
            }
        }
    }

    private static String quoteRestorePath(String restorePath) {
        if (CurrentOperatingSystem.OS == OperatingSystem.Windows) {
            restorePath = (restorePath = restorePath.replace("\\", "/")).startsWith("//") ? restorePath.replace("//", "\\\\") : restorePath.replace(":", ":\\");
        }
        if (!restorePath.endsWith("/")) {
            restorePath = restorePath + '/';
        }
        return restorePath;
    }

    private static String quoteRestore(String restorePath) {
        if (CurrentOperatingSystem.OS == OperatingSystem.Windows) {
            restorePath = (restorePath = restorePath.replace("\\", "/")).startsWith("//") ? restorePath.replace("//", "\\\\\\\\") : restorePath.replace(":", ":\\\\");
        }
        return restorePath;
    }

    private class MyPropertyChangeListener
    implements PropertyChangeListener {
        private MyPropertyChangeListener() {
        }

        public void propertyChange(PropertyChangeEvent evt) {
            Object newValue = evt.getNewValue();
            if (newValue instanceof String) {
                String output = (String)newValue;
                if (output.startsWith(RdiffBackupRestore.PROCESSING_STRING)) {
                    RdiffBackupRestore.this.currentFile = output.substring(RdiffBackupRestore.PROCESSING_STRING.length());
                    RdiffBackupRestore.this.fileCounter.incrementAndGet();
                } else if (output.startsWith(RdiffBackupRestore.APPLYING_PATCH_STRING)) {
                    RdiffBackupRestore.this.currentFile = output.substring(RdiffBackupRestore.APPLYING_PATCH_STRING.length());
                }
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum RestoreState {
        Counting,
        Restoring;

    }
}

