/*
 * Decompiled with CFR 0.152.
 */
package ch.fhnw.jbackpack;

import ch.fhnw.jbackpack.IconManager;
import ch.fhnw.jbackpack.chooser.NoHiddenFilesSwingFileFilter;
import ch.fhnw.util.FileTools;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.text.MessageFormat;
import java.util.ResourceBundle;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JSeparator;
import javax.swing.filechooser.FileFilter;

public class SelectRestoreDirectoryDialog
extends JDialog {
    private static final ResourceBundle BUNDLE = ResourceBundle.getBundle("ch/fhnw/jbackpack/Strings");
    private static final FileFilter NO_HIDDEN_FILES_FILTER = NoHiddenFilesSwingFileFilter.getInstance();
    private File selectedDirectory;
    private boolean restore;
    private JFileChooser directoryChooser;
    private JSeparator jSeparator1;
    private JLabel warningLabel;

    public SelectRestoreDirectoryDialog(Frame parent) {
        super(parent, true);
        this.initComponents();
        this.warningLabel.setIcon(IconManager.WARNING_ICON);
        this.directoryChooser.addChoosableFileFilter(NO_HIDDEN_FILES_FILTER);
        this.directoryChooser.setFileFilter(NO_HIDDEN_FILES_FILTER);
        this.directoryChooser.setApproveButtonText(BUNDLE.getString("Restore"));
        this.pack();
        this.setLocationRelativeTo(parent);
        Dimension preferredSize = this.warningLabel.getPreferredSize();
        this.warningLabel.setMaximumSize(preferredSize);
        this.warningLabel.setMinimumSize(preferredSize);
    }

    public boolean restoreSelected() {
        return this.restore;
    }

    public File getSelectedDirectory() {
        return this.selectedDirectory;
    }

    private void initComponents() {
        this.warningLabel = new JLabel();
        this.jSeparator1 = new JSeparator();
        this.directoryChooser = new JFileChooser();
        this.setDefaultCloseOperation(2);
        ResourceBundle bundle = ResourceBundle.getBundle("ch/fhnw/jbackpack/Strings");
        this.setTitle(bundle.getString("SelectRestoreDirectoryDialog.title"));
        this.getContentPane().setLayout(new GridBagLayout());
        this.warningLabel.setText(bundle.getString("SelectRestoreDirectoryDialog.warningLabel.text"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.insets = new Insets(10, 10, 0, 10);
        this.getContentPane().add((Component)this.warningLabel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(10, 0, 0, 0);
        this.getContentPane().add((Component)this.jSeparator1, gridBagConstraints);
        this.directoryChooser.setDialogType(1);
        this.directoryChooser.setFileSelectionMode(1);
        this.directoryChooser.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                SelectRestoreDirectoryDialog.this.directoryChooserActionPerformed(evt);
            }
        });
        this.directoryChooser.addPropertyChangeListener(new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent evt) {
                SelectRestoreDirectoryDialog.this.directoryChooserPropertyChange(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.getContentPane().add((Component)this.directoryChooser, gridBagConstraints);
    }

    private void directoryChooserActionPerformed(ActionEvent evt) {
        if (evt.getActionCommand().equals("ApproveSelection")) {
            this.selectedDirectory = this.directoryChooser.getSelectedFile();
            if (this.selectedDirectory == null) {
                this.showError(BUNDLE.getString("Error_No_Restore_Directory"));
                return;
            }
            if (!FileTools.canWrite(this.selectedDirectory)) {
                String errorMessage = BUNDLE.getString("Error_Restore_Directory_Unwritable");
                errorMessage = MessageFormat.format(errorMessage, this.selectedDirectory);
                this.showError(errorMessage);
                return;
            }
            if (!this.selectedDirectory.setWritable(false)) {
                String errorMessage = BUNDLE.getString("Error_Restore_Directory_Unmodifiable");
                errorMessage = MessageFormat.format(errorMessage, this.selectedDirectory);
                this.showError(errorMessage);
                return;
            }
            this.selectedDirectory.setWritable(true);
            this.restore = true;
        }
        this.setVisible(false);
        this.dispose();
    }

    private void directoryChooserPropertyChange(PropertyChangeEvent evt) {
        if (evt.getPropertyName().equals("fileFilterChanged")) {
            this.directoryChooser.setFileHidingEnabled(this.directoryChooser.getFileFilter() == NO_HIDDEN_FILES_FILTER);
            this.directoryChooser.rescanCurrentDirectory();
        }
    }

    private void showError(String errorMessage) {
        JOptionPane.showMessageDialog(this, errorMessage, BUNDLE.getString("Error"), 0);
    }
}

