/*
 * Decompiled with CFR 0.152.
 */
package ch.fhnw.jbackpack.chooser;

import ch.fhnw.jbackpack.chooser.RdiffFileDatabase;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.DateFormat;
import java.text.MessageFormat;
import java.text.NumberFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.ResourceBundle;
import java.util.TimeZone;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JTextField;
import javax.swing.Timer;

public class DatabaseSyncDialog
extends JDialog {
    private static final DateFormat DATE_FORMAT = DateFormat.getDateTimeInstance();
    private static final NumberFormat NUMBER_FORMAT = NumberFormat.getIntegerInstance();
    private static final ResourceBundle BUNDLE = ResourceBundle.getBundle("ch/fhnw/jbackpack/Strings");
    private CardLayout cardLayout;
    private final DateFormat timeFormat;
    private final long start;
    private RdiffFileDatabase database;
    private Timer updateTimer = new Timer(1000, new ActionListener(){

        public void actionPerformed(ActionEvent e) {
            if (DatabaseSyncDialog.this.database == null) {
                DatabaseSyncDialog.this.cardLayout.show(DatabaseSyncDialog.this.cardPanel, "connectPanel");
            } else {
                switch (DatabaseSyncDialog.this.database.getSyncState()) {
                    case CHECKING: {
                        DatabaseSyncDialog.this.cardLayout.show(DatabaseSyncDialog.this.cardPanel, "connectPanel");
                        break;
                    }
                    case TRIMMING: {
                        DatabaseSyncDialog.this.cardLayout.show(DatabaseSyncDialog.this.cardPanel, "trimmingPanel");
                        DatabaseSyncDialog.this.updateProgressBar(DatabaseSyncDialog.this.trimmingBackupProgressBar);
                        break;
                    }
                    case SYNCING: {
                        DatabaseSyncDialog.this.cardLayout.show(DatabaseSyncDialog.this.cardPanel, "syncPanel");
                        DatabaseSyncDialog.this.updateProgressBar(DatabaseSyncDialog.this.syncBackupProgressBar);
                        DatabaseSyncDialog.this.fileTextField.setText(DatabaseSyncDialog.this.database.getCurrentFile());
                        DatabaseSyncDialog.this.fileTextField.setCaretPosition(0);
                        long directoryCounter = DatabaseSyncDialog.this.database.getDirectoryCounter();
                        DatabaseSyncDialog.this.directoryCounterTextField.setText(NUMBER_FORMAT.format(directoryCounter));
                        long fileCounter = DatabaseSyncDialog.this.database.getFileCounter();
                        DatabaseSyncDialog.this.fileCounterTextField.setText(NUMBER_FORMAT.format(fileCounter));
                        long sumCounter = directoryCounter + fileCounter;
                        DatabaseSyncDialog.this.sumCounterTextField.setText(NUMBER_FORMAT.format(sumCounter));
                        break;
                    }
                    case COMPRESSING: {
                        DatabaseSyncDialog.this.cardLayout.show(DatabaseSyncDialog.this.cardPanel, "compressPanel");
                    }
                }
            }
            long time = System.currentTimeMillis() - DatabaseSyncDialog.this.start;
            DatabaseSyncDialog.this.timeLabel.setText(DatabaseSyncDialog.this.timeFormat.format(time));
        }
    });
    private JPanel cardPanel;
    private JLabel compressLabel;
    private JPanel compressPanel;
    private JProgressBar compressProgressBar;
    private JLabel connectLabel;
    private JPanel connectPanel;
    private JProgressBar connectProgressBar;
    private JLabel directoryCounterLabel;
    private JTextField directoryCounterTextField;
    private JLabel fileCounterLabel;
    private JTextField fileCounterTextField;
    private JLabel fileLabel;
    private JTextField fileTextField;
    private JLabel sumCounterLabel;
    private JTextField sumCounterTextField;
    private JLabel syncBackupLabel;
    private JProgressBar syncBackupProgressBar;
    private JLabel syncLabel;
    private JPanel syncPanel;
    private JLabel timeLabel;
    private JLabel trimmingBackupLabel;
    private JProgressBar trimmingBackupProgressBar;
    private JPanel trimmingPanel;

    public DatabaseSyncDialog(Window parent) {
        super(parent, Dialog.ModalityType.APPLICATION_MODAL);
        this.timeFormat = new SimpleDateFormat("HH:mm:ss");
        this.timeFormat.setTimeZone(TimeZone.getTimeZone("GMT"));
        this.initComponents();
        this.setLocationRelativeTo(parent);
        this.cardLayout = (CardLayout)this.cardPanel.getLayout();
        this.start = System.currentTimeMillis();
        this.updateTimer.setInitialDelay(0);
        this.updateTimer.start();
    }

    public void setDatabase(RdiffFileDatabase database) {
        this.database = database;
    }

    private void initComponents() {
        this.cardPanel = new JPanel();
        this.trimmingPanel = new JPanel();
        this.trimmingBackupLabel = new JLabel();
        this.trimmingBackupProgressBar = new JProgressBar();
        this.connectPanel = new JPanel();
        this.connectLabel = new JLabel();
        this.connectProgressBar = new JProgressBar();
        this.syncPanel = new JPanel();
        this.syncLabel = new JLabel();
        this.syncBackupLabel = new JLabel();
        this.syncBackupProgressBar = new JProgressBar();
        this.fileLabel = new JLabel();
        this.fileTextField = new JTextField();
        this.directoryCounterLabel = new JLabel();
        this.directoryCounterTextField = new JTextField();
        this.fileCounterLabel = new JLabel();
        this.fileCounterTextField = new JTextField();
        this.sumCounterLabel = new JLabel();
        this.sumCounterTextField = new JTextField();
        this.compressPanel = new JPanel();
        this.compressLabel = new JLabel();
        this.compressProgressBar = new JProgressBar();
        this.timeLabel = new JLabel();
        this.setDefaultCloseOperation(0);
        ResourceBundle bundle = ResourceBundle.getBundle("ch/fhnw/jbackpack/Strings");
        this.setTitle(bundle.getString("DatabaseSyncDialog.title"));
        this.getContentPane().setLayout(new GridBagLayout());
        this.cardPanel.setLayout(new CardLayout());
        this.trimmingPanel.setLayout(new GridBagLayout());
        this.trimmingBackupLabel.setText(bundle.getString("DatabaseSyncDialog.trimmingBackupLabel.text"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        this.trimmingPanel.add((Component)this.trimmingBackupLabel, gridBagConstraints);
        this.trimmingBackupProgressBar.setStringPainted(true);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(5, 10, 0, 10);
        this.trimmingPanel.add((Component)this.trimmingBackupProgressBar, gridBagConstraints);
        this.cardPanel.add((Component)this.trimmingPanel, "trimmingPanel");
        this.connectPanel.setLayout(new GridBagLayout());
        this.connectLabel.setText(bundle.getString("DatabaseSyncDialog.connectLabel.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        this.connectPanel.add((Component)this.connectLabel, gridBagConstraints);
        this.connectProgressBar.setIndeterminate(true);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(5, 0, 0, 0);
        this.connectPanel.add((Component)this.connectProgressBar, gridBagConstraints);
        this.cardPanel.add((Component)this.connectPanel, "connectPanel");
        this.syncPanel.setLayout(new GridBagLayout());
        this.syncLabel.setText(bundle.getString("DatabaseSyncDialog.syncLabel.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.insets = new Insets(15, 0, 0, 0);
        this.syncPanel.add((Component)this.syncLabel, gridBagConstraints);
        this.syncBackupLabel.setText(bundle.getString("DatabaseSyncDialog.syncBackupLabel.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(10, 10, 0, 0);
        this.syncPanel.add((Component)this.syncBackupLabel, gridBagConstraints);
        this.syncBackupProgressBar.setStringPainted(true);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(10, 5, 0, 10);
        this.syncPanel.add((Component)this.syncBackupProgressBar, gridBagConstraints);
        this.fileLabel.setText(bundle.getString("DatabaseSyncDialog.fileLabel.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(5, 10, 0, 0);
        this.syncPanel.add((Component)this.fileLabel, gridBagConstraints);
        this.fileTextField.setColumns(40);
        this.fileTextField.setEditable(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(5, 5, 0, 10);
        this.syncPanel.add((Component)this.fileTextField, gridBagConstraints);
        this.directoryCounterLabel.setText(bundle.getString("DatabaseSyncDialog.directoryCounterLabel.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(5, 10, 0, 0);
        this.syncPanel.add((Component)this.directoryCounterLabel, gridBagConstraints);
        this.directoryCounterTextField.setColumns(10);
        this.directoryCounterTextField.setEditable(false);
        this.directoryCounterTextField.setHorizontalAlignment(11);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(5, 5, 0, 10);
        this.syncPanel.add((Component)this.directoryCounterTextField, gridBagConstraints);
        this.fileCounterLabel.setText(bundle.getString("DatabaseSyncDialog.fileCounterLabel.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(2, 10, 0, 0);
        this.syncPanel.add((Component)this.fileCounterLabel, gridBagConstraints);
        this.fileCounterTextField.setColumns(10);
        this.fileCounterTextField.setEditable(false);
        this.fileCounterTextField.setHorizontalAlignment(11);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(2, 5, 0, 10);
        this.syncPanel.add((Component)this.fileCounterTextField, gridBagConstraints);
        this.sumCounterLabel.setText(bundle.getString("DatabaseSyncDialog.sumCounterLabel.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(2, 10, 10, 0);
        this.syncPanel.add((Component)this.sumCounterLabel, gridBagConstraints);
        this.sumCounterTextField.setColumns(10);
        this.sumCounterTextField.setEditable(false);
        this.sumCounterTextField.setHorizontalAlignment(11);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(2, 5, 10, 10);
        this.syncPanel.add((Component)this.sumCounterTextField, gridBagConstraints);
        this.cardPanel.add((Component)this.syncPanel, "syncPanel");
        this.compressPanel.setLayout(new GridBagLayout());
        this.compressLabel.setText(bundle.getString("DatabaseSyncDialog.compressLabel.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        this.compressPanel.add((Component)this.compressLabel, gridBagConstraints);
        this.compressProgressBar.setIndeterminate(true);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(5, 0, 0, 0);
        this.compressPanel.add((Component)this.compressProgressBar, gridBagConstraints);
        this.cardPanel.add((Component)this.compressPanel, "compressPanel");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        this.getContentPane().add((Component)this.cardPanel, gridBagConstraints);
        this.timeLabel.setText(bundle.getString("DatabaseSyncDialog.timeLabel.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(5, 19, 10, 0);
        this.getContentPane().add((Component)this.timeLabel, gridBagConstraints);
        this.pack();
    }

    private void updateProgressBar(JProgressBar progressbar) {
        int maxIncrementCounter = this.database.getMaxIncrementCounter();
        Date currentTimestamp = this.database.getCurrentTimestamp();
        if (currentTimestamp == null) {
            return;
        }
        String dateString = DATE_FORMAT.format(currentTimestamp);
        if (maxIncrementCounter == 0) {
            progressbar.setString(dateString);
        } else {
            int incrementCounter = this.database.getIncrementCounter();
            String string = BUNDLE.getString("SyncProgress");
            string = MessageFormat.format(string, dateString, incrementCounter, maxIncrementCounter);
            progressbar.setString(string);
            int progress = incrementCounter * 100 / maxIncrementCounter;
            progressbar.setValue(progress);
        }
    }
}

