/*
 * Decompiled with CFR 0.152.
 */
package ch.fhnw.util;

import ch.fhnw.util.FileTools;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicLong;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PlainDirChecker {
    private final int maxFilenameLength;
    private final AtomicLong size = new AtomicLong();
    private final AtomicLong fileCounter = new AtomicLong();
    private final List<File> tooLongFiles;
    private File currentFile;
    private boolean run = true;

    public PlainDirChecker(int maxFilenameLength) {
        this.maxFilenameLength = maxFilenameLength;
        this.tooLongFiles = new ArrayList<File>();
    }

    public void check(File file) throws IOException {
        if (!this.run) {
            return;
        }
        this.fileCounter.incrementAndGet();
        this.currentFile = file;
        if (file.getName().length() > this.maxFilenameLength) {
            this.tooLongFiles.add(file);
        }
        if (FileTools.isSymlink(file)) {
            return;
        }
        if (file.isDirectory()) {
            for (File subFile : file.listFiles()) {
                this.check(subFile);
            }
        } else {
            this.size.addAndGet(file.length());
        }
    }

    public long getCurrentSize() {
        return this.size.get();
    }

    public long getFileCounter() {
        return this.fileCounter.get();
    }

    public List<File> getTooLongFiles() {
        return this.tooLongFiles;
    }

    public File getCurrentFile() {
        return this.currentFile;
    }

    public void stop() {
        this.run = false;
    }

    public void reset() {
        this.run = true;
        this.size.set(0L);
    }
}

